/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util;

import edu.emory.mathcs.backport.java.util.AbstractMap;
import edu.emory.mathcs.backport.java.util.Collections;
import edu.emory.mathcs.backport.java.util.NavigableMap;
import edu.emory.mathcs.backport.java.util.NavigableSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class TreeMap
extends AbstractMap
implements NavigableMap,
Serializable {
    private static final long serialVersionUID = 919286545866124006L;
    private final Comparator comparator;
    private transient Entry root;
    private transient int size = 0;
    private transient int modCount = 0;
    private transient EntrySet entrySet;
    private transient KeySet navigableKeySet;
    private transient NavigableMap descendingMap;
    private transient Comparator reverseComparator;

    public TreeMap() {
        this.comparator = null;
    }

    public TreeMap(Comparator comparator) {
        this.comparator = comparator;
    }

    public TreeMap(SortedMap map) {
        this.comparator = map.comparator();
        this.buildFromSorted(map.entrySet().iterator(), map.size());
    }

    public TreeMap(Map map) {
        this.comparator = null;
        this.putAll(map);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.root = null;
        this.size = 0;
        ++this.modCount;
    }

    public Object clone() {
        TreeMap clone;
        try {
            clone = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.root = null;
        clone.size = 0;
        clone.modCount = 0;
        if (!this.isEmpty()) {
            clone.buildFromSorted(this.entrySet().iterator(), this.size);
        }
        return clone;
    }

    public Object put(Object key, Object value) {
        if (this.root == null) {
            this.root = new Entry(key, value);
            ++this.size;
            ++this.modCount;
            return null;
        }
        Entry t = this.root;
        while (true) {
            int diff;
            if ((diff = TreeMap.compare(key, t.getKey(), this.comparator)) == 0) {
                return t.setValue(value);
            }
            if (diff <= 0) {
                if (t.left != null) {
                    t = t.left;
                    continue;
                }
                ++this.size;
                ++this.modCount;
                Entry e = new Entry(key, value);
                e.parent = t;
                t.left = e;
                this.fixAfterInsertion(e);
                return null;
            }
            if (t.right == null) break;
            t = t.right;
        }
        ++this.size;
        ++this.modCount;
        Entry e = new Entry(key, value);
        e.parent = t;
        t.right = e;
        this.fixAfterInsertion(e);
        return null;
    }

    public Object get(Object key) {
        Entry entry = this.getEntry(key);
        return entry == null ? null : entry.getValue();
    }

    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private static Entry successor(Entry e) {
        if (e.right != null) {
            e = e.right;
            while (e.left != null) {
                e = e.left;
            }
            return e;
        }
        Entry p = e.parent;
        while (p != null && e == p.right) {
            e = p;
            p = p.parent;
        }
        return p;
    }

    private static Entry predecessor(Entry e) {
        if (e.left != null) {
            e = e.left;
            while (e.right != null) {
                e = e.right;
            }
            return e;
        }
        Entry p = e.parent;
        while (p != null && e == p.left) {
            e = p;
            p = p.parent;
        }
        return p;
    }

    private Entry getEntry(Object key) {
        Entry t = this.root;
        if (this.comparator != null) {
            while (true) {
                if (t == null) {
                    return null;
                }
                int diff = this.comparator.compare(key, t.key);
                if (diff == 0) {
                    return t;
                }
                t = diff < 0 ? t.left : t.right;
            }
        }
        Comparable c2 = (Comparable)key;
        while (t != null) {
            int diff = c2.compareTo(t.key);
            if (diff == 0) {
                return t;
            }
            t = diff < 0 ? t.left : t.right;
        }
        return null;
    }

    private Entry getHigherEntry(Object key) {
        Entry t = this.root;
        if (t == null) {
            return null;
        }
        while (true) {
            int diff;
            if ((diff = TreeMap.compare(key, t.key, this.comparator)) < 0) {
                if (t.left != null) {
                    t = t.left;
                    continue;
                }
                return t;
            }
            if (t.right == null) break;
            t = t.right;
        }
        Entry parent = t.parent;
        while (parent != null && t == parent.right) {
            t = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private Entry getFirstEntry() {
        Entry e = this.root;
        if (e == null) {
            return null;
        }
        while (e.left != null) {
            e = e.left;
        }
        return e;
    }

    private Entry getLastEntry() {
        Entry e = this.root;
        if (e == null) {
            return null;
        }
        while (e.right != null) {
            e = e.right;
        }
        return e;
    }

    private Entry getCeilingEntry(Object key) {
        Entry e;
        block5: {
            e = this.root;
            if (e == null) {
                return null;
            }
            while (true) {
                int diff;
                if ((diff = TreeMap.compare(key, e.key, this.comparator)) < 0) {
                    if (e.left != null) {
                        e = e.left;
                        continue;
                    }
                    return e;
                }
                if (diff <= 0) break block5;
                if (e.right == null) break;
                e = e.right;
            }
            Entry p = e.parent;
            while (p != null && e == p.right) {
                e = p;
                p = p.parent;
            }
            return p;
        }
        return e;
    }

    private Entry getLowerEntry(Object key) {
        Entry e = this.root;
        if (e == null) {
            return null;
        }
        while (true) {
            int diff;
            if ((diff = TreeMap.compare(key, e.key, this.comparator)) > 0) {
                if (e.right != null) {
                    e = e.right;
                    continue;
                }
                return e;
            }
            if (e.left == null) break;
            e = e.left;
        }
        Entry p = e.parent;
        while (p != null && e == p.left) {
            e = p;
            p = p.parent;
        }
        return p;
    }

    private Entry getFloorEntry(Object key) {
        Entry e;
        block5: {
            e = this.root;
            if (e == null) {
                return null;
            }
            while (true) {
                int diff;
                if ((diff = TreeMap.compare(key, e.key, this.comparator)) > 0) {
                    if (e.right != null) {
                        e = e.right;
                        continue;
                    }
                    return e;
                }
                if (diff >= 0) break block5;
                if (e.left == null) break;
                e = e.left;
            }
            Entry p = e.parent;
            while (p != null && e == p.left) {
                e = p;
                p = p.parent;
            }
            return p;
        }
        return e;
    }

    void buildFromSorted(Iterator itr, int size) {
        ++this.modCount;
        this.size = size;
        int bottom = 0;
        int ssize = 1;
        while (ssize - 1 < size) {
            ++bottom;
            ssize <<= 1;
        }
        this.root = TreeMap.createFromSorted(itr, size, 0, bottom);
    }

    private static Entry createFromSorted(Iterator itr, int size, int level, int bottom) {
        ++level;
        if (size == 0) {
            return null;
        }
        int leftSize = size - 1 >> 1;
        int rightSize = size - 1 - leftSize;
        Entry left = TreeMap.createFromSorted(itr, leftSize, level, bottom);
        Map.Entry orig = (Map.Entry)itr.next();
        Entry right = TreeMap.createFromSorted(itr, rightSize, level, bottom);
        Entry e = new Entry(orig.getKey(), orig.getValue());
        if (left != null) {
            e.left = left;
            left.parent = e;
        }
        if (right != null) {
            e.right = right;
            right.parent = e;
        }
        if (level == bottom) {
            e.color = false;
        }
        return e;
    }

    private void delete(Entry e) {
        if (e.left == null && e.right == null && e.parent == null) {
            this.root = null;
            this.size = 0;
            ++this.modCount;
            return;
        }
        if (e.left != null && e.right != null) {
            Entry s = TreeMap.successor(e);
            e.key = s.key;
            e.element = s.element;
            e = s;
        }
        if (e.left == null && e.right == null) {
            if (e.color) {
                this.fixAfterDeletion(e);
            }
            if (e.parent != null) {
                if (e == e.parent.left) {
                    e.parent.left = null;
                } else if (e == e.parent.right) {
                    e.parent.right = null;
                }
                e.parent = null;
            }
        } else {
            Entry replacement = e.left;
            if (replacement == null) {
                replacement = e.right;
            }
            replacement.parent = e.parent;
            if (e.parent == null) {
                this.root = replacement;
            } else if (e == e.parent.left) {
                e.parent.left = replacement;
            } else {
                e.parent.right = replacement;
            }
            e.left = null;
            e.right = null;
            e.parent = null;
            if (e.color) {
                this.fixAfterDeletion(replacement);
            }
        }
        --this.size;
        ++this.modCount;
    }

    static boolean colorOf(Entry p) {
        return p == null ? true : p.color;
    }

    static Entry parentOf(Entry p) {
        return p == null ? null : p.parent;
    }

    private static void setColor(Entry p, boolean c2) {
        if (p != null) {
            p.color = c2;
        }
    }

    private static Entry leftOf(Entry p) {
        return p == null ? null : p.left;
    }

    private static Entry rightOf(Entry p) {
        return p == null ? null : p.right;
    }

    private final void rotateLeft(Entry e) {
        Entry r = e.right;
        e.right = r.left;
        if (r.left != null) {
            r.left.parent = e;
        }
        r.parent = e.parent;
        if (e.parent == null) {
            this.root = r;
        } else if (e.parent.left == e) {
            e.parent.left = r;
        } else {
            e.parent.right = r;
        }
        r.left = e;
        e.parent = r;
    }

    private final void rotateRight(Entry e) {
        Entry l = e.left;
        e.left = l.right;
        if (l.right != null) {
            l.right.parent = e;
        }
        l.parent = e.parent;
        if (e.parent == null) {
            this.root = l;
        } else if (e.parent.right == e) {
            e.parent.right = l;
        } else {
            e.parent.left = l;
        }
        l.right = e;
        e.parent = l;
    }

    private final void fixAfterInsertion(Entry e) {
        e.color = false;
        Entry x = e;
        while (x != null && x != this.root && !x.parent.color) {
            Entry y;
            if (TreeMap.parentOf(x) == TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(x)))) {
                y = TreeMap.rightOf(TreeMap.parentOf(TreeMap.parentOf(x)));
                if (!TreeMap.colorOf(y)) {
                    TreeMap.setColor(TreeMap.parentOf(x), true);
                    TreeMap.setColor(y, true);
                    TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
                    x = TreeMap.parentOf(TreeMap.parentOf(x));
                    continue;
                }
                if (x == TreeMap.rightOf(TreeMap.parentOf(x))) {
                    x = TreeMap.parentOf(x);
                    this.rotateLeft(x);
                }
                TreeMap.setColor(TreeMap.parentOf(x), true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
                if (TreeMap.parentOf(TreeMap.parentOf(x)) == null) continue;
                this.rotateRight(TreeMap.parentOf(TreeMap.parentOf(x)));
                continue;
            }
            y = TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(x)));
            if (!TreeMap.colorOf(y)) {
                TreeMap.setColor(TreeMap.parentOf(x), true);
                TreeMap.setColor(y, true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
                x = TreeMap.parentOf(TreeMap.parentOf(x));
                continue;
            }
            if (x == TreeMap.leftOf(TreeMap.parentOf(x))) {
                x = TreeMap.parentOf(x);
                this.rotateRight(x);
            }
            TreeMap.setColor(TreeMap.parentOf(x), true);
            TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
            if (TreeMap.parentOf(TreeMap.parentOf(x)) == null) continue;
            this.rotateLeft(TreeMap.parentOf(TreeMap.parentOf(x)));
        }
        this.root.color = true;
    }

    private final Entry fixAfterDeletion(Entry e) {
        Entry x = e;
        while (x != this.root && TreeMap.colorOf(x)) {
            Entry sib;
            if (x == TreeMap.leftOf(TreeMap.parentOf(x))) {
                sib = TreeMap.rightOf(TreeMap.parentOf(x));
                if (!TreeMap.colorOf(sib)) {
                    TreeMap.setColor(sib, true);
                    TreeMap.setColor(TreeMap.parentOf(x), false);
                    this.rotateLeft(TreeMap.parentOf(x));
                    sib = TreeMap.rightOf(TreeMap.parentOf(x));
                }
                if (TreeMap.colorOf(TreeMap.leftOf(sib)) && TreeMap.colorOf(TreeMap.rightOf(sib))) {
                    TreeMap.setColor(sib, false);
                    x = TreeMap.parentOf(x);
                    continue;
                }
                if (TreeMap.colorOf(TreeMap.rightOf(sib))) {
                    TreeMap.setColor(TreeMap.leftOf(sib), true);
                    TreeMap.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = TreeMap.rightOf(TreeMap.parentOf(x));
                }
                TreeMap.setColor(sib, TreeMap.colorOf(TreeMap.parentOf(x)));
                TreeMap.setColor(TreeMap.parentOf(x), true);
                TreeMap.setColor(TreeMap.rightOf(sib), true);
                this.rotateLeft(TreeMap.parentOf(x));
                x = this.root;
                continue;
            }
            sib = TreeMap.leftOf(TreeMap.parentOf(x));
            if (!TreeMap.colorOf(sib)) {
                TreeMap.setColor(sib, true);
                TreeMap.setColor(TreeMap.parentOf(x), false);
                this.rotateRight(TreeMap.parentOf(x));
                sib = TreeMap.leftOf(TreeMap.parentOf(x));
            }
            if (TreeMap.colorOf(TreeMap.rightOf(sib)) && TreeMap.colorOf(TreeMap.leftOf(sib))) {
                TreeMap.setColor(sib, false);
                x = TreeMap.parentOf(x);
                continue;
            }
            if (TreeMap.colorOf(TreeMap.leftOf(sib))) {
                TreeMap.setColor(TreeMap.rightOf(sib), true);
                TreeMap.setColor(sib, false);
                this.rotateLeft(sib);
                sib = TreeMap.leftOf(TreeMap.parentOf(x));
            }
            TreeMap.setColor(sib, TreeMap.colorOf(TreeMap.parentOf(x)));
            TreeMap.setColor(TreeMap.parentOf(x), true);
            TreeMap.setColor(TreeMap.leftOf(sib), true);
            this.rotateRight(TreeMap.parentOf(x));
            x = this.root;
        }
        TreeMap.setColor(x, true);
        return this.root;
    }

    private Entry getMatchingEntry(Object o) {
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry e = (Map.Entry)o;
        Entry found = this.getEntry(e.getKey());
        return found != null && TreeMap.eq(found.getValue(), e.getValue()) ? found : null;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static int compare(Object o1, Object o2, Comparator cmp) {
        return cmp == null ? ((Comparable)o1).compareTo(o2) : cmp.compare(o1, o2);
    }

    public Map.Entry lowerEntry(Object key) {
        Entry e = this.getLowerEntry(key);
        return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
    }

    public Object lowerKey(Object key) {
        Entry e = this.getLowerEntry(key);
        return e == null ? null : e.getKey();
    }

    public Map.Entry floorEntry(Object key) {
        Entry e = this.getFloorEntry(key);
        return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
    }

    public Object floorKey(Object key) {
        Entry e = this.getFloorEntry(key);
        return e == null ? null : e.key;
    }

    public Map.Entry ceilingEntry(Object key) {
        Entry e = this.getCeilingEntry(key);
        return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
    }

    public Object ceilingKey(Object key) {
        Entry e = this.getCeilingEntry(key);
        return e == null ? null : e.key;
    }

    public Map.Entry higherEntry(Object key) {
        Entry e = this.getHigherEntry(key);
        return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
    }

    public Object higherKey(Object key) {
        Entry e = this.getHigherEntry(key);
        return e == null ? null : e.key;
    }

    public Map.Entry firstEntry() {
        Entry e = this.getFirstEntry();
        return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
    }

    public Map.Entry lastEntry() {
        Entry e = this.getLastEntry();
        return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
    }

    public Map.Entry pollFirstEntry() {
        Entry e = this.getFirstEntry();
        if (e == null) {
            return null;
        }
        AbstractMap.SimpleImmutableEntry res = new AbstractMap.SimpleImmutableEntry(e);
        this.delete(e);
        return res;
    }

    public Map.Entry pollLastEntry() {
        Entry e = this.getLastEntry();
        if (e == null) {
            return null;
        }
        AbstractMap.SimpleImmutableEntry res = new AbstractMap.SimpleImmutableEntry(e);
        this.delete(e);
        return res;
    }

    public NavigableMap descendingMap() {
        NavigableMap map = this.descendingMap;
        if (map == null) {
            this.descendingMap = map = new DescendingSubMap(true, null, true, true, null, true);
        }
        return map;
    }

    public NavigableSet descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    public SortedMap headMap(Object toKey) {
        return this.headMap(toKey, false);
    }

    public SortedMap tailMap(Object fromKey) {
        return this.tailMap(fromKey, true);
    }

    public NavigableMap subMap(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive) {
        return new AscendingSubMap(false, fromKey, fromInclusive, false, toKey, toInclusive);
    }

    public NavigableMap headMap(Object toKey, boolean toInclusive) {
        return new AscendingSubMap(true, null, true, false, toKey, toInclusive);
    }

    public NavigableMap tailMap(Object fromKey, boolean fromInclusive) {
        return new AscendingSubMap(false, fromKey, fromInclusive, true, null, true);
    }

    public Comparator comparator() {
        return this.comparator;
    }

    final Comparator reverseComparator() {
        if (this.reverseComparator == null) {
            this.reverseComparator = Collections.reverseOrder(this.comparator);
        }
        return this.reverseComparator;
    }

    public Object firstKey() {
        Entry e = this.getFirstEntry();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.key;
    }

    public Object lastKey() {
        Entry e = this.getLastEntry();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.key;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsValue(Object value) {
        if (this.root == null) {
            return false;
        }
        return value == null ? TreeMap.containsNull(this.root) : TreeMap.containsValue(this.root, value);
    }

    private static boolean containsNull(Entry e) {
        if (e.element == null) {
            return true;
        }
        if (e.left != null && TreeMap.containsNull(e.left)) {
            return true;
        }
        return e.right != null && TreeMap.containsNull(e.right);
    }

    private static boolean containsValue(Entry e, Object val) {
        if (val.equals(e.element)) {
            return true;
        }
        if (e.left != null && TreeMap.containsValue(e.left, val)) {
            return true;
        }
        return e.right != null && TreeMap.containsValue(e.right, val);
    }

    public Object remove(Object key) {
        Entry e = this.getEntry(key);
        if (e == null) {
            return null;
        }
        Object old = e.getValue();
        this.delete(e);
        return old;
    }

    public void putAll(Map map) {
        SortedMap smap;
        if (map instanceof SortedMap && TreeMap.eq(this.comparator, (smap = (SortedMap)map).comparator())) {
            this.buildFromSorted(smap.entrySet().iterator(), map.size());
            return;
        }
        super.putAll(map);
    }

    public Set keySet() {
        return this.navigableKeySet();
    }

    public NavigableSet navigableKeySet() {
        if (this.navigableKeySet == null) {
            this.navigableKeySet = new AscendingKeySet();
        }
        return this.navigableKeySet;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        Entry e = this.getFirstEntry();
        while (e != null) {
            out.writeObject(e.key);
            out.writeObject(e.element);
            e = TreeMap.successor(e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = in.readInt();
        try {
            this.buildFromSorted(new IOIterator(in, size), size);
        }
        catch (IteratorIOException e) {
            throw e.getException();
        }
        catch (IteratorNoClassException e) {
            throw e.getException();
        }
    }

    private class SubMap
    extends AbstractMap
    implements Serializable,
    NavigableMap {
        private static final long serialVersionUID = -6520786458950516097L;
        final Object fromKey = null;
        final Object toKey = null;

        SubMap() {
        }

        private Object readResolve() {
            return new AscendingSubMap(this.fromKey == null, this.fromKey, true, this.toKey == null, this.toKey, false);
        }

        public Map.Entry lowerEntry(Object key) {
            throw new Error();
        }

        public Object lowerKey(Object key) {
            throw new Error();
        }

        public Map.Entry floorEntry(Object key) {
            throw new Error();
        }

        public Object floorKey(Object key) {
            throw new Error();
        }

        public Map.Entry ceilingEntry(Object key) {
            throw new Error();
        }

        public Object ceilingKey(Object key) {
            throw new Error();
        }

        public Map.Entry higherEntry(Object key) {
            throw new Error();
        }

        public Object higherKey(Object key) {
            throw new Error();
        }

        public Map.Entry firstEntry() {
            throw new Error();
        }

        public Map.Entry lastEntry() {
            throw new Error();
        }

        public Map.Entry pollFirstEntry() {
            throw new Error();
        }

        public Map.Entry pollLastEntry() {
            throw new Error();
        }

        public NavigableMap descendingMap() {
            throw new Error();
        }

        public NavigableSet navigableKeySet() {
            throw new Error();
        }

        public NavigableSet descendingKeySet() {
            throw new Error();
        }

        public Set entrySet() {
            throw new Error();
        }

        public NavigableMap subMap(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive) {
            throw new Error();
        }

        public NavigableMap headMap(Object toKey, boolean inclusive) {
            throw new Error();
        }

        public NavigableMap tailMap(Object fromKey, boolean inclusive) {
            throw new Error();
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            throw new Error();
        }

        public SortedMap headMap(Object toKey) {
            throw new Error();
        }

        public SortedMap tailMap(Object fromKey) {
            throw new Error();
        }

        public Comparator comparator() {
            throw new Error();
        }

        public Object firstKey() {
            throw new Error();
        }

        public Object lastKey() {
            throw new Error();
        }
    }

    static class IOIterator
    implements Iterator {
        final ObjectInputStream ois;
        int remaining;

        IOIterator(ObjectInputStream ois, int remaining) {
            this.ois = ois;
            this.remaining = remaining;
        }

        public boolean hasNext() {
            return this.remaining > 0;
        }

        public Object next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            --this.remaining;
            try {
                return new AbstractMap.SimpleImmutableEntry(this.ois.readObject(), this.ois.readObject());
            }
            catch (IOException e) {
                throw new IteratorIOException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IteratorNoClassException(e);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class IteratorNoClassException
    extends RuntimeException {
        IteratorNoClassException(ClassNotFoundException e) {
            super(e);
        }

        ClassNotFoundException getException() {
            return (ClassNotFoundException)this.getCause();
        }
    }

    static class IteratorIOException
    extends RuntimeException {
        IteratorIOException(IOException e) {
            super(e);
        }

        IOException getException() {
            return (IOException)this.getCause();
        }
    }

    class DescendingSubMap
    extends NavigableSubMap {
        DescendingSubMap(boolean fromStart, Object fromKey, boolean fromInclusive, boolean toEnd, Object toKey, boolean toInclusive) {
            super(fromStart, fromKey, fromInclusive, toEnd, toKey, toInclusive);
        }

        public Comparator comparator() {
            return TreeMap.this.reverseComparator();
        }

        protected Entry first() {
            return this.absHighest();
        }

        protected Entry last() {
            return this.absLowest();
        }

        protected Entry lower(Object key) {
            return this.absHigher(key);
        }

        protected Entry floor(Object key) {
            return this.absCeiling(key);
        }

        protected Entry ceiling(Object key) {
            return this.absFloor(key);
        }

        protected Entry higher(Object key) {
            return this.absLower(key);
        }

        protected Entry uncheckedHigher(Entry e) {
            return TreeMap.predecessor(e);
        }

        public NavigableMap subMap(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap(false, toKey, toInclusive, false, fromKey, fromInclusive);
        }

        public NavigableMap headMap(Object toKey, boolean toInclusive) {
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap(false, toKey, toInclusive, this.toEnd, this.toKey, this.toInclusive);
        }

        public NavigableMap tailMap(Object fromKey, boolean fromInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new DescendingSubMap(this.fromStart, this.fromKey, this.fromInclusive, false, fromKey, fromInclusive);
        }

        public NavigableMap descendingMap() {
            if (this.descendingMap == null) {
                this.descendingMap = new AscendingSubMap(this.fromStart, this.fromKey, this.fromInclusive, this.toEnd, this.toKey, this.toInclusive);
            }
            return this.descendingMap;
        }
    }

    class AscendingSubMap
    extends NavigableSubMap {
        AscendingSubMap(boolean fromStart, Object fromKey, boolean fromInclusive, boolean toEnd, Object toKey, boolean toInclusive) {
            super(fromStart, fromKey, fromInclusive, toEnd, toKey, toInclusive);
        }

        public Comparator comparator() {
            return TreeMap.this.comparator;
        }

        protected Entry first() {
            return this.absLowest();
        }

        protected Entry last() {
            return this.absHighest();
        }

        protected Entry lower(Object key) {
            return this.absLower(key);
        }

        protected Entry floor(Object key) {
            return this.absFloor(key);
        }

        protected Entry ceiling(Object key) {
            return this.absCeiling(key);
        }

        protected Entry higher(Object key) {
            return this.absHigher(key);
        }

        protected Entry uncheckedHigher(Entry e) {
            return TreeMap.successor(e);
        }

        public NavigableMap subMap(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap(false, fromKey, fromInclusive, false, toKey, toInclusive);
        }

        public NavigableMap headMap(Object toKey, boolean toInclusive) {
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap(this.fromStart, this.fromKey, this.fromInclusive, false, toKey, toInclusive);
        }

        public NavigableMap tailMap(Object fromKey, boolean fromInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new AscendingSubMap(false, fromKey, fromInclusive, this.toEnd, this.toKey, this.toInclusive);
        }

        public NavigableMap descendingMap() {
            if (this.descendingMap == null) {
                this.descendingMap = new DescendingSubMap(this.fromStart, this.fromKey, this.fromInclusive, this.toEnd, this.toKey, this.toInclusive);
            }
            return this.descendingMap;
        }
    }

    private abstract class NavigableSubMap
    extends AbstractMap
    implements NavigableMap,
    Serializable {
        private static final long serialVersionUID = -6520786458950516097L;
        final Object fromKey;
        final Object toKey;
        final boolean fromStart;
        final boolean toEnd;
        final boolean fromInclusive;
        final boolean toInclusive;
        transient int cachedSize = -1;
        transient int cacheVersion;
        transient SubEntrySet entrySet;
        transient NavigableMap descendingMap;
        transient NavigableSet navigableKeySet;

        NavigableSubMap(boolean fromStart, Object fromKey, boolean fromInclusive, boolean toEnd, Object toKey, boolean toInclusive) {
            if (!fromStart && !toEnd) {
                if (TreeMap.compare(fromKey, toKey, TreeMap.this.comparator) > 0) {
                    throw new IllegalArgumentException("fromKey > toKey");
                }
            } else {
                if (!fromStart) {
                    TreeMap.compare(fromKey, fromKey, TreeMap.this.comparator);
                }
                if (!toEnd) {
                    TreeMap.compare(toKey, toKey, TreeMap.this.comparator);
                }
            }
            this.fromStart = fromStart;
            this.toEnd = toEnd;
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromInclusive = fromInclusive;
            this.toInclusive = toInclusive;
        }

        final Entry checkLoRange(Entry e) {
            return e == null || this.absTooLow(e.key) ? null : e;
        }

        final Entry checkHiRange(Entry e) {
            return e == null || this.absTooHigh(e.key) ? null : e;
        }

        final boolean inRange(Object key) {
            return !this.absTooLow(key) && !this.absTooHigh(key);
        }

        final boolean inRangeExclusive(Object key) {
            return !(!this.fromStart && TreeMap.compare(key, this.fromKey, TreeMap.this.comparator) < 0 || !this.toEnd && TreeMap.compare(this.toKey, key, TreeMap.this.comparator) < 0);
        }

        final boolean inRange(Object key, boolean inclusive) {
            return inclusive ? this.inRange(key) : this.inRangeExclusive(key);
        }

        private boolean absTooHigh(Object key) {
            if (this.toEnd) {
                return false;
            }
            int c2 = TreeMap.compare(key, this.toKey, TreeMap.this.comparator);
            return c2 > 0 || c2 == 0 && !this.toInclusive;
        }

        private boolean absTooLow(Object key) {
            if (this.fromStart) {
                return false;
            }
            int c2 = TreeMap.compare(key, this.fromKey, TreeMap.this.comparator);
            return c2 < 0 || c2 == 0 && !this.fromInclusive;
        }

        protected abstract Entry first();

        protected abstract Entry last();

        protected abstract Entry lower(Object var1);

        protected abstract Entry floor(Object var1);

        protected abstract Entry ceiling(Object var1);

        protected abstract Entry higher(Object var1);

        protected abstract Entry uncheckedHigher(Entry var1);

        final Entry absLowest() {
            return this.checkHiRange(this.fromStart ? TreeMap.this.getFirstEntry() : (this.fromInclusive ? TreeMap.this.getCeilingEntry(this.fromKey) : TreeMap.this.getHigherEntry(this.fromKey)));
        }

        final Entry absHighest() {
            return this.checkLoRange(this.toEnd ? TreeMap.this.getLastEntry() : (this.toInclusive ? TreeMap.this.getFloorEntry(this.toKey) : TreeMap.this.getLowerEntry(this.toKey)));
        }

        final Entry absLower(Object key) {
            return this.absTooHigh(key) ? this.absHighest() : this.checkLoRange(TreeMap.this.getLowerEntry(key));
        }

        final Entry absFloor(Object key) {
            return this.absTooHigh(key) ? this.absHighest() : this.checkLoRange(TreeMap.this.getFloorEntry(key));
        }

        final Entry absCeiling(Object key) {
            return this.absTooLow(key) ? this.absLowest() : this.checkHiRange(TreeMap.this.getCeilingEntry(key));
        }

        final Entry absHigher(Object key) {
            return this.absTooLow(key) ? this.absLowest() : this.checkHiRange(TreeMap.this.getHigherEntry(key));
        }

        public Map.Entry firstEntry() {
            Entry e = this.first();
            return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
        }

        public Object firstKey() {
            Entry e = this.first();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        public Map.Entry lastEntry() {
            Entry e = this.last();
            return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
        }

        public Object lastKey() {
            Entry e = this.last();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        public Map.Entry pollFirstEntry() {
            Entry e = this.first();
            if (e == null) {
                return null;
            }
            AbstractMap.SimpleImmutableEntry result = new AbstractMap.SimpleImmutableEntry(e);
            TreeMap.this.delete(e);
            return result;
        }

        public Map.Entry pollLastEntry() {
            Entry e = this.last();
            if (e == null) {
                return null;
            }
            AbstractMap.SimpleImmutableEntry result = new AbstractMap.SimpleImmutableEntry(e);
            TreeMap.this.delete(e);
            return result;
        }

        public Map.Entry lowerEntry(Object key) {
            Entry e = this.lower(key);
            return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
        }

        public Object lowerKey(Object key) {
            Entry e = this.lower(key);
            return e == null ? null : e.key;
        }

        public Map.Entry floorEntry(Object key) {
            Entry e = this.floor(key);
            return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
        }

        public Object floorKey(Object key) {
            Entry e = this.floor(key);
            return e == null ? null : e.key;
        }

        public Map.Entry ceilingEntry(Object key) {
            Entry e = this.ceiling(key);
            return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
        }

        public Object ceilingKey(Object key) {
            Entry e = this.ceiling(key);
            return e == null ? null : e.key;
        }

        public Map.Entry higherEntry(Object key) {
            Entry e = this.higher(key);
            return e == null ? null : new AbstractMap.SimpleImmutableEntry(e);
        }

        public Object higherKey(Object key) {
            Entry e = this.higher(key);
            return e == null ? null : e.key;
        }

        public NavigableSet descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        public SortedMap headMap(Object toKey) {
            return this.headMap(toKey, false);
        }

        public SortedMap tailMap(Object fromKey) {
            return this.tailMap(fromKey, true);
        }

        public int size() {
            if (this.cachedSize < 0 || this.cacheVersion != TreeMap.this.modCount) {
                this.cachedSize = this.recalculateSize();
                this.cacheVersion = TreeMap.this.modCount;
            }
            return this.cachedSize;
        }

        private int recalculateSize() {
            Entry terminator = this.absHighest();
            Object terminalKey = terminator != null ? terminator.key : null;
            int size = 0;
            Entry e = this.absLowest();
            while (e != null) {
                ++size;
                e = e.key == terminalKey ? null : TreeMap.successor(e);
            }
            return size;
        }

        public boolean isEmpty() {
            return this.absLowest() == null;
        }

        public boolean containsKey(Object key) {
            return this.inRange(key) && TreeMap.this.containsKey(key);
        }

        public Object get(Object key) {
            if (!this.inRange(key)) {
                return null;
            }
            return TreeMap.this.get(key);
        }

        public Object put(Object key, Object value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("Key out of range");
            }
            return TreeMap.this.put(key, value);
        }

        public Object remove(Object key) {
            if (!this.inRange(key)) {
                return null;
            }
            return TreeMap.this.remove(key);
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new SubEntrySet();
            }
            return this.entrySet;
        }

        public Set keySet() {
            return this.navigableKeySet();
        }

        public NavigableSet navigableKeySet() {
            if (this.navigableKeySet == null) {
                this.navigableKeySet = new SubKeySet();
            }
            return this.navigableKeySet;
        }

        private Entry getMatchingSubEntry(Object o) {
            if (!(o instanceof Map.Entry)) {
                return null;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (!this.inRange(key)) {
                return null;
            }
            Entry found = TreeMap.this.getEntry(key);
            return found != null && TreeMap.eq(found.getValue(), e.getValue()) ? found : null;
        }

        class SubKeyIterator
        implements Iterator {
            final Iterator itr;

            SubKeyIterator(Iterator itr) {
                this.itr = itr;
            }

            public boolean hasNext() {
                return this.itr.hasNext();
            }

            public Object next() {
                return ((Map.Entry)this.itr.next()).getKey();
            }

            public void remove() {
                this.itr.remove();
            }
        }

        class SubEntryIterator
        extends BaseEntryIterator
        implements Iterator {
            final Object terminalKey;

            SubEntryIterator() {
                super(NavigableSubMap.this.first());
                Entry terminator = NavigableSubMap.this.last();
                this.terminalKey = terminator == null ? null : terminator.key;
            }

            public boolean hasNext() {
                return this.cursor != null;
            }

            public Object next() {
                Entry curr = this.cursor;
                if (curr == null) {
                    throw new NoSuchElementException();
                }
                if (this.expectedModCount != TreeMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                this.cursor = curr.key == this.terminalKey ? null : NavigableSubMap.this.uncheckedHigher(curr);
                this.lastRet = curr;
                return curr;
            }
        }

        class SubKeySet
        extends AbstractSet
        implements NavigableSet {
            SubKeySet() {
            }

            public int size() {
                return NavigableSubMap.this.size();
            }

            public boolean isEmpty() {
                return NavigableSubMap.this.isEmpty();
            }

            public void clear() {
                NavigableSubMap.this.clear();
            }

            public boolean contains(Object o) {
                return TreeMap.this.getEntry(o) != null;
            }

            public boolean remove(Object o) {
                if (!NavigableSubMap.this.inRange(o)) {
                    return false;
                }
                Entry found = TreeMap.this.getEntry(o);
                if (found == null) {
                    return false;
                }
                TreeMap.this.delete(found);
                return true;
            }

            public SortedSet subSet(Object fromElement, Object toElement) {
                return this.subSet(fromElement, true, toElement, false);
            }

            public SortedSet headSet(Object toElement) {
                return this.headSet(toElement, false);
            }

            public SortedSet tailSet(Object fromElement) {
                return this.tailSet(fromElement, true);
            }

            public Iterator iterator() {
                return new SubKeyIterator(NavigableSubMap.this.entrySet().iterator());
            }

            public Iterator descendingIterator() {
                return new SubKeyIterator(NavigableSubMap.this.descendingMap().entrySet().iterator());
            }

            public Object lower(Object e) {
                return NavigableSubMap.this.lowerKey(e);
            }

            public Object floor(Object e) {
                return NavigableSubMap.this.floorKey(e);
            }

            public Object ceiling(Object e) {
                return NavigableSubMap.this.ceilingKey(e);
            }

            public Object higher(Object e) {
                return NavigableSubMap.this.higherKey(e);
            }

            public Object first() {
                return NavigableSubMap.this.firstKey();
            }

            public Object last() {
                return NavigableSubMap.this.lastKey();
            }

            public Comparator comparator() {
                return NavigableSubMap.this.comparator();
            }

            public Object pollFirst() {
                Map.Entry e = NavigableSubMap.this.pollFirstEntry();
                return e == null ? null : e.getKey();
            }

            public Object pollLast() {
                Map.Entry e = NavigableSubMap.this.pollLastEntry();
                return e == null ? null : e.getKey();
            }

            public NavigableSet subSet(Object fromElement, boolean fromInclusive, Object toElement, boolean toInclusive) {
                return (NavigableSet)NavigableSubMap.this.subMap(fromElement, fromInclusive, toElement, toInclusive).keySet();
            }

            public NavigableSet headSet(Object toElement, boolean inclusive) {
                return (NavigableSet)NavigableSubMap.this.headMap(toElement, inclusive).keySet();
            }

            public NavigableSet tailSet(Object fromElement, boolean inclusive) {
                return (NavigableSet)NavigableSubMap.this.tailMap(fromElement, inclusive).keySet();
            }

            public NavigableSet descendingSet() {
                return (NavigableSet)NavigableSubMap.this.descendingMap().keySet();
            }
        }

        class SubEntrySet
        extends AbstractSet {
            SubEntrySet() {
            }

            public int size() {
                return NavigableSubMap.this.size();
            }

            public boolean isEmpty() {
                return NavigableSubMap.this.isEmpty();
            }

            public boolean contains(Object o) {
                return NavigableSubMap.this.getMatchingSubEntry(o) != null;
            }

            public boolean remove(Object o) {
                Entry e = NavigableSubMap.this.getMatchingSubEntry(o);
                if (e == null) {
                    return false;
                }
                TreeMap.this.delete(e);
                return true;
            }

            public Iterator iterator() {
                return new SubEntryIterator();
            }
        }
    }

    class DescendingKeySet
    extends KeySet {
        DescendingKeySet() {
        }

        public Iterator iterator() {
            return new DescendingKeyIterator(TreeMap.this.getLastEntry());
        }

        public Iterator descendingIterator() {
            return new KeyIterator(TreeMap.this.getFirstEntry());
        }

        public Object lower(Object e) {
            return TreeMap.this.higherKey(e);
        }

        public Object floor(Object e) {
            return TreeMap.this.ceilingKey(e);
        }

        public Object ceiling(Object e) {
            return TreeMap.this.floorKey(e);
        }

        public Object higher(Object e) {
            return TreeMap.this.lowerKey(e);
        }

        public Object first() {
            return TreeMap.this.lastKey();
        }

        public Object last() {
            return TreeMap.this.firstKey();
        }

        public Comparator comparator() {
            return TreeMap.this.descendingMap().comparator();
        }

        public Object pollFirst() {
            Map.Entry e = TreeMap.this.pollLastEntry();
            return e == null ? null : e.getKey();
        }

        public Object pollLast() {
            Map.Entry e = TreeMap.this.pollFirstEntry();
            return e == null ? null : e.getKey();
        }

        public NavigableSet subSet(Object fromElement, boolean fromInclusive, Object toElement, boolean toInclusive) {
            return (NavigableSet)TreeMap.this.descendingMap().subMap(fromElement, fromInclusive, toElement, toInclusive).keySet();
        }

        public NavigableSet headSet(Object toElement, boolean inclusive) {
            return (NavigableSet)TreeMap.this.descendingMap().headMap(toElement, inclusive).keySet();
        }

        public NavigableSet tailSet(Object fromElement, boolean inclusive) {
            return (NavigableSet)TreeMap.this.descendingMap().tailMap(fromElement, inclusive).keySet();
        }

        public NavigableSet descendingSet() {
            return (NavigableSet)TreeMap.this.keySet();
        }
    }

    class AscendingKeySet
    extends KeySet {
        AscendingKeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator(TreeMap.this.getFirstEntry());
        }

        public Iterator descendingIterator() {
            return new DescendingKeyIterator(TreeMap.this.getFirstEntry());
        }

        public Object lower(Object e) {
            return TreeMap.this.lowerKey(e);
        }

        public Object floor(Object e) {
            return TreeMap.this.floorKey(e);
        }

        public Object ceiling(Object e) {
            return TreeMap.this.ceilingKey(e);
        }

        public Object higher(Object e) {
            return TreeMap.this.higherKey(e);
        }

        public Object first() {
            return TreeMap.this.firstKey();
        }

        public Object last() {
            return TreeMap.this.lastKey();
        }

        public Comparator comparator() {
            return TreeMap.this.comparator();
        }

        public Object pollFirst() {
            Map.Entry e = TreeMap.this.pollFirstEntry();
            return e == null ? null : e.getKey();
        }

        public Object pollLast() {
            Map.Entry e = TreeMap.this.pollLastEntry();
            return e == null ? null : e.getKey();
        }

        public NavigableSet subSet(Object fromElement, boolean fromInclusive, Object toElement, boolean toInclusive) {
            return (NavigableSet)TreeMap.this.subMap(fromElement, fromInclusive, toElement, toInclusive).keySet();
        }

        public NavigableSet headSet(Object toElement, boolean inclusive) {
            return (NavigableSet)TreeMap.this.headMap(toElement, inclusive).keySet();
        }

        public NavigableSet tailSet(Object fromElement, boolean inclusive) {
            return (NavigableSet)TreeMap.this.tailMap(fromElement, inclusive).keySet();
        }

        public NavigableSet descendingSet() {
            return (NavigableSet)TreeMap.this.descendingMap().keySet();
        }
    }

    abstract class KeySet
    extends AbstractSet
    implements NavigableSet {
        KeySet() {
        }

        public int size() {
            return TreeMap.this.size();
        }

        public boolean isEmpty() {
            return TreeMap.this.isEmpty();
        }

        public void clear() {
            TreeMap.this.clear();
        }

        public boolean contains(Object o) {
            return TreeMap.this.getEntry(o) != null;
        }

        public boolean remove(Object o) {
            Entry found = TreeMap.this.getEntry(o);
            if (found == null) {
                return false;
            }
            TreeMap.this.delete(found);
            return true;
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        public SortedSet headSet(Object toElement) {
            return this.headSet(toElement, false);
        }

        public SortedSet tailSet(Object fromElement) {
            return this.tailSet(fromElement, true);
        }
    }

    class ValueSet
    extends AbstractSet {
        ValueSet() {
        }

        public int size() {
            return TreeMap.this.size();
        }

        public boolean isEmpty() {
            return TreeMap.this.isEmpty();
        }

        public void clear() {
            TreeMap.this.clear();
        }

        public boolean contains(Object o) {
            Entry e = TreeMap.this.getFirstEntry();
            while (e != null) {
                if (TreeMap.eq(o, e.element)) {
                    return true;
                }
                e = TreeMap.successor(e);
            }
            return false;
        }

        public Iterator iterator() {
            return new ValueIterator(TreeMap.this.getFirstEntry());
        }

        public boolean remove(Object o) {
            Entry e = TreeMap.this.getFirstEntry();
            while (e != null) {
                if (TreeMap.eq(o, e.element)) {
                    TreeMap.this.delete(e);
                    return true;
                }
                e = TreeMap.successor(e);
            }
            return false;
        }
    }

    class DescendingEntrySet
    extends EntrySet {
        DescendingEntrySet() {
        }

        public Iterator iterator() {
            return new DescendingEntryIterator(TreeMap.this.getLastEntry());
        }
    }

    class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        public int size() {
            return TreeMap.this.size();
        }

        public boolean isEmpty() {
            return TreeMap.this.isEmpty();
        }

        public void clear() {
            TreeMap.this.clear();
        }

        public Iterator iterator() {
            return new EntryIterator(TreeMap.this.getFirstEntry());
        }

        public boolean contains(Object o) {
            return TreeMap.this.getMatchingEntry(o) != null;
        }

        public boolean remove(Object o) {
            Entry e = TreeMap.this.getMatchingEntry(o);
            if (e == null) {
                return false;
            }
            TreeMap.this.delete(e);
            return true;
        }
    }

    class DescendingValueIterator
    extends BaseEntryIterator
    implements Iterator {
        DescendingValueIterator(Entry cursor) {
            super(cursor);
        }

        public Object next() {
            return this.prevEntry().element;
        }
    }

    class DescendingKeyIterator
    extends BaseEntryIterator
    implements Iterator {
        DescendingKeyIterator(Entry cursor) {
            super(cursor);
        }

        public Object next() {
            return this.prevEntry().key;
        }
    }

    class DescendingEntryIterator
    extends BaseEntryIterator
    implements Iterator {
        DescendingEntryIterator(Entry cursor) {
            super(cursor);
        }

        public Object next() {
            return this.prevEntry();
        }
    }

    class ValueIterator
    extends BaseEntryIterator
    implements Iterator {
        ValueIterator(Entry cursor) {
            super(cursor);
        }

        public Object next() {
            return this.nextEntry().element;
        }
    }

    class KeyIterator
    extends BaseEntryIterator
    implements Iterator {
        KeyIterator(Entry cursor) {
            super(cursor);
        }

        public Object next() {
            return this.nextEntry().key;
        }
    }

    class EntryIterator
    extends BaseEntryIterator
    implements Iterator {
        EntryIterator(Entry cursor) {
            super(cursor);
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class BaseEntryIterator {
        Entry cursor;
        Entry lastRet;
        int expectedModCount;

        BaseEntryIterator(Entry cursor) {
            this.cursor = cursor;
            this.expectedModCount = TreeMap.this.modCount;
        }

        public boolean hasNext() {
            return this.cursor != null;
        }

        Entry nextEntry() {
            Entry curr = this.cursor;
            if (curr == null) {
                throw new NoSuchElementException();
            }
            if (this.expectedModCount != TreeMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.cursor = TreeMap.successor(curr);
            this.lastRet = curr;
            return curr;
        }

        Entry prevEntry() {
            Entry curr = this.cursor;
            if (curr == null) {
                throw new NoSuchElementException();
            }
            if (this.expectedModCount != TreeMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.cursor = TreeMap.predecessor(curr);
            this.lastRet = curr;
            return curr;
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.expectedModCount != TreeMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet.left != null && this.lastRet.right != null && this.cursor != null) {
                this.cursor = this.lastRet;
            }
            TreeMap.this.delete(this.lastRet);
            this.lastRet = null;
            ++this.expectedModCount;
        }
    }

    public static class Entry
    implements Map.Entry,
    Cloneable,
    Serializable {
        private static final boolean RED = false;
        private static final boolean BLACK = true;
        private Object key;
        private Object element;
        private boolean color;
        private Entry left;
        private Entry right;
        private Entry parent;

        public Entry(Object key, Object element) {
            this.key = key;
            this.element = element;
            this.color = true;
        }

        protected Object clone() throws CloneNotSupportedException {
            Entry t = new Entry(this.key, this.element);
            t.color = this.color;
            return t;
        }

        public final Object getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.element;
        }

        public final Object setValue(Object v) {
            Object old = this.element;
            this.element = v;
            return old;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return TreeMap.eq(this.key, e.getKey()) && TreeMap.eq(this.element, e.getValue());
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.element == null ? 0 : this.element.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.element;
        }
    }
}

