/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.util;

import com.flexganttfx.core.FlexGanttFX;
import com.flexganttfx.core.LoggingDomain;
import com.flexganttfx.view.GanttChart;
import java.time.Instant;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;

public abstract class FlexGanttFXControl
extends Control {
    private String stylesheet;
    private static final String NAGGING_DATE = "NAG_DATE";
    private static final String INSTALLATION_DATE = "INST_DATE";
    private static boolean naggingShown;

    protected FlexGanttFXControl() {
        this.nagging();
    }

    protected String getUserAgentStylesheet(Class<?> clazz, String fileName) {
        if (this.stylesheet == null) {
            this.stylesheet = clazz.getResource(fileName).toExternalForm();
        }
        return this.stylesheet;
    }

    private synchronized void nagging() {
        if (!naggingShown && !FlexGanttFX.isRuntimeLicense()) {
            naggingShown = true;
            System.out.println("FlexGanttFX user interface framework for Java. Version " + FlexGanttFX.getVersion());
            if (FlexGanttFX.isTrialLicense()) {
                System.out.println("Unlicensed evaluation / trial version.");
                this.showNaggingNotification();
                this.checkEvaluationPeriod();
                this.exitAfter30Minutes();
                System.out.println("Application will automatically shut down in 30 minutes");
            } else if (FlexGanttFX.isDevelopmentLicense()) {
                System.out.println("Development License (do not use in production systems)");
            }
            System.out.println("(c) 2013-2019 Dirk Lemmermann Software & Consulting");
            System.out.println("http://www.dlsc.com");
        }
    }

    private void showNaggingNotification() {
        long duration;
        Preferences prefs = Preferences.userNodeForPackage(GanttChart.class);
        long systemTime = Instant.now().toEpochMilli();
        long naggingScreenLastShownOn = prefs.getLong(NAGGING_DATE, -1L);
        if (naggingScreenLastShownOn == -1L) {
            naggingScreenLastShownOn = systemTime;
            prefs.putLong(NAGGING_DATE, naggingScreenLastShownOn);
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                LoggingDomain.CONFIG.throwing(GanttChart.class.getName(), "showNaggingScreen()", ex);
            }
        }
        if ((duration = systemTime - naggingScreenLastShownOn) > 14400000L) {
            prefs.putLong(NAGGING_DATE, systemTime);
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                LoggingDomain.CONFIG.throwing(GanttChart.class.getName(), "showNaggingScreen()", ex);
            }
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setTitle("FlexGanttFX");
            alert.setHeaderText("Missing License");
            alert.setContentText("This is a trial version of FlexGanttFX. Do not use in production systems!\n\nFor more information about licensing options, please visit http://www.dlsc.com");
            alert.show();
        }
    }

    private void exitAfter30Minutes() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1800000L);
                    System.err.println("### Trial duration expired after 30 minutes.");
                    System.err.println("### Exiting application.");
                    System.exit(0);
                }
                catch (InterruptedException e) {
                    LoggingDomain.CONFIG.throwing(GanttChart.class.getName(), "run()", e);
                }
            }
        };
        thread.setDaemon(true);
        thread.setName("LicenseThread");
        thread.start();
    }

    private void checkEvaluationPeriod() {
        long remainingDays = this.getRemainingDays();
        if (remainingDays > 0L) {
            System.out.println("Evaluation period ends in " + remainingDays + " days!");
        } else {
            System.err.println("#############################################################");
            System.err.println("#                                                           #");
            System.err.println("#   FlexGanttFX evaluation period has ended after 90 days!  #");
            System.err.println("#                                                           #");
            System.err.println("#############################################################");
            System.exit(0);
        }
    }

    private long getRemainingDays() {
        long systemTime = Instant.now().toEpochMilli();
        Preferences prefs = Preferences.userNodeForPackage(GanttChart.class);
        long instDate = prefs.getLong(INSTALLATION_DATE, -1L);
        if (instDate == -1L) {
            prefs.putLong(INSTALLATION_DATE, systemTime);
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                LoggingDomain.CONFIG.throwing(GanttChart.class.getName(), "checkEvaluationPeriod()", ex);
            }
            instDate = systemTime;
        }
        long daysUsed = (systemTime - instDate) / 86400000L;
        return 90L - daysUsed;
    }
}

