/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.timeline;

import com.flexganttfx.model.Calendar;
import com.flexganttfx.model.dateline.ChronoUnitDatelineModel;
import com.flexganttfx.model.dateline.DatelineModel;
import com.flexganttfx.model.dateline.Resolution;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.model.util.SimpleUnit;
import com.flexganttfx.model.util.TimeInterval;
import com.flexganttfx.view.timeline.DatelineCell;
import com.flexganttfx.view.timeline.DatelineScrollingEvent;
import com.flexganttfx.view.timeline.Timeline;
import com.flexganttfx.view.util.FlexGanttFXControl;
import com.flexganttfx.view.util.Messages;
import impl.com.flexganttfx.skin.timeline.ChronoUnitDatelineCell;
import impl.com.flexganttfx.skin.timeline.DatelineSkin;
import impl.com.flexganttfx.skin.timeline.SimpleUnitDatelineCell;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;

public class Dateline
extends FlexGanttFXControl {
    private static final String DEFAULT_STYLE_CLASS = "dateline";
    private final Timeline timeline;
    private Instant selectionStart;
    private Instant selectionEnd;
    private double mouseStartX;
    private final ReadOnlyObjectWrapper<TimeInterval> selectedTimeInterval = new ReadOnlyObjectWrapper((Object)this, "selectedTimeInterval");
    private final BooleanProperty zoomLassoEnabled = new SimpleBooleanProperty((Object)this, "zoomLassoEnabled", true);
    private final Map<Class<?>, Callback<?, ?>> cellFactoryMap = new HashMap();
    private final ObjectProperty<EventHandler<DatelineScrollingEvent>> onVisibleRangeChanged = new ObjectPropertyBase<EventHandler<DatelineScrollingEvent>>(){

        protected void invalidated() {
            Dateline.this.setEventHandler(DatelineScrollingEvent.VISIBLE_RANGE_CHANGED, (EventHandler)this.get());
        }

        public Object getBean() {
            return Dateline.this;
        }

        public String getName() {
            return "onVisibleRangeChanged";
        }
    };
    private final ObjectProperty<DatelineModel<? extends TemporalUnit>> model = new SimpleObjectProperty((Object)this, "datelineModel");
    private final ObjectProperty<DayOfWeek> firstDayOfWeek = new SimpleObjectProperty((Object)this, "firstDayOfWeek", (Object)DayOfWeek.MONDAY);
    private final ObjectProperty<ZoneId> zoneId = new SimpleObjectProperty((Object)this, "zoneId", (Object)ZoneId.systemDefault());
    private final BooleanProperty zoneIdVisible = new SimpleBooleanProperty((Object)this, "zoneIdVisible", false);
    private final ReadOnlyObjectWrapper<TemporalUnit> primaryTemporalUnit = new ReadOnlyObjectWrapper();
    private final ReadOnlyObjectWrapper<TimeInterval> hoverTimeInterval = new ReadOnlyObjectWrapper((Object)this, "hoverTimeInterval");
    private final ObservableList<TimeInterval> selectedIntervals = FXCollections.observableArrayList();
    private final ObjectProperty<SelectionMode> selectionMode = new SimpleObjectProperty((Object)this, "selectionMode", (Object)SelectionMode.MULTIPLE);
    private final ObservableList<Calendar<?>> calendars = FXCollections.observableArrayList();
    private final ObservableList<Resolution<?>> scaleResolutions = FXCollections.observableArrayList();
    private static final String DATELINE_PROPERTIES_CATEGORY = "Control: Dateline";

    protected Dateline(Timeline timeline) {
        Objects.requireNonNull(timeline);
        this.timeline = timeline;
        this.setModel(new ChronoUnitDatelineModel());
        this.setFocusTraversable(true);
        this.setPrefWidth(0.0);
        this.setMinWidth(0.0);
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> this.requestFocus());
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setCellFactory(SimpleUnit.class, unit -> new SimpleUnitDatelineCell());
        this.setCellFactory(ChronoUnit.class, unit -> new ChronoUnitDatelineCell());
        this.getSelectedIntervals().addListener(it -> this.requestLayout());
        this.selectionModeProperty().addListener(it -> this.getSelectedIntervals().clear());
        this.buildContextMenu();
        EventHandler mousePressedHandler = evt -> {
            if (evt.isShiftDown() || !timeline.isScrollDragEnabled()) {
                TimelineModel<?> timelineModel = timeline.getModel();
                this.selectionStart = timelineModel.calculateTimeForLocation(evt.getX());
                this.selectedTimeInterval.set((Object)new TimeInterval(this.selectionStart, this.selectionStart));
            } else {
                this.mouseStartX = evt.getScreenX();
            }
        };
        EventHandler mouseDraggedHandler = evt -> {
            if (evt.isShiftDown() || !timeline.isScrollDragEnabled()) {
                if (this.isZoomLassoEnabled() && !timeline.isScrollDragEnabled() && evt.getSource().equals((Object)this)) {
                    TimelineModel<?> timelineModel = timeline.getModel();
                    this.selectionEnd = timelineModel.calculateTimeForLocation(evt.getX());
                    if (this.selectionStart.isBefore(this.selectionEnd) || this.selectionStart.equals(this.selectionEnd)) {
                        this.selectedTimeInterval.set((Object)new TimeInterval(this.selectionStart, this.selectionEnd));
                    } else {
                        this.selectedTimeInterval.set((Object)new TimeInterval(this.selectionEnd, this.selectionStart));
                    }
                }
            } else {
                double scrollX = evt.getScreenX();
                double delta = this.mouseStartX - scrollX;
                TimelineModel<?> timelineModel = timeline.getModel();
                Instant newStartTime = timelineModel.calculateTimeForLocation(delta);
                if (newStartTime.equals(timelineModel.getStartTime())) {
                    newStartTime = delta > 0.0 ? newStartTime.plusMillis(1L) : newStartTime.minusMillis(1L);
                }
                timelineModel.setStartTime(newStartTime);
                this.mouseStartX = scrollX;
            }
        };
        EventHandler mouseReleasedHandler = evt -> {
            if (this.getSelectedTimeInterval() != null) {
                TimeInterval interval = this.getSelectedTimeInterval();
                Duration duration = interval.getDuration();
                if (!duration.isZero()) {
                    if (evt.isShiftDown()) {
                        Instant st = timeline.getVisibleStartTime().minusMillis(duration.toMillis() / 2L);
                        Instant et = timeline.getVisibleEndTime().plusMillis(duration.toMillis() / 2L);
                        timeline.showRange(st, et);
                    } else {
                        timeline.showRange(interval);
                    }
                }
                this.selectedTimeInterval.set(null);
            }
        };
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, mousePressedHandler);
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, mouseDraggedHandler);
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseReleasedHandler);
        this.getProperties().addListener(change -> {
            if (change.getKey().equals("com.flexganttfx.primaryUnit")) {
                if (change.getValueAdded() != null) {
                    TemporalUnit mode = (TemporalUnit)change.getValueAdded();
                    this.primaryTemporalUnit.set((Object)mode);
                }
            } else if (change.getKey().equals("com.flexganttfx.dateline.hover.interval")) {
                if (change.getValueAdded() != null) {
                    TimeInterval interval = (TimeInterval)change.getValueAdded();
                    this.hoverTimeInterval.set((Object)interval);
                } else {
                    this.hoverTimeInterval.set(null);
                }
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new DatelineSkin(this);
    }

    public String getUserAgentStylesheet() {
        return super.getUserAgentStylesheet(Dateline.class, "dateline.css");
    }

    public final ReadOnlyObjectProperty<TimeInterval> selectedTimeIntervalProperty() {
        return this.selectedTimeInterval.getReadOnlyProperty();
    }

    public final TimeInterval getSelectedTimeInterval() {
        return (TimeInterval)this.selectedTimeInterval.get();
    }

    public final BooleanProperty zoomLassoEnabledProperty() {
        return this.zoomLassoEnabled;
    }

    public final boolean isZoomLassoEnabled() {
        return this.zoomLassoEnabledProperty().get();
    }

    public final void setZoomLassoEnabled(boolean enabled) {
        this.zoomLassoEnabledProperty().set(enabled);
    }

    public final <T extends TemporalUnit> void setCellFactory(Class<T> temporalUnitType, Callback<T, DatelineCell<T>> factory) {
        this.cellFactoryMap.put(temporalUnitType, factory);
    }

    public final Callback<TemporalUnit, DatelineCell> getCellFactory(Class<? extends TemporalUnit> temporalUnitType) {
        return this.cellFactoryMap.get(temporalUnitType);
    }

    public final ObjectProperty<EventHandler<DatelineScrollingEvent>> onVisibleRangeChangedProperty() {
        return this.onVisibleRangeChanged;
    }

    public final void setOnVisibleRangeChanged(EventHandler<DatelineScrollingEvent> handler) {
        this.onVisibleRangeChangedProperty().set(handler);
    }

    public final EventHandler<DatelineScrollingEvent> getOnVisibleRangeChanged() {
        return (EventHandler)this.onVisibleRangeChangedProperty().get();
    }

    public final Timeline getTimeline() {
        return this.timeline;
    }

    public final ObjectProperty<DatelineModel<? extends TemporalUnit>> modelProperty() {
        return this.model;
    }

    public final DatelineModel<? extends TemporalUnit> getModel() {
        return (DatelineModel)this.modelProperty().get();
    }

    public final void setModel(DatelineModel<? extends TemporalUnit> model) {
        this.modelProperty().set(model);
    }

    public final ObjectProperty<DayOfWeek> firstDayOfWeekProperty() {
        return this.firstDayOfWeek;
    }

    public final DayOfWeek getFirstDayOfWeek() {
        return (DayOfWeek)this.firstDayOfWeekProperty().get();
    }

    public final void setFirstDayOfWeek(DayOfWeek day) {
        Objects.requireNonNull(day);
        this.firstDayOfWeekProperty().set((Object)day);
    }

    public final ObjectProperty<ZoneId> zoneIdProperty() {
        return this.zoneId;
    }

    public final ZoneId getZoneId() {
        return (ZoneId)this.zoneIdProperty().get();
    }

    public final void setZoneId(ZoneId zoneId) {
        this.zoneIdProperty().set((Object)zoneId);
    }

    public final BooleanProperty zoneIdVisibleProperty() {
        return this.zoneIdVisible;
    }

    public final boolean isZoneIdVisible() {
        return this.zoneIdVisibleProperty().get();
    }

    public final void setZoneIdVisible(boolean visible) {
        this.zoneIdVisibleProperty().set(visible);
    }

    public final ReadOnlyObjectProperty<TemporalUnit> primaryTemporalUnitProperty() {
        return this.primaryTemporalUnit.getReadOnlyProperty();
    }

    public final TemporalUnit getPrimaryTemporalUnit() {
        return (TemporalUnit)this.primaryTemporalUnitProperty().get();
    }

    public final ReadOnlyObjectProperty<TimeInterval> hoverTimeIntervalProperty() {
        return this.hoverTimeInterval.getReadOnlyProperty();
    }

    public final TimeInterval getHoverTimeInterval() {
        return (TimeInterval)this.hoverTimeIntervalProperty().get();
    }

    public final ObservableList<TimeInterval> getSelectedIntervals() {
        return this.selectedIntervals;
    }

    public final ObjectProperty<SelectionMode> selectionModeProperty() {
        return this.selectionMode;
    }

    public final void setSelectionMode(SelectionMode mode) {
        this.selectionModeProperty().set((Object)mode);
    }

    public final SelectionMode getSelectionMode() {
        return (SelectionMode)this.selectionModeProperty().get();
    }

    public final ObservableList<Calendar<?>> getCalendars() {
        return this.calendars;
    }

    public final ObservableList<Resolution<?>> getScaleResolutions() {
        return this.scaleResolutions;
    }

    private void buildContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        Timeline timeline = this.getTimeline();
        contextMenu.getItems().clear();
        CheckMenuItem showTimezoneItem = new CheckMenuItem(Messages.getString("Dateline.MENU_ITEM_SHOW_TIMEZONE"));
        showTimezoneItem.setSelected(this.isZoneIdVisible());
        Bindings.bindBidirectional((Property)this.zoneIdVisibleProperty(), (Property)showTimezoneItem.selectedProperty());
        Menu unitsMenu = new Menu(Messages.getString("Dateline.MENU_TIME_UNIT"));
        Menu zoneIdMenu = new Menu(Messages.getString("Dateline.MENU_TIME_ZONE"));
        MenuItem addScaleItem = new MenuItem(Messages.getString("Dateline.MENU_ITEM_ADD_TOP_SCALE"));
        addScaleItem.setOnAction(this.addScale());
        MenuItem removeScaleItem = new MenuItem(Messages.getString("Dateline.MENU_ITEM_REMOVE_TOP_SCALE"));
        removeScaleItem.setOnAction(this.removeScale());
        Menu scaleCountMenu = new Menu(Messages.getString("Dateline.MENU_SCALES"));
        contextMenu.setOnShowing(evt -> {
            unitsMenu.getItems().clear();
            this.getModel().getTemporalUnits().forEach(unit -> {
                CheckMenuItem item = new CheckMenuItem(Messages.getString("Dateline." + unit.toString().toUpperCase()));
                item.setSelected(unit.equals(this.getPrimaryTemporalUnit()));
                unitsMenu.getItems().add((Object)item);
                item.setOnAction(e -> timeline.showTemporalUnit((TemporalUnit)unit, 50.0));
            });
            zoneIdMenu.getItems().clear();
            this.getModel().getAvailableZoneIds().forEach(zoneId -> {
                CheckMenuItem item = new CheckMenuItem(ZoneId.of(zoneId).getDisplayName(TextStyle.FULL_STANDALONE, Locale.getDefault()));
                item.setSelected(this.getZoneId().getId().equals(zoneId));
                zoneIdMenu.getItems().add((Object)item);
                item.setOnAction(e -> this.setZoneId(ZoneId.of(zoneId)));
            });
            scaleCountMenu.getItems().clear();
            for (int i = 1; i <= 5; ++i) {
                int count = i;
                MenuItem scaleCountItem = new MenuItem(Integer.toString(i));
                scaleCountItem.setOnAction(e -> this.getModel().setScaleCount(count));
                scaleCountMenu.getItems().add((Object)scaleCountItem);
            }
        });
        ToggleGroup toggleGroup = new ToggleGroup();
        Menu firstDayMenu = new Menu(Messages.getString("Dateline.MENU_WEEK_START"));
        for (DayOfWeek day : DayOfWeek.values()) {
            RadioMenuItem item = new RadioMenuItem(day.getDisplayName(TextStyle.FULL, Locale.getDefault()));
            if (this.getFirstDayOfWeek().equals(day)) {
                item.setSelected(true);
            }
            toggleGroup.getToggles().add((Object)item);
            item.setOnAction(evt -> this.setFirstDayOfWeek(day));
            firstDayMenu.getItems().add((Object)item);
        }
        contextMenu.getItems().add((Object)unitsMenu);
        contextMenu.getItems().add((Object)zoneIdMenu);
        contextMenu.getItems().add((Object)showTimezoneItem);
        contextMenu.getItems().add((Object)firstDayMenu);
        this.setContextMenu(contextMenu);
    }

    private EventHandler<ActionEvent> removeScale() {
        return evt -> {
            int count = this.getModel().getScaleCount();
            this.getModel().setScaleCount(Math.max(1, count - 1));
        };
    }

    private EventHandler<ActionEvent> addScale() {
        return evt -> {
            int count = this.getModel().getScaleCount();
            this.getModel().setScaleCount(count + 1);
        };
    }

    public final List<PropertySheet.Item> getPropertySheetItems() {
        ArrayList<PropertySheet.Item> items = new ArrayList<PropertySheet.Item>();
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Dateline.this.selectionModeProperty());
            }

            @Override
            public void setValue(Object value) {
                Dateline.this.setSelectionMode((SelectionMode)value);
            }

            @Override
            public Object getValue() {
                return Dateline.this.getSelectionMode();
            }

            @Override
            public Class<?> getType() {
                return SelectionMode.class;
            }

            @Override
            public String getName() {
                return "Selection Mode";
            }

            @Override
            public String getDescription() {
                return "Single or multiple selections of dateline cells / time intervals.";
            }

            @Override
            public String getCategory() {
                return Dateline.DATELINE_PROPERTIES_CATEGORY;
            }
        });
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Dateline.this.zoneIdProperty());
            }

            @Override
            public void setValue(Object value) {
                Dateline.this.setZoneId((ZoneId)value);
            }

            @Override
            public Object getValue() {
                return Dateline.this.getZoneId();
            }

            @Override
            public Class<?> getType() {
                return ZoneId.class;
            }

            @Override
            public String getName() {
                return "Timezone";
            }

            @Override
            public String getDescription() {
                return "The timezone that will be displayed by the dateline.";
            }

            @Override
            public String getCategory() {
                return Dateline.DATELINE_PROPERTIES_CATEGORY;
            }
        });
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Dateline.this.firstDayOfWeekProperty());
            }

            @Override
            public void setValue(Object value) {
                Dateline.this.setFirstDayOfWeek((DayOfWeek)value);
            }

            @Override
            public Object getValue() {
                return Dateline.this.getFirstDayOfWeek();
            }

            @Override
            public Class<?> getType() {
                return DayOfWeek.class;
            }

            @Override
            public String getName() {
                return "First Day of Week";
            }

            @Override
            public String getDescription() {
                return "The day representing the beginning of the week.";
            }

            @Override
            public String getCategory() {
                return Dateline.DATELINE_PROPERTIES_CATEGORY;
            }
        });
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(Dateline.this.zoomLassoEnabledProperty());
            }

            @Override
            public void setValue(Object value) {
                Dateline.this.setZoomLassoEnabled((Boolean)value);
            }

            @Override
            public Object getValue() {
                return Dateline.this.isZoomLassoEnabled();
            }

            @Override
            public Class<?> getType() {
                return Boolean.class;
            }

            @Override
            public String getName() {
                return "Support Zoom Lasso";
            }

            @Override
            public String getDescription() {
                return "If enabled the user can perform a zoom by selecting a time range with a lasso.";
            }

            @Override
            public String getCategory() {
                return Dateline.DATELINE_PROPERTIES_CATEGORY;
            }
        });
        return items;
    }
}

