/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.renderer;

import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.renderer.Renderer;
import javafx.geometry.Insets;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class RowRenderer<R extends Row<?, ?, ?>>
extends Renderer {
    public RowRenderer(GraphicsBase<?> graphics, String name) {
        super(graphics, name);
        this.setFill((Paint)Color.TRANSPARENT);
        this.setFillPressed((Paint)Color.TRANSPARENT);
        this.setFillHighlight((Paint)Color.YELLOW);
        this.setFillSelected((Paint)Color.TRANSPARENT);
        this.setFillHover((Paint)Color.TRANSPARENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw(R row, GraphicsContext gc, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        this.disableRedrawAfterPropertyChange();
        try {
            this.drawRow(row, gc, w, h, selected, hover, highlighted, pressed);
        }
        finally {
            this.enableRedrawAfterPropertyChange();
        }
    }

    protected void drawRow(R row, GraphicsContext gc, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        Insets padding = this.getPadding();
        double x = padding.getLeft();
        double y = padding.getTop();
        gc.setFill(this.getFill(selected, hover, highlighted, pressed));
        gc.fillRect(x, y, w -= padding.getLeft() + padding.getRight(), h -= padding.getTop() + padding.getBottom());
    }
}

