/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.renderer;

import com.flexganttfx.model.Activity;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.renderer.Renderer;
import com.flexganttfx.view.util.Position;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Insets;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ActivityRenderer<A extends Activity>
extends Renderer {
    private final BooleanProperty cornersRounded = new SimpleBooleanProperty((Object)this, "cornersRounded", false);
    private final DoubleProperty cornerRadius = new SimpleDoubleProperty((Object)this, "cornerRadius", 6.0);
    private final ObjectProperty<Paint> stroke = new SimpleObjectProperty((Object)this, "stroke");
    private final ObjectProperty<Paint> strokePressed = new SimpleObjectProperty((Object)this, "strokePressed");
    private final ObjectProperty<Paint> strokeHighlight = new SimpleObjectProperty((Object)this, "strokeHighlight");
    private final ObjectProperty<Paint> strokeSelected = new SimpleObjectProperty((Object)this, "strokeSelected");
    private final ObjectProperty<Paint> strokeHover = new SimpleObjectProperty((Object)this, "strokeHover");
    private final DoubleProperty lineWidth = new SimpleDoubleProperty((Object)this, "lineWidth", 0.5);

    public ActivityRenderer(GraphicsBase<?> graphics, String name) {
        super(graphics, name);
        this.setStroke((Paint)Color.BLUE);
        this.setStrokePressed((Paint)Color.BLUE.darker());
        this.setStrokeHighlight((Paint)Color.YELLOW.darker());
        this.setStrokeSelected((Paint)Color.RED);
        this.setStrokeHover((Paint)Color.GREEN);
        this.redrawObservable((Observable)this.stroke);
        this.redrawObservable((Observable)this.strokePressed);
        this.redrawObservable((Observable)this.strokeHighlight);
        this.redrawObservable((Observable)this.strokeSelected);
        this.redrawObservable((Observable)this.strokeHover);
        this.redrawObservable((Observable)this.cornerRadius);
        this.redrawObservable((Observable)this.cornersRounded);
        this.redrawObservable((Observable)this.lineWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ActivityBounds draw(ActivityRef<A> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        GraphicsBase<?> graphics = this.getGraphics();
        if (graphics.isSafeRendering()) {
            gc.save();
        }
        gc.setLineWidth(this.getLineWidth());
        this.disableRedrawAfterPropertyChange();
        try {
            ActivityBounds activityBounds = this.drawActivity(activityRef, position, gc, x, y, w, h, selected, hover, highlighted, pressed);
            return activityBounds;
        }
        finally {
            this.enableRedrawAfterPropertyChange();
            if (graphics.isSafeRendering()) {
                gc.restore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActivityBounds drawActivity(ActivityRef<A> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        GraphicsBase<?> graphics = this.getGraphics();
        double alpha = gc.getGlobalAlpha();
        try {
            if (graphics.isSafeRendering()) {
                gc.save();
            }
            gc.setGlobalAlpha(alpha * this.getAlpha());
            this.drawBackground(activityRef, position, gc, x, y, w, h, selected, hover, highlighted, pressed);
        }
        finally {
            if (graphics.isSafeRendering()) {
                gc.restore();
            } else {
                gc.setGlobalAlpha(alpha);
            }
        }
        try {
            if (graphics.isSafeRendering()) {
                gc.save();
            }
            gc.setGlobalAlpha(alpha * this.getAlpha());
            this.drawBorder(activityRef, position, gc, x, y, w, h, selected, hover, highlighted, pressed);
        }
        finally {
            if (graphics.isSafeRendering()) {
                gc.restore();
            } else {
                gc.setGlobalAlpha(alpha);
            }
        }
        return new ActivityBounds(activityRef, x, y, w, h);
    }

    protected void drawBackground(ActivityRef<A> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        gc.setFill(this.getFill(selected, hover, highlighted, pressed));
        Insets padding = this.getPadding();
        x += padding.getLeft();
        y += padding.getTop();
        w -= padding.getLeft() + padding.getRight();
        h -= padding.getTop() + padding.getBottom();
        if (this.isCornersRounded()) {
            gc.fillRoundRect(x, y, w, h, this.getCornerRadius(), this.getCornerRadius());
        } else {
            gc.fillRect(x, y, w, h);
        }
    }

    protected void drawBorder(ActivityRef<A> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        gc.setStroke(this.getStroke(selected, hover, highlighted, pressed));
        Insets padding = this.getPadding();
        x += padding.getLeft();
        y += padding.getTop();
        w -= padding.getLeft() + padding.getRight();
        h -= padding.getTop() + padding.getBottom();
        if (this.isCornersRounded()) {
            gc.strokeRoundRect(x, y, w, h, this.getCornerRadius(), this.getCornerRadius());
        } else {
            gc.strokeRect(x, y, w, h);
        }
    }

    protected Paint getStroke(boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        if (pressed) {
            return this.getStrokePressed();
        }
        if (highlighted) {
            return this.getStrokeHighlight();
        }
        if (hover) {
            return this.getStrokeHover();
        }
        if (selected) {
            return this.getStrokeSelected();
        }
        return this.getStroke();
    }

    public final BooleanProperty cornersRoundedProperty() {
        return this.cornersRounded;
    }

    public final DoubleProperty cornerRadiusProperty() {
        return this.cornerRadius;
    }

    public final DoubleProperty lineWidthProperty() {
        return this.lineWidth;
    }

    public final ObjectProperty<Paint> strokeProperty() {
        return this.stroke;
    }

    public final ObjectProperty<Paint> strokePressedProperty() {
        return this.strokePressed;
    }

    public final ObjectProperty<Paint> strokeHoverProperty() {
        return this.strokeHover;
    }

    public final ObjectProperty<Paint> strokeSelectedProperty() {
        return this.strokeSelected;
    }

    public final ObjectProperty<Paint> strokeHighlightProperty() {
        return this.strokeHighlight;
    }

    public final Paint getStroke() {
        return (Paint)this.stroke.get();
    }

    public final void setStroke(Paint paint) {
        Objects.nonNull(paint);
        this.stroke.set((Object)paint);
    }

    public final Paint getStrokePressed() {
        return (Paint)this.strokePressed.get();
    }

    public final void setStrokePressed(Paint paint) {
        Objects.nonNull(paint);
        this.strokePressed.set((Object)paint);
    }

    public final Paint getStrokeHighlight() {
        return (Paint)this.strokeHighlight.get();
    }

    public final void setStrokeHighlight(Paint paint) {
        Objects.nonNull(paint);
        this.strokeHighlight.set((Object)paint);
    }

    public final Paint getStrokeSelected() {
        return (Paint)this.strokeSelected.get();
    }

    public final void setStrokeSelected(Paint paint) {
        Objects.nonNull(paint);
        this.strokeSelected.set((Object)paint);
    }

    public final Paint getStrokeHover() {
        return (Paint)this.strokeHover.get();
    }

    public final void setStrokeHover(Paint paint) {
        Objects.nonNull(paint);
        this.strokeHover.set((Object)paint);
    }

    public final void setCornerRadius(double radius) {
        this.cornerRadius.set(radius);
    }

    public final double getCornerRadius() {
        return this.cornerRadius.get();
    }

    public final void setCornersRounded(boolean rounded) {
        this.cornersRounded.set(rounded);
    }

    public final boolean isCornersRounded() {
        return this.cornersRounded.get();
    }

    public final void setLineWidth(double lineWidth) {
        this.lineWidth.set(lineWidth);
    }

    public final double getLineWidth() {
        return this.lineWidth.get();
    }
}

