/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.layer;

import com.flexganttfx.model.Row;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.model.util.TimeInterval;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.timeline.Timeline;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.time.Instant;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ZoomTimeIntervalLayer<R extends Row<?, ?, ?>>
extends SystemLayer<R> {
    private final ObjectProperty<Paint> zoomTimeIntervalFill = new SimpleObjectProperty((Object)this, "zoomTimeIntervalFill");

    public ZoomTimeIntervalLayer(GraphicsBase<R> graphics) {
        super("Zoom Time Interval", graphics);
        this.setZoomTimeIntervalFill((Paint)Color.valueOf((String)"0096C999"));
        this.redrawObservable((Observable)this.zoomTimeIntervalFillProperty());
        this.fadeInOutObservable((ObservableBooleanValue)graphics.showZoomTimeIntervalLayerProperty());
    }

    public final ObjectProperty<Paint> zoomTimeIntervalFillProperty() {
        return this.zoomTimeIntervalFill;
    }

    public final Paint getZoomTimeIntervalFill() {
        return (Paint)this.zoomTimeIntervalFillProperty().get();
    }

    public final void setZoomTimeIntervalFill(Paint fill) {
        Objects.requireNonNull(fill);
        this.zoomTimeIntervalFillProperty().set((Object)fill);
    }

    @Override
    public void drawLayer(RowCanvas<R> canvas, Instant startTime, Instant endTime) {
        GraphicsBase graphics = this.getGraphics();
        Timeline timeline = graphics.getTimeline();
        Dateline dateline = timeline.getDateline();
        TimeInterval selectedTimeInterval = dateline.getSelectedTimeInterval();
        if (selectedTimeInterval != null) {
            TimelineModel<?> timelineModel = timeline.getModel();
            GraphicsContext gc = canvas.getGraphicsContext2D();
            gc.setFill(this.getZoomTimeIntervalFill());
            double x1 = this.snapPosition(timelineModel.calculateLocationForTime(selectedTimeInterval.getStartTime()));
            double x2 = this.snapPosition(timelineModel.calculateLocationForTime(selectedTimeInterval.getEndTime()));
            gc.fillRect(x1, 0.0, x2 - x1, canvas.getHeight());
        }
    }
}

