/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.layer;

import com.flexganttfx.model.Row;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.model.util.TimeInterval;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.timeline.Timeline;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.time.Instant;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class SelectedTimeIntervalsLayer<R extends Row<?, ?, ?>>
extends SystemLayer<R> {
    private final ObjectProperty<Paint> selectedTimeIntervalFill = new SimpleObjectProperty((Object)this, "selectedTimeIntervalFill");

    public SelectedTimeIntervalsLayer(GraphicsBase<R> graphics) {
        super("Selected Time Intervals", graphics);
        this.setSelectedTimeIntervalFill((Paint)Color.web((String)"#7F9FBB66"));
        this.redrawObservable((Observable)this.selectedTimeIntervalFillProperty());
        this.fadeInOutObservable((ObservableBooleanValue)graphics.showSelectedTimeIntervalsLayerProperty());
    }

    public final ObjectProperty<Paint> selectedTimeIntervalFillProperty() {
        return this.selectedTimeIntervalFill;
    }

    public final Paint getSelectedTimeIntervalFill() {
        return (Paint)this.selectedTimeIntervalFillProperty().get();
    }

    public final void setSelectedTimeIntervalFill(Paint fill) {
        Objects.requireNonNull(fill);
        this.selectedTimeIntervalFillProperty().set((Object)fill);
    }

    @Override
    public void drawLayer(RowCanvas<R> canvas, Instant startTime, Instant endTime) {
        GraphicsBase graphics = this.getGraphics();
        Timeline timeline = graphics.getTimeline();
        Dateline dateline = timeline.getDateline();
        TimelineModel<?> timelineModel = timeline.getModel();
        GraphicsContext gc = canvas.getGraphicsContext2D();
        gc.setFill(this.getSelectedTimeIntervalFill());
        for (TimeInterval timeInterval : dateline.getSelectedIntervals()) {
            double x1 = this.snapPosition(timelineModel.calculateLocationForTime(timeInterval.getStartTime()));
            double x2 = this.snapPosition(timelineModel.calculateLocationForTime(timeInterval.getEndTime()));
            gc.fillRect(x1, 0.0, x2 - x1, canvas.getHeight());
        }
    }
}

