/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.layer;

import com.flexganttfx.model.Row;
import com.flexganttfx.model.exception.IllegalLineIndexException;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.time.Instant;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Paint;

public class InnerLinesLayer<R extends Row<?, ?, ?>>
extends SystemLayer<R> {
    private final ObjectProperty<Paint> stroke = new SimpleObjectProperty((Object)this, "stroke");
    private final DoubleProperty lineWidth = new SimpleDoubleProperty((Object)this, "lineWidth");
    private final BooleanProperty drawLastDividerLine = new SimpleBooleanProperty((Object)this, "drawLastDividerLine", false);
    private final ObjectProperty<double[]> lineDashes = new SimpleObjectProperty((Object)this, "lineDashes");

    public InnerLinesLayer(GraphicsBase<R> graphics) {
        super("Inner Lines", graphics);
        this.strokeProperty().bindBidirectional(graphics.innerLinesColorProperty());
        this.setLineWidth(0.5);
        this.redrawObservable((Observable)this.strokeProperty());
        this.redrawObservable((Observable)this.lineWidthProperty());
        this.redrawObservable((Observable)this.drawLastDividerLineProperty());
        this.fadeInOutObservable((ObservableBooleanValue)graphics.showInnerLinesLayerProperty());
    }

    public final ObjectProperty<Paint> strokeProperty() {
        return this.stroke;
    }

    public final Paint getStroke() {
        return (Paint)this.strokeProperty().get();
    }

    public final void setStroke(Paint stroke) {
        Objects.requireNonNull(stroke);
        this.strokeProperty().set((Object)stroke);
    }

    public final DoubleProperty lineWidthProperty() {
        return this.lineWidth;
    }

    public final double getLineWidth() {
        return this.lineWidthProperty().get();
    }

    public final void setLineWidth(double lineWidth) {
        this.lineWidthProperty().set(lineWidth);
    }

    public final BooleanProperty drawLastDividerLineProperty() {
        return this.drawLastDividerLine;
    }

    public final void setDrawLastDividerLine(boolean draw) {
        this.drawLastDividerLineProperty().set(draw);
    }

    public final boolean isDrawLastDividerLine() {
        return this.drawLastDividerLine.get();
    }

    public final ObjectProperty<double[]> lineDashesProperty() {
        return this.lineDashes;
    }

    public final void setLineDashes(double ... dashes) {
        this.lineDashesProperty().set((Object)dashes);
    }

    public final double[] getLineDashes() {
        return (double[])this.lineDashesProperty().get();
    }

    @Override
    public void drawLayer(RowCanvas<R> canvas, Instant startTime, Instant endTime) {
        R row = canvas.getRow();
        double lineWidth = this.getLineWidth();
        if (row != null && lineWidth > 0.0) {
            GraphicsContext gc = canvas.getGraphicsContext2D();
            gc.setStroke(this.getStroke());
            gc.setLineWidth(this.getLineWidth());
            int lastLineIndex = ((Row)row).getLineCount() - 1;
            if (!this.isDrawLastDividerLine()) {
                --lastLineIndex;
            }
            gc.setLineDashes(this.getLineDashes());
            for (int lineIndex = 0; lineIndex <= lastLineIndex; ++lineIndex) {
                try {
                    double y = ((Row)row).getLineLocation(lineIndex) + ((Row)row).getLineHeight(lineIndex);
                    gc.strokeLine(0.0, y, canvas.getWidth(), y);
                    continue;
                }
                catch (IllegalLineIndexException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

