/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.layer;

import com.flexganttfx.model.Row;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.model.util.TimeInterval;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.timeline.Timeline;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.time.Instant;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class HoverTimeIntervalLayer<R extends Row<?, ?, ?>>
extends SystemLayer<R> {
    private final ObjectProperty<Paint> hoverTimeIntervalFill = new SimpleObjectProperty((Object)this, "hoverTimeIntervalFill");

    public HoverTimeIntervalLayer(GraphicsBase<R> graphics) {
        super("Hover Time Interval", graphics);
        this.setHoverTimeIntervalFill((Paint)Color.BEIGE.deriveColor(0.0, 1.0, 1.0, 0.5));
        this.redrawObservable((Observable)this.hoverTimeIntervalFillProperty());
        this.fadeInOutObservable((ObservableBooleanValue)graphics.showHoverTimeIntervalLayerProperty());
    }

    public final ObjectProperty<Paint> hoverTimeIntervalFillProperty() {
        return this.hoverTimeIntervalFill;
    }

    public final Paint getHoverTimeIntervalFill() {
        return (Paint)this.hoverTimeIntervalFillProperty().get();
    }

    public final void setHoverTimeIntervalFill(Paint fill) {
        Objects.requireNonNull(fill);
        this.hoverTimeIntervalFillProperty().set((Object)fill);
    }

    @Override
    public void drawLayer(RowCanvas<R> canvas, Instant startTime, Instant endTime) {
        GraphicsBase graphics = this.getGraphics();
        Timeline timeline = graphics.getTimeline();
        Dateline dateline = timeline.getDateline();
        TimelineModel<?> timelineModel = timeline.getModel();
        GraphicsContext gc = canvas.getGraphicsContext2D();
        TimeInterval hoverTimeInterval = dateline.getHoverTimeInterval();
        if (hoverTimeInterval != null) {
            gc.setFill(this.getHoverTimeIntervalFill());
            double x1 = this.snapPosition(timelineModel.calculateLocationForTime(hoverTimeInterval.getStartTime()));
            double x2 = this.snapPosition(timelineModel.calculateLocationForTime(hoverTimeInterval.getEndTime()));
            gc.fillRect(x1, 0.0, x2 - x1, canvas.getHeight());
        }
    }
}

