/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.container;

import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.GanttChartBase;
import com.flexganttfx.view.container.ContainerBase;
import com.flexganttfx.view.util.Position;
import impl.com.flexganttfx.skin.container.DualGanttChartContainerSkin;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import org.controlsfx.control.MasterDetailPane;
import org.controlsfx.control.PropertySheet;

public abstract class DualGanttChartContainerBase<T extends GanttChartBase<?>>
extends ContainerBase<T> {
    private final MasterDetailPane masterDetailPane;
    private final ObjectProperty<T> primaryGanttChart = new SimpleObjectProperty((Object)this, "primaryGanttChart");
    private final ObjectProperty<Node> primaryHeader = new SimpleObjectProperty((Object)this, "primaryHeader");
    private final ObjectProperty<Node> primaryFooter = new SimpleObjectProperty((Object)this, "primaryFooter");
    private final ObjectProperty<Node> secondaryHeader = new SimpleObjectProperty((Object)this, "secondaryHeader");
    private final ObjectProperty<Node> secondaryFooter = new SimpleObjectProperty((Object)this, "secondaryFooter");
    private final ObjectProperty<T> secondaryGanttChart = new SimpleObjectProperty((Object)this, "secondaryGanttChart");
    private final BooleanProperty showSecondary = new SimpleBooleanProperty((Object)this, "showSecondary", true);
    private static final String DUAL_GANTT_CHART_CONTAINER_PROPERTIES_CATEGORY = "Control: Dual Gantt Chart Container";

    protected DualGanttChartContainerBase(boolean autoBinding, T primaryGanttChart, T secondaryGanttChart) {
        super(autoBinding);
        this.masterDetailPane = new MasterDetailPane(Side.BOTTOM);
        this.masterDetailPane.setId("dual-gantt-chart-master-detail-pane");
        this.primaryGanttChartProperty().addListener((observable, oldPrimaryGanttChart, newPrimaryGanttChart) -> {
            if (oldPrimaryGanttChart != null) {
                this.getGanttCharts().remove((Object)oldPrimaryGanttChart);
            }
            newPrimaryGanttChart.getTimeline().setId("primary timeline");
            this.getGanttCharts().add(0, (Object)newPrimaryGanttChart);
            newPrimaryGanttChart.setPosition(Position.FIRST);
        });
        this.secondaryGanttChartProperty().addListener((observable, oldSecondaryGanttChart, newSecondaryGanttChart) -> {
            if (oldSecondaryGanttChart != null) {
                this.getGanttCharts().remove((Object)oldSecondaryGanttChart);
            }
            newSecondaryGanttChart.getTimeline().setId("secondary timeline");
            this.getGanttCharts().add((Object)newSecondaryGanttChart);
            newSecondaryGanttChart.setPosition(Position.LAST);
        });
        this.setPrimaryGanttChart(primaryGanttChart);
        this.setSecondaryGanttChart(secondaryGanttChart);
    }

    protected DualGanttChartContainerBase(T primaryGanttChart, T secondaryGanttChart) {
        this(true, primaryGanttChart, secondaryGanttChart);
    }

    protected Skin<?> createDefaultSkin() {
        return new DualGanttChartContainerSkin(this);
    }

    public String getUserAgentStylesheet() {
        return GanttChart.class.getResource("gantt.css").toExternalForm();
    }

    public final MasterDetailPane getMasterDetailPane() {
        return this.masterDetailPane;
    }

    public final ObjectProperty<T> primaryGanttChartProperty() {
        return this.primaryGanttChart;
    }

    public final void setPrimaryGanttChart(T ganttChart) {
        this.primaryGanttChart.set(ganttChart);
    }

    public final T getPrimaryGanttChart() {
        return (T)((Object)((GanttChartBase)((Object)this.primaryGanttChart.get())));
    }

    public final ObjectProperty<Node> primaryHeaderProperty() {
        return this.primaryHeader;
    }

    public final void setPrimaryHeader(Node header) {
        this.primaryHeaderProperty().set((Object)header);
    }

    public final Node getPrimaryHeader() {
        return (Node)this.primaryHeaderProperty().get();
    }

    public final ObjectProperty<Node> primaryFooterProperty() {
        return this.primaryFooter;
    }

    public final void setPrimaryFooter(Node footer) {
        this.primaryFooterProperty().set((Object)footer);
    }

    public final Node getPrimaryFooter() {
        return (Node)this.primaryFooterProperty().get();
    }

    public final ObjectProperty<Node> secondaryHeaderProperty() {
        return this.secondaryHeader;
    }

    public final void setSecondaryHeader(Node header) {
        this.secondaryHeaderProperty().set((Object)header);
    }

    public final Node getSecondaryHeader() {
        return (Node)this.secondaryHeaderProperty().get();
    }

    public final ObjectProperty<Node> secondaryFooterProperty() {
        return this.secondaryFooter;
    }

    public final void setSecondaryFooter(Node footer) {
        this.secondaryFooter.set((Object)footer);
    }

    public final Node getSecondaryFooter() {
        return (Node)this.secondaryFooter.get();
    }

    public final ObjectProperty<T> secondaryGanttChartProperty() {
        return this.secondaryGanttChart;
    }

    public final void setSecondaryGanttChart(T ganttChart) {
        this.secondaryGanttChart.set(ganttChart);
    }

    public final T getSecondaryGanttChart() {
        return (T)((Object)((GanttChartBase)((Object)this.secondaryGanttChart.get())));
    }

    public final BooleanProperty showSecondaryProperty() {
        return this.showSecondary;
    }

    public final boolean isShowSecondary() {
        return this.showSecondaryProperty().get();
    }

    public final void setShowSecondary(boolean show) {
        this.showSecondaryProperty().set(show);
    }

    public final ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList items = FXCollections.observableArrayList();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DualGanttChartContainerBase.this.showSecondaryProperty());
            }

            @Override
            public void setValue(Object value) {
                DualGanttChartContainerBase.this.setShowSecondary((Boolean)value);
            }

            @Override
            public Object getValue() {
                return DualGanttChartContainerBase.this.isShowSecondary();
            }

            @Override
            public Class<?> getType() {
                return Boolean.class;
            }

            @Override
            public String getName() {
                return "Show Secondary";
            }

            @Override
            public String getDescription() {
                return "Show secondary chart";
            }

            @Override
            public String getCategory() {
                return DualGanttChartContainerBase.DUAL_GANTT_CHART_CONTAINER_PROPERTIES_CATEGORY;
            }
        });
        return items;
    }
}

