/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view;

import com.flexganttfx.core.LoggingDomain;
import com.flexganttfx.model.ActivityLink;
import com.flexganttfx.model.Calendar;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.ActivityEvent;
import com.flexganttfx.view.graphics.ListViewGraphics;
import com.flexganttfx.view.graphics.SingleRowGraphics;
import com.flexganttfx.view.timeline.Timeline;
import com.flexganttfx.view.util.FlexGanttFXControl;
import com.flexganttfx.view.util.Position;
import com.flexganttfx.view.util.TimelineScrollBar;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Level;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Label;
import org.controlsfx.control.MasterDetailPane;

public abstract class GanttChartBase<R extends Row<?, ?, ?>>
extends FlexGanttFXControl {
    private static final String DEFAULT_STYLE_CLASS = "gantt-chart";
    private ListViewGraphics<R> graphics;
    private final Timeline timeline;
    private final TimelineScrollBar timelineScrollBar;
    private final MasterDetailPane graphicsMasterDetailPane;
    private final ObjectProperty<Predicate<R>> rowFilter = new SimpleObjectProperty((Object)this, "rowFilter", row -> true);
    private final InvalidationListener redrawListener = observable -> {
        if (observable instanceof ReadOnlyProperty && LoggingDomain.RENDERING.isLoggable(Level.FINE)) {
            LoggingDomain.RENDERING.fine("redraw because of property change, property = " + ((ReadOnlyProperty)observable).getName());
        }
        if (this.graphics != null) {
            this.graphics.redraw();
        }
    };
    private final ObjectProperty<Node> graphicsHeader = new SimpleObjectProperty((Object)this, "graphicsHeader");
    private final InvalidationListener weakRedrawListener = new WeakInvalidationListener(this.redrawListener);
    private final ObjectProperty<Position> position = new SimpleObjectProperty((Object)this, "position", (Object)Position.ONLY);
    private final ObjectProperty<Timeline> masterTimeline = new SimpleObjectProperty((Object)this, "masterTimeline");
    private final ObjectProperty<Node> detail = new SimpleObjectProperty((Object)this, "detail");
    private final DoubleProperty fixedCellSize = new SimpleDoubleProperty((Object)this, "fixedCellSize", -1.0);
    private final BooleanProperty showDetail = new SimpleBooleanProperty((Object)this, "showDetail", false);

    protected GanttChartBase() {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.getStylesheets().add((Object)GanttChartBase.class.getResource("gantt.css").toExternalForm());
        this.timeline = this.createTimeline();
        this.setMasterTimeline(this.timeline);
        this.graphics = this.createGraphics();
        this.graphics.timelineProperty().bind(this.masterTimelineProperty());
        this.graphics.fixedCellSizeProperty().bind((ObservableValue)this.fixedCellSizeProperty());
        this.timelineScrollBar = new TimelineScrollBar();
        this.timelineScrollBar.timelineProperty().bind(this.masterTimelineProperty());
        Label noDetailsLabel = new Label("No Details");
        noDetailsLabel.setAlignment(Pos.CENTER);
        this.setDetail((Node)noDetailsLabel);
        this.graphicsMasterDetailPane = new MasterDetailPane(Side.RIGHT);
        this.graphicsMasterDetailPane.setDividerPosition(0.8);
        this.graphicsMasterDetailPane.setId("graphics-master-detail-pane");
        Bindings.bindBidirectional((Property)this.graphicsMasterDetailPane.showDetailNodeProperty(), (Property)this.showDetailProperty());
        this.redrawObservable((Observable)this.masterTimeline);
        SingleRowGraphics<Row<?, ?, ?>> eventlineGraphics = this.timeline.getEventline().getGraphics();
        eventlineGraphics.setOnActivityChange((EventHandler<ActivityEvent>)((EventHandler)evt -> this.getGraphics().redraw()));
    }

    public String getUserAgentStylesheet() {
        return super.getUserAgentStylesheet(GanttChartBase.class, "gantt.css");
    }

    public final ObjectProperty<Predicate<R>> rowFilterProperty() {
        return this.rowFilter;
    }

    public final void setRowFilter(Predicate<R> predicate) {
        this.rowFilter.set(predicate);
    }

    public final Predicate getRowFilter() {
        return (Predicate)this.rowFilter.get();
    }

    protected ListViewGraphics<R> createGraphics() {
        return new ListViewGraphics();
    }

    public final ObjectProperty<Node> graphicsHeaderProperty() {
        return this.graphicsHeader;
    }

    public final Node getGraphicsHeader() {
        return (Node)this.graphicsHeaderProperty().get();
    }

    public final void setGraphicsHeader(Node node) {
        Objects.requireNonNull(node);
        this.graphicsHeaderProperty().set((Object)node);
    }

    protected void redrawObservable(Observable property) {
        property.addListener(this.weakRedrawListener);
    }

    public final ObjectProperty<Position> positionProperty() {
        return this.position;
    }

    public final Position getPosition() {
        return (Position)((Object)this.positionProperty().get());
    }

    public final void setPosition(Position position) {
        Objects.requireNonNull(position);
        this.positionProperty().set((Object)position);
    }

    public final ObjectProperty<Timeline> masterTimelineProperty() {
        return this.masterTimeline;
    }

    public final Timeline getMasterTimeline() {
        return (Timeline)((Object)this.masterTimeline.get());
    }

    public final void setMasterTimeline(Timeline timeline) {
        Objects.requireNonNull(timeline);
        this.masterTimelineProperty().set((Object)timeline);
    }

    public final Timeline getTimeline() {
        return this.timeline;
    }

    protected Timeline createTimeline() {
        return new Timeline();
    }

    public final ListViewGraphics<R> getGraphics() {
        return this.graphics;
    }

    public final TimelineScrollBar getTimelineScrollBar() {
        return this.timelineScrollBar;
    }

    public MasterDetailPane getGraphicsMasterDetailPane() {
        return this.graphicsMasterDetailPane;
    }

    public final ObjectProperty<Node> detailProperty() {
        return this.detail;
    }

    public final void setDetail(Node node) {
        this.detailProperty().set((Object)node);
    }

    public final Node getDetail() {
        return (Node)this.detailProperty().get();
    }

    public final DoubleProperty fixedCellSizeProperty() {
        return this.fixedCellSize;
    }

    public final double getFixedCellSize() {
        return this.fixedCellSize.get();
    }

    public final void setFixedCellSize(double size) {
        this.fixedCellSizeProperty().set(size);
    }

    public final BooleanProperty showDetailProperty() {
        return this.showDetail;
    }

    public final boolean isShowDetail() {
        return this.showDetailProperty().get();
    }

    public final void setShowDetail(boolean show) {
        this.showDetailProperty().set(show);
    }

    public final ObservableList<Layer> getLayers() {
        return this.graphics.getLayers();
    }

    public final ObservableList<ActivityLink<?>> getLinks() {
        return this.graphics.getLinks();
    }

    public final ObservableList<Calendar<?>> getCalendars() {
        return this.graphics.getCalendars();
    }
}

