/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.msproject.view;

import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.msproject.model.MSProjectTaskActivity;
import com.flexganttfx.msproject.model.MSProjectTaskRow;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.renderer.ActivityBarRenderer;
import com.flexganttfx.view.graphics.renderer.CompletableActivityRenderer;
import com.flexganttfx.view.util.Position;
import javafx.scene.canvas.GraphicsContext;
import net.sf.mpxj.Task;

public class MSProjectTaskActivityRenderer
extends CompletableActivityRenderer<MSProjectTaskActivity> {
    public MSProjectTaskActivityRenderer(GraphicsBase<?> graphics) {
        super(graphics, "MSProject Task");
        this.setCornersRounded(true);
    }

    @Override
    public ActivityBounds drawActivity(ActivityRef<MSProjectTaskActivity> ref, Position position, GraphicsContext gc, double x, double y, double width, double height, boolean selected, boolean focused, boolean highlighted, boolean pressed) {
        ActivityBounds bounds = super.drawActivity(ref, position, gc, x, y, width, height, selected, focused, highlighted, pressed);
        MSProjectTaskActivity taskActivity = ref.getActivity();
        Task task = ((MSProjectTaskRow)taskActivity.getUserObject()).getTask();
        String resourceNames = task.getResourceNames();
        this.drawText(ref, taskActivity.getName(), ActivityBarRenderer.TextPosition.TRAILING, gc, x, y, width, height, selected, focused, highlighted, pressed);
        this.drawText(ref, resourceNames, ActivityBarRenderer.TextPosition.LEADING, gc, x, y, width, height, selected, focused, highlighted, pressed);
        return bounds;
    }

    @Override
    protected void drawBorder(ActivityRef<MSProjectTaskActivity> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        super.drawBorder(activityRef, position, gc, x, y, w, h, selected, hover, highlighted, pressed);
    }
}

