/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.msproject;

import com.flexganttfx.core.FlexGanttFX;
import com.flexganttfx.extras.GanttChartStatusBar;
import com.flexganttfx.extras.GanttChartToolBar;
import com.flexganttfx.msproject.model.MSProjectTaskRow;
import com.flexganttfx.msproject.view.MSProjectGanttChart;
import java.io.File;
import java.io.FileNotFoundException;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;

public class MSProjectApp
extends Application {
    private static final String STAGE_TITLE = "MSProject Reader";
    private MSProjectGanttChart gantt;
    private FileChooser fileChooser;
    private Stage stage;

    public void start(Stage stage) throws Exception {
        if (!FlexGanttFX.isLicenseKeySet()) {
            FlexGanttFX.setLicenseKey("LIC=DLSCDemos;VEN=DLSC;VER=1;PRO=STANDARD;RUN=no;CTR=1;SignCode=3F;Signature=302D02147A182E2D6FBFE9DDDC1018CAB639471975DEAFC002150093EE7CA750A1FF7B50972D6C01C17416E89A8CA2");
        }
        this.stage = stage;
        this.stage.setTitle(STAGE_TITLE);
        this.gantt = new MSProjectGanttChart();
        this.gantt.load("Example.mpp", MSProjectApp.class.getResourceAsStream("/n0741.mpp"));
        VBox.setVgrow((Node)this.gantt, (Priority)Priority.ALWAYS);
        VBox vbox = new VBox(0.0);
        MenuBar menuBar = this.createMenuBar();
        vbox.getChildren().add((Object)menuBar);
        GanttChartToolBar<MSProjectTaskRow> toolBar = new GanttChartToolBar<MSProjectTaskRow>(this.gantt);
        vbox.getChildren().add(toolBar);
        vbox.getChildren().add((Object)this.gantt);
        GanttChartStatusBar<MSProjectTaskRow> statusBar = new GanttChartStatusBar<MSProjectTaskRow>(this.gantt);
        vbox.getChildren().add(statusBar);
        Scene scene = new Scene((Parent)vbox);
        stage.setScene(scene);
        stage.sizeToScene();
        stage.centerOnScreen();
        stage.show();
    }

    private MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu fileMenu = new Menu("File");
        MenuItem openItem = new MenuItem("Open...");
        openItem.setOnAction(event -> this.openFile());
        fileMenu.getItems().add((Object)openItem);
        menuBar.getMenus().add((Object)fileMenu);
        return menuBar;
    }

    protected void openFile() {
        File file;
        if (this.fileChooser == null) {
            this.fileChooser = new FileChooser();
        }
        if ((file = this.fileChooser.showOpenDialog(this.gantt.getScene().getWindow())) != null) {
            try {
                this.gantt.load(file);
                this.stage.setTitle("MSProject Reader: " + file.getName());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        MSProjectApp.launch((String[])args);
    }
}

