/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.util;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;

public enum SimpleUnit implements TemporalUnit
{
    ONE(1L),
    TEN(10L),
    HUNDRED(100L),
    THOUSAND(1000L),
    THOUSAND_TEN(10000L),
    THOUSAND_HUNDRED(100000L),
    MILLION(1000000L),
    MILLION_TEN(10000000L),
    MILLION_HUNDRED(100000000L),
    BILLION(1000000000L),
    BILLION_TEN(10000000000L),
    BILLION_HUNDRED(100000000000L),
    TRILLION(1000000000000L);

    private long millis;

    private SimpleUnit(long millis) {
        this.millis = millis;
    }

    public long increment(long time) {
        return time + this.millis;
    }

    public long decrement(long time) {
        return time - this.millis;
    }

    public long truncate(long time) {
        return time / this.millis * this.millis;
    }

    public long getMillis() {
        return this.millis;
    }

    @Override
    public <R extends Temporal> R addTo(R temporal, long periodToAdd) {
        Instant instant = Instant.from(temporal);
        long millisToAdd = instant.toEpochMilli();
        return (R)Instant.ofEpochMilli(this.millis + millisToAdd);
    }

    @Override
    public long between(Temporal t1, Temporal t2) {
        return Instant.from(t2).toEpochMilli() - Instant.from(t1).toEpochMilli();
    }

    @Override
    public Duration getDuration() {
        return Duration.ofMillis(this.millis);
    }

    @Override
    public boolean isDateBased() {
        return false;
    }

    @Override
    public boolean isDurationEstimated() {
        return false;
    }

    @Override
    public boolean isSupportedBy(Temporal temporal) {
        return temporal instanceof Instant;
    }

    @Override
    public boolean isTimeBased() {
        return false;
    }
}

