/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.util;

import com.flexganttfx.model.Activity;
import com.flexganttfx.model.util.TimeInterval;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;

public class IntervalTree<A extends Activity> {
    private Entry<A> root;
    private int treeSize;
    private final boolean RED = false;
    private final boolean BLACK = true;

    public final Instant getEarliestTimeUsed() {
        if (this.root != null) {
            return Instant.ofEpochMilli(this.getEarliestTimeUsed(this.root));
        }
        return null;
    }

    private long getEarliestTimeUsed(Entry<A> entry) {
        if (entry.getLeft() != null) {
            return this.getEarliestTimeUsed(entry.getLeft());
        }
        return ((Entry)entry).low;
    }

    public final Instant getLatestTimeUsed() {
        if (this.root != null) {
            return Instant.ofEpochMilli(this.getLatestTimeUsed(this.root));
        }
        return null;
    }

    private long getLatestTimeUsed(Entry<A> entry) {
        if (entry.getRight() != null) {
            return this.getLatestTimeUsed(entry.getRight());
        }
        return ((Entry)entry).high;
    }

    public final boolean add(A activity) {
        Entry<A> entry = this.addEntry(activity);
        return entry != null;
    }

    public final boolean remove(A activity) {
        Entry<A> entry = this.getEntry((Activity)activity);
        if (entry == null) {
            return false;
        }
        this.deleteEntry(entry);
        return true;
    }

    public final Collection<A> removePeriod(TimeInterval interval) {
        Collection<A> result = this.getIntersectingObjects(interval);
        for (Activity activity : result) {
            this.deleteEntry(this.getEntry(activity));
        }
        return result;
    }

    public final Collection<A> getIntersectingObjects(TimeInterval interval) {
        return this.getIntersectingObjects(interval.getStartTime().toEpochMilli(), interval.getEndTime().toEpochMilli());
    }

    public final Collection<A> getIntersectingObjects(long start, long end) {
        ArrayList result = new ArrayList();
        if (this.root == null) {
            return result;
        }
        this.searchIntersecting(this.root, start, end, result);
        return result;
    }

    private void searchIntersecting(Entry<A> entry, long start, long end, Collection<A> result) {
        if (entry == null) {
            return;
        }
        long pLow = start;
        long pHigh = end;
        if (((Entry)entry).maxHigh < pLow) {
            return;
        }
        if (((Entry)entry).left != null) {
            this.searchIntersecting(((Entry)entry).left, start, end, result);
        }
        if (this.checkPLow(entry, pLow) || this.checkPHigh(entry, pHigh) || pLow <= ((Entry)entry).low && ((Entry)entry).high <= pHigh) {
            result.add(((Entry)entry).value);
        }
        if (pHigh < ((Entry)entry).low) {
            return;
        }
        if (((Entry)entry).right != null) {
            this.searchIntersecting(((Entry)entry).right, start, end, result);
        }
    }

    private boolean checkPLow(Entry<A> n, long pLow) {
        return ((Entry)n).low <= pLow && ((Entry)n).high > pLow;
    }

    private boolean checkPHigh(Entry<A> n, long pHigh) {
        return ((Entry)n).low < pHigh && ((Entry)n).high >= pHigh;
    }

    public final long size() {
        return this.treeSize;
    }

    public final void clear() {
        this.treeSize = 0;
        this.root = null;
    }

    private long getLow(Activity obj) {
        return obj.getStartTime() == null ? Long.MIN_VALUE : obj.getStartTime().toEpochMilli();
    }

    private long getHigh(Activity obj) {
        return obj.getEndTime() == null ? Long.MAX_VALUE : obj.getEndTime().toEpochMilli();
    }

    private void fixUpMaxHigh(Entry<A> x) {
        while (x != null) {
            x.maxHigh = Math.max(x.high, Math.max(x.left != null ? x.left.maxHigh : Long.MIN_VALUE, x.right != null ? x.right.maxHigh : Long.MIN_VALUE));
            x = x.parent;
        }
    }

    private Entry<A> getEntry(Activity activity) {
        Entry t = this.root;
        while (t != null) {
            int cmp = this.compareLongs(this.getLow(activity), t.low);
            if (cmp == 0) {
                cmp = this.compareLongs(this.getHigh(activity), t.high);
            }
            if (cmp == 0) {
                cmp = activity.hashCode() - ((Activity)t.value).hashCode();
            }
            if (cmp < 0) {
                t = t.left;
                continue;
            }
            if (cmp > 0) {
                t = t.right;
                continue;
            }
            return t;
        }
        return null;
    }

    private Entry<A> addEntry(A activity) {
        long cmp;
        Entry parent;
        if (activity == null) {
            throw new IllegalArgumentException("null element is not supported");
        }
        Entry t = this.root;
        if (t == null) {
            this.root = new Entry<A>(this.getLow((Activity)activity), this.getHigh((Activity)activity), activity, null);
            this.treeSize = 1;
            return this.root;
        }
        do {
            parent = t;
            cmp = this.compareLongs(this.getLow((Activity)activity), t.low);
            if (cmp == 0L && (cmp = (long)this.compareLongs(this.getHigh((Activity)activity), t.high)) == 0L) {
                cmp = activity.hashCode() - ((Activity)t.value).hashCode();
            }
            if (cmp < 0L) {
                t = t.left;
                continue;
            }
            if (cmp > 0L) {
                t = t.right;
                continue;
            }
            return null;
        } while (t != null);
        Entry<A> e = new Entry<A>(this.getLow((Activity)activity), this.getHigh((Activity)activity), activity, parent);
        if (cmp < 0L) {
            parent.left = (Entry)e;
        } else {
            parent.right = (Entry)e;
        }
        this.fixAfterInsertion(e);
        ++this.treeSize;
        return e;
    }

    private int compareLongs(long val1, long val2) {
        return val1 < val2 ? -1 : (val1 == val2 ? 0 : 1);
    }

    private <V> Entry<V> successor(Entry<V> t) {
        if (t == null) {
            return null;
        }
        if (t.right != null) {
            Entry p = t.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        Entry p = t.parent;
        Entry ch = t;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private <V> boolean colorOf(Entry<V> p) {
        return p == null ? true : ((Entry)p).color;
    }

    private <V> Entry<V> parentOf(Entry<V> p) {
        return p == null ? null : ((Entry)p).parent;
    }

    private <V> void setColor(Entry<V> p, boolean c2) {
        if (p != null) {
            ((Entry)p).color = c2;
        }
    }

    private <V> Entry<V> leftOf(Entry<V> p) {
        return p == null ? null : ((Entry)p).left;
    }

    private <V> Entry<V> rightOf(Entry<V> p) {
        return p == null ? null : ((Entry)p).right;
    }

    private void rotateLeft(Entry<A> p) {
        if (p != null) {
            Entry r = ((Entry)p).right;
            ((Entry)p).right = r.left;
            if (r.left != null) {
                r.left.parent = (Entry)p;
            }
            r.parent = ((Entry)p).parent;
            if (((Entry)p).parent == null) {
                this.root = r;
            } else if (((Entry)p).parent.left == p) {
                ((Entry)p).parent.left = r;
            } else {
                ((Entry)p).parent.right = r;
            }
            r.left = (Entry)p;
            ((Entry)p).parent = r;
            ((Entry)p).maxHigh = Math.max(((Entry)p).left != null ? ((Entry)p).left.maxHigh : Long.MIN_VALUE, Math.max(((Entry)p).right != null ? ((Entry)p).right.maxHigh : Long.MIN_VALUE, ((Entry)p).high));
            r.maxHigh = Math.max(((Entry)p).maxHigh, Math.max(r.right != null ? r.right.maxHigh : Long.MIN_VALUE, r.high));
        }
    }

    private void rotateRight(Entry<A> p) {
        if (p != null) {
            Entry l = ((Entry)p).left;
            ((Entry)p).left = l.right;
            if (l.right != null) {
                l.right.parent = (Entry)p;
            }
            l.parent = ((Entry)p).parent;
            if (((Entry)p).parent == null) {
                this.root = l;
            } else if (((Entry)p).parent.right == p) {
                ((Entry)p).parent.right = l;
            } else {
                ((Entry)p).parent.left = l;
            }
            l.right = (Entry)p;
            ((Entry)p).parent = l;
            ((Entry)p).maxHigh = Math.max(((Entry)p).left != null ? ((Entry)p).left.maxHigh : Long.MIN_VALUE, Math.max(((Entry)p).right != null ? ((Entry)p).right.maxHigh : Long.MIN_VALUE, ((Entry)p).high));
            l.maxHigh = Math.max(((Entry)p).maxHigh, Math.max(l.left != null ? l.left.maxHigh : Long.MIN_VALUE, l.high));
        }
    }

    private void fixAfterInsertion(Entry<A> x) {
        this.fixUpMaxHigh(((Entry)x).parent);
        ((Entry)x).color = false;
        while (x != null && x != this.root && !((Entry)x).parent.color) {
            Entry<A> y;
            if (this.parentOf(x) == this.leftOf(this.parentOf(this.parentOf(x)))) {
                y = this.rightOf(this.parentOf(this.parentOf(x)));
                if (!this.colorOf(y)) {
                    this.setColor(this.parentOf(x), true);
                    this.setColor(y, true);
                    this.setColor(this.parentOf(this.parentOf(x)), false);
                    x = this.parentOf(this.parentOf(x));
                    continue;
                }
                if (x == this.rightOf(this.parentOf(x))) {
                    x = this.parentOf(x);
                    this.rotateLeft(x);
                }
                this.setColor(this.parentOf(x), true);
                this.setColor(this.parentOf(this.parentOf(x)), false);
                this.rotateRight(this.parentOf(this.parentOf(x)));
                continue;
            }
            y = this.leftOf(this.parentOf(this.parentOf(x)));
            if (!this.colorOf(y)) {
                this.setColor(this.parentOf(x), true);
                this.setColor(y, true);
                this.setColor(this.parentOf(this.parentOf(x)), false);
                x = this.parentOf(this.parentOf(x));
                continue;
            }
            if (x == this.leftOf(this.parentOf(x))) {
                x = this.parentOf(x);
                this.rotateRight(x);
            }
            this.setColor(this.parentOf(x), true);
            this.setColor(this.parentOf(this.parentOf(x)), false);
            this.rotateLeft(this.parentOf(this.parentOf(x)));
        }
        ((Entry)this.root).color = true;
    }

    private void deleteEntry(Entry<A> p) {
        Entry replacement;
        --this.treeSize;
        if (((Entry)p).left != null && ((Entry)p).right != null) {
            Entry<A> s = this.successor(p);
            ((Entry)p).low = ((Entry)s).low;
            ((Entry)p).high = ((Entry)s).high;
            ((Entry)p).value = ((Entry)s).value;
            ((Entry)p).maxHigh = ((Entry)s).maxHigh;
            p = s;
        }
        Entry entry = replacement = ((Entry)p).left != null ? ((Entry)p).left : ((Entry)p).right;
        if (replacement != null) {
            replacement.parent = ((Entry)p).parent;
            if (((Entry)p).parent == null) {
                this.root = replacement;
            } else if (p == ((Entry)p).parent.left) {
                ((Entry)p).parent.left = replacement;
            } else {
                ((Entry)p).parent.right = replacement;
            }
            ((Entry)p).left = null;
            ((Entry)p).right = null;
            ((Entry)p).parent = null;
            this.fixUpMaxHigh(replacement.parent);
            if (((Entry)p).color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (((Entry)p).parent == null) {
            this.root = null;
        } else {
            if (((Entry)p).color) {
                this.fixAfterDeletion(p);
            }
            if (((Entry)p).parent != null) {
                if (p == ((Entry)p).parent.left) {
                    ((Entry)p).parent.left = null;
                } else if (p == ((Entry)p).parent.right) {
                    ((Entry)p).parent.right = null;
                }
                this.fixUpMaxHigh(((Entry)p).parent);
                ((Entry)p).parent = null;
            }
        }
    }

    private void fixAfterDeletion(Entry<A> x) {
        while (x != this.root && this.colorOf(x)) {
            Entry<A> sib;
            if (x == this.leftOf(this.parentOf(x))) {
                sib = this.rightOf(this.parentOf(x));
                if (!this.colorOf(sib)) {
                    this.setColor(sib, true);
                    this.setColor(this.parentOf(x), false);
                    this.rotateLeft(this.parentOf(x));
                    sib = this.rightOf(this.parentOf(x));
                }
                if (this.colorOf(this.leftOf(sib)) && this.colorOf(this.rightOf(sib))) {
                    this.setColor(sib, false);
                    x = this.parentOf(x);
                    continue;
                }
                if (this.colorOf(this.rightOf(sib))) {
                    this.setColor(this.leftOf(sib), true);
                    this.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = this.rightOf(this.parentOf(x));
                }
                this.setColor(sib, this.colorOf(this.parentOf(x)));
                this.setColor(this.parentOf(x), true);
                this.setColor(this.rightOf(sib), true);
                this.rotateLeft(this.parentOf(x));
                x = this.root;
                continue;
            }
            sib = this.leftOf(this.parentOf(x));
            if (!this.colorOf(sib)) {
                this.setColor(sib, true);
                this.setColor(this.parentOf(x), false);
                this.rotateRight(this.parentOf(x));
                sib = this.leftOf(this.parentOf(x));
            }
            if (this.colorOf(this.rightOf(sib)) && this.colorOf(this.leftOf(sib))) {
                this.setColor(sib, false);
                x = this.parentOf(x);
                continue;
            }
            if (this.colorOf(this.leftOf(sib))) {
                this.setColor(this.rightOf(sib), true);
                this.setColor(sib, false);
                this.rotateLeft(sib);
                sib = this.leftOf(this.parentOf(x));
            }
            this.setColor(sib, this.colorOf(this.parentOf(x)));
            this.setColor(this.parentOf(x), true);
            this.setColor(this.leftOf(sib), true);
            this.rotateRight(this.parentOf(x));
            x = this.root;
        }
        this.setColor(x, true);
    }

    private final class Entry<V> {
        private long low;
        private long high;
        private V value;
        private long maxHigh = Long.MIN_VALUE;
        private Entry<V> left = null;
        private Entry<V> right = null;
        private Entry<V> parent;
        private boolean color = true;

        Entry(long low, long high, V value, Entry<V> parent) {
            this.low = low;
            this.high = high;
            this.value = value;
            this.parent = parent;
            this.maxHigh = high;
        }

        public String toString() {
            return "[" + Instant.ofEpochMilli(this.low) + " - " + Instant.ofEpochMilli(this.high) + "]=" + this.value;
        }

        public Entry<V> getLeft() {
            return this.left;
        }

        public Entry<V> getRight() {
            return this.right;
        }
    }
}

