/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.timeline;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;

public abstract class TimelineModel<T extends TemporalUnit> {
    private Instant _horizonStartTime;
    private ObjectProperty<Instant> horizonStartTime;
    private Instant _horizonEndTime;
    private ObjectProperty<Instant> horizonEndTime;
    private final DoubleProperty millisPerPixel = new SimpleDoubleProperty(this, "millisPerPixel", 2880000.0){

        public void set(double newValue) {
            double min = TimelineModel.this.getMinimumMillisPerPixel();
            double max = TimelineModel.this.getMaximumMillisPerPixel();
            super.set(Math.max(min, Math.min(max, newValue)));
        }
    };
    private final DoubleProperty minimumMillisPerPixel = new SimpleDoubleProperty(this, "minimumMillisPerPixel", 1.0){

        public void set(double newValue) {
            if (newValue < 0.0) {
                throw new IllegalArgumentException("minimum millis per pixel must be >= 0");
            }
            super.set(newValue);
            if (TimelineModel.this.getMillisPerPixel() < newValue) {
                TimelineModel.this.setMillisPerPixel(newValue);
            }
        }
    };
    private final DoubleProperty maximumMillisPerPixel = new SimpleDoubleProperty(this, "maximumMillisPerPixel", Double.MAX_VALUE){

        public void set(double newValue) {
            super.set(newValue);
            if (TimelineModel.this.getMillisPerPixel() > newValue) {
                TimelineModel.this.setMillisPerPixel(newValue);
            }
        }
    };
    private final ObjectProperty<Instant> startTime = new SimpleObjectProperty<Instant>((Object)this, "startTime", Instant.now()){

        public void set(Instant newTime) {
            Instant horizonStart = TimelineModel.this.getHorizonStartTime();
            if (horizonStart != null && horizonStart.isAfter(newTime)) {
                return;
            }
            Instant horizonEnd = TimelineModel.this.getHorizonEndTime();
            if (horizonEnd != null && horizonEnd.isBefore(newTime)) {
                return;
            }
            super.set((Object)newTime);
        }
    };
    private final ObjectProperty<Instant> now = new SimpleObjectProperty((Object)this, "now", (Object)Instant.now());
    private final ReadOnlyDoubleWrapper nowLocation = new ReadOnlyDoubleWrapper((Object)this, "nowLocation", 0.0);
    private final ReadOnlyObjectWrapper<T> smallestTemporalUnit = new ReadOnlyObjectWrapper((Object)this, "smallestTemporalUnit");

    protected TimelineModel() {
        InvalidationListener updateNowListener = it -> this.updateNowLocation();
        this.nowProperty().addListener(updateNowListener);
        this.startTimeProperty().addListener(updateNowListener);
        this.millisPerPixelProperty().addListener(updateNowListener);
    }

    private void updateNowLocation() {
        this.nowLocation.set(this.calculateLocationForTime(this.getNow()));
    }

    public final ObjectProperty<Instant> horizonStartTimeProperty() {
        if (this.horizonStartTime == null) {
            this.horizonStartTime = new SimpleObjectProperty((Object)this, "horizonStart", (Object)this._horizonStartTime);
        }
        return this.horizonStartTime;
    }

    public final Instant getHorizonStartTime() {
        return this.horizonStartTime == null ? this._horizonStartTime : (Instant)this.horizonStartTime.get();
    }

    public final void setHorizonStartTime(Instant time) {
        if (this.horizonStartTime == null) {
            this._horizonStartTime = time;
        } else {
            this.horizonStartTime.set((Object)time);
        }
    }

    public final ObjectProperty<Instant> horizonEndTimeProperty() {
        if (this.horizonEndTime == null) {
            this.horizonEndTime = new SimpleObjectProperty((Object)this, "horizonEndTime", (Object)this._horizonEndTime);
        }
        return this.horizonEndTime;
    }

    public final Instant getHorizonEndTime() {
        return this.horizonEndTime == null ? this._horizonEndTime : (Instant)this.horizonEndTime.get();
    }

    public final void setHorizonEndTime(Instant time) {
        if (this.horizonEndTime == null) {
            this._horizonEndTime = time;
        } else {
            this.horizonEndTime.set((Object)time);
        }
    }

    public final DoubleProperty millisPerPixelProperty() {
        return this.millisPerPixel;
    }

    public final void setMillisPerPixel(double millis) {
        this.millisPerPixelProperty().set(millis);
    }

    public final double getMillisPerPixel() {
        return this.millisPerPixelProperty().get();
    }

    public final DoubleProperty minimumMillisPerPixelProperty() {
        return this.minimumMillisPerPixel;
    }

    public final void setMinimumMillisPerPixel(double min) {
        this.minimumMillisPerPixel.set(min);
    }

    public final double getMinimumMillisPerPixel() {
        return this.minimumMillisPerPixel.get();
    }

    public final DoubleProperty maximumMillisPerPixelProperty() {
        return this.maximumMillisPerPixel;
    }

    public final void setMaximumMillisPerPixel(double max) {
        this.maximumMillisPerPixel.set(max);
    }

    public final double getMaximumMillisPerPixel() {
        return this.maximumMillisPerPixel.get();
    }

    public final void setZoomRange(T smallestUnit, int smallestUnitCount, double smallestUnitWidth, T largestUnit, int largestUnitCount, double largestUnitWidth) {
        long max;
        Objects.requireNonNull(smallestUnit);
        Objects.requireNonNull(largestUnit);
        if (smallestUnit.getDuration().toMillis() > largestUnit.getDuration().toMillis()) {
            throw new IllegalArgumentException("zoom range start unit can not be larger than end unit, start = " + smallestUnit + ", end = " + largestUnit);
        }
        if (smallestUnitCount < 1) {
            throw new IllegalArgumentException("smallest unit count must be >= 1 but was " + smallestUnitCount);
        }
        if (largestUnitCount < 1) {
            throw new IllegalArgumentException("largest unit count must be >= 1 but was " + largestUnitCount);
        }
        if (smallestUnitWidth < 10.0) {
            throw new IllegalArgumentException("smallest unit width must be >= 10 but was " + smallestUnitWidth);
        }
        if (largestUnitWidth < 10.0) {
            throw new IllegalArgumentException("largest unit width must be >= 10 but was " + largestUnitWidth);
        }
        long min = (long)((double)(smallestUnit.getDuration().toMillis() * (long)smallestUnitCount) / smallestUnitWidth);
        if (min > (max = (long)((double)(largestUnit.getDuration().toMillis() * (long)largestUnitCount) / largestUnitWidth))) {
            throw new IllegalArgumentException("minimum MPP value can not be larger than maximum MPP value, min = " + min + ", max = " + max);
        }
        this.smallestTemporalUnit.set(smallestUnit);
        this.setMinimumMillisPerPixel(min);
        this.setMaximumMillisPerPixel(max);
    }

    public final ObjectProperty<Instant> startTimeProperty() {
        return this.startTime;
    }

    public final void setStartTime(Instant time) {
        this.startTimeProperty().set((Object)time);
    }

    public final Instant getStartTime() {
        return (Instant)this.startTimeProperty().get();
    }

    public final ObjectProperty<Instant> nowProperty() {
        return this.now;
    }

    public final void setNow(Instant now) {
        this.nowProperty().set((Object)now);
    }

    public final Instant getNow() {
        return (Instant)this.nowProperty().get();
    }

    public final ReadOnlyDoubleProperty nowLocationProperty() {
        return this.nowLocation.getReadOnlyProperty();
    }

    public final double getNowLocation() {
        return this.nowLocation.get();
    }

    public final ReadOnlyObjectProperty<T> smallestTemporalUnitProperty() {
        return this.smallestTemporalUnit.getReadOnlyProperty();
    }

    public final T getSmallestTemporalUnit() {
        return (T)((TemporalUnit)this.smallestTemporalUnitProperty().get());
    }

    public final double calculateLocationForTime(Instant time) {
        if (time == null) {
            return -1.0;
        }
        if (time.equals(Instant.MAX)) {
            return Double.MAX_VALUE;
        }
        if (time.equals(Instant.MIN)) {
            return Double.MIN_VALUE;
        }
        long startTimeMillis = this.getStartTime().toEpochMilli();
        long timeMillis = time.toEpochMilli();
        long millisDifference = timeMillis - startTimeMillis;
        return (double)millisDifference / this.getMillisPerPixel();
    }

    public final Instant calculateTimeForLocation(double location) {
        long millis = (long)(location * this.getMillisPerPixel());
        Instant startTime = this.getStartTime();
        return startTime.plus(Duration.ofMillis(millis));
    }
}

