/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.repository;

import com.flexganttfx.core.LoggingDomain;
import com.flexganttfx.model.Activity;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.repository.MutableActivityRepositoryBase;
import com.flexganttfx.model.repository.RepositoryEvent;
import com.flexganttfx.model.util.IntervalTree;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;

public class IntervalTreeActivityRepository<A extends Activity>
extends MutableActivityRepositoryBase<A> {
    private Map<Layer, IntervalTree<A>> treeMap = new HashMap<Layer, IntervalTree<A>>();

    private IntervalTree<A> getTree(Layer layer) {
        IntervalTree<A> tree = this.treeMap.get(layer);
        if (tree == null) {
            tree = new IntervalTree();
            this.treeMap.put(layer, tree);
        }
        return tree;
    }

    @Override
    public final void addActivity(ActivityRef<A> activityRef) {
        A activity = activityRef.getActivity();
        Layer layer = activityRef.getLayer();
        IntervalTree<A> tree = this.getTree(layer);
        tree.add(activity);
        if (LoggingDomain.REPOSITORY.isLoggable(Level.FINER)) {
            LoggingDomain.REPOSITORY.finer("added activity " + activity.getName() + ", layer = " + layer.getName() + ", row = " + activityRef.getRow().getName() + ", activity count = " + tree.size());
        }
        this.fireEvent(new RepositoryEvent(RepositoryEvent.ACTIVITY_ADDED, this, activityRef));
    }

    @Override
    public final void removeActivity(ActivityRef<A> activityRef) {
        A activity = activityRef.getActivity();
        Layer layer = activityRef.getLayer();
        IntervalTree<A> tree = this.getTree(layer);
        boolean member = tree.remove(activity);
        if (LoggingDomain.REPOSITORY.isLoggable(Level.FINER)) {
            LoggingDomain.REPOSITORY.finer("removed activity " + activity.getName() + " from layer " + layer.getName() + ", row = " + activityRef.getRow().getName() + ", was member = " + member + ", new activities count = " + tree.size());
        }
        if (!member) {
            throw new IllegalArgumentException("given activity was not a member of this repository, maybe the start and / or end time were modified before the remove?");
        }
        this.fireEvent(new RepositoryEvent(RepositoryEvent.ACTIVITY_REMOVED, this, activityRef));
    }

    @Override
    public final void clearActivities() {
        for (Layer layer : this.treeMap.keySet()) {
            IntervalTree<A> tree = this.getTree(layer);
            tree.clear();
        }
        this.fireEvent(new RepositoryEvent(this));
    }

    @Override
    public final void clearActivities(Layer layer) {
        Objects.requireNonNull(layer);
        IntervalTree<A> tree = this.getTree(layer);
        tree.clear();
        this.fireEvent(new RepositoryEvent(this));
    }

    @Override
    public final Instant getEarliestTimeUsed() {
        if (!this.treeMap.isEmpty()) {
            Instant time = null;
            for (IntervalTree<A> tree : this.treeMap.values()) {
                Instant earliest = tree.getEarliestTimeUsed();
                if (earliest == null || time != null && !earliest.isBefore(time)) continue;
                time = earliest;
            }
            if (LoggingDomain.REPOSITORY.isLoggable(Level.FINER)) {
                LoggingDomain.REPOSITORY.finer("returning " + time + " for earliest time used");
            }
            return time;
        }
        return null;
    }

    @Override
    public final Instant getLatestTimeUsed() {
        if (!this.treeMap.isEmpty()) {
            Instant time = null;
            for (IntervalTree<A> tree : this.treeMap.values()) {
                Instant latest = tree.getLatestTimeUsed();
                if (latest == null || time != null && !latest.isAfter(time)) continue;
                time = latest;
            }
            if (LoggingDomain.REPOSITORY.isLoggable(Level.FINER)) {
                LoggingDomain.REPOSITORY.finer("returning " + time + " for latest time used");
            }
            return time;
        }
        return null;
    }

    @Override
    public final Iterator<A> getActivities(Layer layer, Instant startTime, Instant endTime, TemporalUnit temporalUnit, ZoneId zoneId) {
        if (LoggingDomain.REPOSITORY.isLoggable(Level.FINEST)) {
            LoggingDomain.REPOSITORY.finest("layer = " + layer + ", temporal unit = " + temporalUnit + ", zone = " + zoneId + ", startTime = " + startTime + ", endTime = " + endTime);
        }
        IntervalTree<A> tree = this.getTree(layer);
        Collection<A> activities = tree.getIntersectingObjects(startTime.toEpochMilli(), endTime.toEpochMilli());
        return activities.iterator();
    }

    public final List<A> getAllActivities() {
        Instant st = this.getEarliestTimeUsed();
        Instant et = this.getLatestTimeUsed();
        ArrayList<A> result = new ArrayList<A>();
        if (st != null && et != null) {
            for (IntervalTree<A> tree : this.treeMap.values()) {
                result.addAll(tree.getIntersectingObjects(st.toEpochMilli(), et.toEpochMilli()));
            }
        }
        return result;
    }
}

