/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.dateline;

import com.flexganttfx.model.dateline.VirtualGrid;
import com.flexganttfx.model.util.ChronoUnitUtils;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Objects;

public final class ChronoUnitGrid
extends VirtualGrid<ChronoUnit> {
    public ChronoUnitGrid(String name, String shortName, ChronoUnit unit, int amount) {
        super(name, shortName, unit, amount);
    }

    public ChronoUnitGrid(String name, ChronoUnit unit, int amount) {
        super(name, unit, amount);
    }

    @Override
    public Instant adjustTime(Instant instant, ZoneId zoneId, boolean roundUp, DayOfWeek firstDayOfWeek) {
        Objects.requireNonNull(instant);
        Objects.requireNonNull(zoneId);
        Objects.requireNonNull(firstDayOfWeek);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, zoneId);
        if (roundUp) {
            zonedDateTime = zonedDateTime.plus(this.getAmount(), (TemporalUnit)this.getUnit());
        }
        zonedDateTime = ChronoUnitUtils.truncate(zonedDateTime, (ChronoUnit)this.getUnit(), this.getAmount(), firstDayOfWeek);
        return Instant.from(zonedDateTime);
    }

    @Override
    public LocalTime adjustTime(LocalTime time, boolean roundUp) {
        Objects.requireNonNull(time);
        if (roundUp) {
            time = time.plus(this.getAmount(), (TemporalUnit)this.getUnit());
        }
        return ChronoUnitUtils.truncate(time, (ChronoUnit)this.getUnit(), this.getAmount());
    }
}

