/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.activity;

import com.flexganttfx.model.activity.ActivityBase;
import com.flexganttfx.model.activity.MutableActivity;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public class MutableActivityBase<T>
extends ActivityBase<T>
implements MutableActivity {
    public MutableActivityBase() {
    }

    public MutableActivityBase(String name) {
        super(name);
    }

    public MutableActivityBase(Instant startTime, Instant endTime) {
        super(startTime, endTime);
    }

    public MutableActivityBase(String name, Instant startTime, Instant endTime) {
        super(name, startTime, endTime);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setStartTime(Instant time) {
        Objects.requireNonNull(time);
        this.startTime = time;
    }

    @Override
    public void setEndTime(Instant time) {
        Objects.requireNonNull(time);
        this.endTime = time;
    }

    public void setDuration(Duration duration) {
        Objects.requireNonNull(duration);
        this.setEndTime(this.getStartTime().plus(duration));
    }

    public Duration getDuration() {
        return Duration.between(this.getStartTime(), this.getEndTime());
    }

    public void addDuration(Duration duration) {
        Objects.requireNonNull(duration);
        this.addDuration(duration, 1L);
    }

    public void addDuration(Duration duration, long multipliedBy) {
        Objects.requireNonNull(duration);
        this.setEndTime(this.getEndTime().plus(duration.multipliedBy(multipliedBy)));
    }
}

