/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model;

import com.flexganttfx.model.Activity;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.ActivityRepository;
import com.flexganttfx.model.Calendar;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Layout;
import com.flexganttfx.model.LinesManager;
import com.flexganttfx.model.exception.RepositoryException;
import com.flexganttfx.model.layout.EqualLinesManager;
import com.flexganttfx.model.layout.GanttLayout;
import com.flexganttfx.model.repository.IntervalTreeActivityRepository;
import com.flexganttfx.model.repository.MutableActivityRepository;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.transformation.FilteredList;

public abstract class Row<P extends Row<?, ?, ?>, C extends Row<?, ?, ?>, A extends Activity> {
    public static final double DEFAULT_ROW_HEIGHT = 24.0;
    private ObservableMap<Object, Object> properties;
    private ReadOnlyObjectWrapper<P> parent = new ReadOnlyObjectWrapper((Object)this, "parent");
    private ListChangeListener<Row> childrenChangeListener = c2 -> {
        while (c2.next()) {
            for (Row row : c2.getRemoved()) {
                row.setParent(null);
            }
            for (Row row : c2.getAddedSubList()) {
                row.setParent(this);
            }
        }
    };
    private InvalidationListener childrenInvalidationListener = c2 -> this.setLeaf(this.children == null || this.children.isEmpty());
    private ObservableList<C> children;
    private ReadOnlyBooleanWrapper leaf;
    private BooleanProperty expanded = new SimpleBooleanProperty((Object)this, "expanded", false);
    private ReadOnlyBooleanWrapper showing = new ReadOnlyBooleanWrapper((Object)this, "showing", false);
    private final ObjectProperty<Layout> layout = new SimpleObjectProperty((Object)this, "layout", (Object)new GanttLayout());
    private final ObjectProperty<ActivityRepository<A>> repository = new SimpleObjectProperty((Object)this, "repository");
    private final StringProperty name = new SimpleStringProperty((Object)this, "name", "Default");
    private final DoubleProperty height = new SimpleDoubleProperty((Object)this, "height", 24.0);
    private final DoubleProperty minHeight = new SimpleDoubleProperty((Object)this, "minHeight", 24.0);
    private final DoubleProperty maxHeight = new SimpleDoubleProperty((Object)this, "maxHeight", 500.0);
    private ObjectProperty<Object> userObject;
    private final ObjectProperty<LinesManager<A>> linesManager = new SimpleObjectProperty((Object)this, "linesLayout");
    private ObjectProperty<ZoneId> zoneId;
    private final ObservableList<Calendar<?>> calendars = FXCollections.observableArrayList();
    private IntegerProperty lineCount = new SimpleIntegerProperty((Object)this, "lineCount", 0);

    public Row() {
        this.setRepository(new IntervalTreeActivityRepository());
        this.setLinesManager(new EqualLinesManager(this));
    }

    public Row(String name) {
        this();
        this.setName(name);
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
            this.properties.addListener(change -> {
                if (change.getKey().equals("com.flexganttfx.row.showing") && change.getValueAdded() != null) {
                    Boolean shown = (Boolean)change.getValueAdded();
                    this.showing.set(shown.booleanValue());
                    this.properties.remove((Object)"com.flexganttfx.row.showing");
                }
            });
        }
        return this.properties;
    }

    public final boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    private void setParent(P value) {
        this.parent.setValue(value);
    }

    public final P getParent() {
        return (P)(this.parent == null ? null : (Row)this.parent.getValue());
    }

    public final ReadOnlyObjectProperty<P> parentProperty() {
        return this.parent.getReadOnlyProperty();
    }

    public final Row[] getPath() {
        ArrayList<P> list = new ArrayList<P>();
        for (P parent = this.getParent(); parent != null; parent = ((Row)parent).getParent()) {
            list.add(0, parent);
        }
        return list.toArray(new Row[list.size()]);
    }

    public final ObservableList<C> getChildren() {
        if (this.children == null) {
            this.children = FXCollections.observableArrayList();
            this.children.addListener(this.childrenInvalidationListener);
            this.children.addListener(this.childrenChangeListener);
        }
        return this.children;
    }

    public boolean hasChildren(Predicate predicate) {
        return this.doHasChildren(this, predicate);
    }

    private boolean doHasChildren(Row row, Predicate predicate) {
        boolean foundChild;
        block2: {
            Object child;
            foundChild = false;
            FilteredList filteredList = new FilteredList(row.getChildren());
            filteredList.setPredicate(predicate);
            if (!filteredList.isEmpty()) {
                foundChild = true;
            }
            if (foundChild) break block2;
            Iterator iterator = row.getChildren().iterator();
            while (iterator.hasNext() && !(foundChild = this.doHasChildren((Row)(child = iterator.next()), predicate))) {
            }
        }
        return foundChild;
    }

    private void setLeaf(boolean value) {
        if (value && this.leaf == null) {
            return;
        }
        if (this.leaf == null) {
            this.leaf = new ReadOnlyBooleanWrapper((Object)this, "leaf", true);
        }
        this.leaf.setValue(Boolean.valueOf(value));
    }

    public boolean isLeaf() {
        return this.leaf == null ? true : this.leaf.getValue();
    }

    public final ReadOnlyBooleanProperty leafProperty() {
        if (this.leaf == null) {
            this.leaf = new ReadOnlyBooleanWrapper((Object)this, "leaf", true);
        }
        return this.leaf.getReadOnlyProperty();
    }

    public final BooleanProperty expandedProperty() {
        return this.expanded;
    }

    public final void setExpanded(boolean expanded) {
        this.expandedProperty().set(expanded);
    }

    public final boolean isExpanded() {
        return this.expandedProperty().get();
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showing.getReadOnlyProperty();
    }

    public final boolean isShowing() {
        return this.showing.get();
    }

    public final ObjectProperty<Layout> layoutProperty() {
        return this.layout;
    }

    public final Layout getLayout() {
        return (Layout)this.layoutProperty().get();
    }

    public final void setLayout(Layout layout) {
        Objects.requireNonNull(layout);
        this.layoutProperty().set((Object)layout);
    }

    public final ObjectProperty<ActivityRepository<A>> repositoryProperty() {
        return this.repository;
    }

    public final ActivityRepository<A> getRepository() {
        return (ActivityRepository)this.repositoryProperty().get();
    }

    public final void setRepository(ActivityRepository<A> repository) {
        Objects.requireNonNull(repository);
        this.repositoryProperty().set(repository);
    }

    public final Instant getEarliestTimeUsed() {
        return this.getRepository().getEarliestTimeUsed();
    }

    public final Instant getLatestTimeUsed() {
        return this.getRepository().getLatestTimeUsed();
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        Objects.requireNonNull(name);
        this.nameProperty().set((Object)name);
    }

    public final DoubleProperty heightProperty() {
        return this.height;
    }

    public final void setHeight(double height) {
        this.heightProperty().set(height);
    }

    public final double getHeight() {
        return this.heightProperty().get();
    }

    public final DoubleProperty minHeightProperty() {
        return this.minHeight;
    }

    public final void setMinHeight(double height) {
        this.minHeightProperty().set(height);
    }

    public final double getMinHeight() {
        return this.minHeightProperty().get();
    }

    public final DoubleProperty maxHeightProperty() {
        return this.maxHeight;
    }

    public final void setMaxHeight(double height) {
        this.maxHeightProperty().set(height);
    }

    public final double getMaxHeight() {
        return this.maxHeightProperty().get();
    }

    public final ObjectProperty<Object> userObjectProperty() {
        if (this.userObject == null) {
            this.userObject = new SimpleObjectProperty((Object)this, "userObject");
        }
        return this.userObject;
    }

    public final Object getUserObject() {
        return this.userObject == null ? null : this.userObject.get();
    }

    public final void setUserObject(Object obj) {
        if (this.userObject == null && obj == null) {
            return;
        }
        this.userObjectProperty().set(obj);
    }

    public final ObjectProperty<LinesManager<A>> linesManagerProperty() {
        return this.linesManager;
    }

    public final LinesManager<A> getLinesManager() {
        return (LinesManager)this.linesManagerProperty().get();
    }

    public final void setLinesManager(LinesManager<A> manager) {
        Objects.requireNonNull(manager);
        this.linesManagerProperty().set(manager);
    }

    public final ObjectProperty<ZoneId> zoneIdProperty() {
        if (this.zoneId == null) {
            this.zoneId = new SimpleObjectProperty((Object)this, "zoneId", (Object)ZoneId.systemDefault());
        }
        return this.zoneId;
    }

    public final ZoneId getZoneId() {
        return this.zoneId == null ? ZoneId.systemDefault() : (ZoneId)this.zoneId.get();
    }

    public final void setZoneId(ZoneId zoneId) {
        Objects.requireNonNull(zoneId);
        this.zoneIdProperty().set((Object)zoneId);
    }

    public final ObservableList<Calendar<?>> getCalendars() {
        return this.calendars;
    }

    public final IntegerProperty lineCountProperty() {
        return this.lineCount;
    }

    public final void setLineCount(int count) {
        this.lineCountProperty().set(count);
    }

    public final int getLineCount() {
        return this.lineCount.get();
    }

    private MutableActivityRepository<A> getMutableRepository() {
        ActivityRepository<A> repository = this.getRepository();
        if (repository instanceof MutableActivityRepository) {
            return (MutableActivityRepository)repository;
        }
        throw new RepositoryException(MessageFormat.format("the repository used by the row with the name {0} is immutable and of type {1}, activities can not be added or removed to the row / repository", this.getName(), repository.getClass().getName()));
    }

    public final void addActivity(Layer layer, A activity) {
        this.getMutableRepository().addActivity(new ActivityRef<A>(this, layer, activity));
    }

    public final void removeActivity(Layer layer, A activity) {
        this.getMutableRepository().removeActivity(new ActivityRef<A>(this, layer, activity));
    }

    public final void clearActivities() {
        this.getMutableRepository().clearActivities();
    }

    public final void clearActivities(Layer layer) {
        this.getMutableRepository().clearActivities(layer);
    }

    public final int getLineIndex(A activity) {
        return this.getLinesManager().getLineIndex(activity);
    }

    public final double getLineLocation(int lineIndex) {
        return this.getLinesManager().getLineLocation(lineIndex, this.getHeight());
    }

    public final double getLineHeight(int lineIndex) {
        return this.getLinesManager().getLineHeight(lineIndex, this.getHeight());
    }

    public final Layout getLineLayout(int lineIndex) {
        return this.getLinesManager().getLineLayout(lineIndex);
    }

    public String toString() {
        return this.getName();
    }
}

