/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model;

import com.flexganttfx.model.Activity;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Row;
import java.util.Objects;

public final class ActivityRef<A extends Activity> {
    private Row<?, ?, A> row;
    private A activity;
    private Layer layer;

    public ActivityRef(Row<?, ?, A> row, Layer layer, A activity) {
        Objects.requireNonNull(activity);
        this.row = row;
        this.layer = layer;
        this.activity = activity;
    }

    public boolean isPathExpanded() {
        return this.isPathExpanded(this.row);
    }

    private boolean isPathExpanded(Row<?, ?, ?> row) {
        Object parent = row.getParent();
        return parent == null || ((Row)parent).isExpanded() && this.isPathExpanded((Row<?, ?, ?>)parent);
    }

    public Row<?, ?, A> getRow() {
        return this.row;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public A getActivity() {
        return this.activity;
    }

    public int getLineIndex() {
        return this.row.getLineIndex(this.activity);
    }

    public void detachFromRow() {
        this.row.removeActivity(this.layer, this.activity);
    }

    public void attachToRow() {
        this.row.addActivity(this.layer, this.activity);
    }

    public String toString() {
        return "ActivityRef [row=" + this.row + ", activity=" + this.activity + ", layer=" + this.layer + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activity == null ? 0 : this.activity.hashCode());
        result = 31 * result + (this.layer == null ? 0 : this.layer.hashCode());
        result = 31 * result + (this.row == null ? 0 : this.row.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActivityRef other = (ActivityRef)obj;
        if (this.activity == null ? other.activity != null : !this.activity.equals(other.activity)) {
            return false;
        }
        if (this.layer == null ? other.layer != null : !this.layer.equals(other.layer)) {
            return false;
        }
        if (this.row == null) {
            return other.row == null;
        }
        return this.row.equals(other.row);
    }
}

