/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model;

import com.flexganttfx.model.Activity;
import com.flexganttfx.model.ActivityRef;
import java.util.Objects;

public class ActivityLink<A extends Activity> {
    private ActivityRef<A> sourceActivityRef;
    private ActivityRef<A> targetActivityRef;
    private LinkType type;

    public ActivityLink(ActivityRef<A> sourceRef, ActivityRef<A> targetRef, LinkType type) {
        Objects.requireNonNull(sourceRef);
        Objects.requireNonNull(targetRef);
        Objects.requireNonNull(type);
        this.sourceActivityRef = sourceRef;
        this.targetActivityRef = targetRef;
        this.type = type;
    }

    public ActivityLink(ActivityRef<A> sourceRef, ActivityRef<A> targetRef) {
        this(sourceRef, targetRef, LinkType.END_TO_START);
    }

    public void setSourceActivityRef(ActivityRef<A> ref) {
        Objects.requireNonNull(ref);
        this.sourceActivityRef = ref;
    }

    public final ActivityRef<A> getSourceActivityRef() {
        return this.sourceActivityRef;
    }

    public void setTargetActivityRef(ActivityRef<A> ref) {
        Objects.requireNonNull(ref);
        this.targetActivityRef = ref;
    }

    public final ActivityRef<A> getTargetActivityRef() {
        return this.targetActivityRef;
    }

    public final LinkType getType() {
        return this.type;
    }

    public void setType(LinkType type) {
        Objects.requireNonNull(type);
        this.type = type;
    }

    public static enum LinkType {
        END_TO_START,
        START_TO_END,
        START_TO_START,
        END_TO_END;

    }
}

