/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.extras;

import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.util.FlexGanttFXControl;
import impl.com.flexganttfx.extras.skin.RadarViewSkin;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Skin;

public class RadarView<R extends Row<?, ?, ?>>
extends FlexGanttFXControl {
    private final ObjectProperty<GraphicsBase<R>> graphics = new SimpleObjectProperty((Object)this, "graphics");
    private final DoubleProperty radarWidth = new SimpleDoubleProperty((Object)this, "width", 300.0);
    private final DoubleProperty radarHeight = new SimpleDoubleProperty((Object)this, "height", 200.0);

    public RadarView() {
        this.getStylesheets().add((Object)RadarView.class.getResource("radar-view.css").toExternalForm());
    }

    protected Skin<?> createDefaultSkin() {
        return new RadarViewSkin(this);
    }

    public final ObjectProperty<GraphicsBase<R>> graphicsProperty() {
        return this.graphics;
    }

    public final GraphicsBase<R> getGraphics() {
        return (GraphicsBase)((Object)this.graphics.get());
    }

    public final void setGraphics(GraphicsBase<R> graphics) {
        this.graphicsProperty().set(graphics);
    }

    public final DoubleProperty radarWidthProperty() {
        return this.radarWidth;
    }

    public final double getRadarWidth() {
        return this.radarWidth.get();
    }

    public final void setRadarWidth(double width) {
        if (width <= 0.0) {
            throw new IllegalArgumentException("width must be larger than 0 but was " + width);
        }
        this.radarWidth.set(width);
    }

    public final DoubleProperty radarHeightProperty() {
        return this.radarHeight;
    }

    public final double getRadarHeight() {
        return this.radarHeight.get();
    }

    public final void setRadarHeight(double height) {
        if (height <= 0.0) {
            throw new IllegalArgumentException("height must be larger than 0 but was " + height);
        }
        this.radarHeight.set(height);
    }
}

