/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.experimental;

import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public class PopOverHeader<T extends Node>
extends GridPane {
    private TextField titleField = new TextField();
    private TextField subtitleField = new TextField();
    private final StringProperty title = new SimpleStringProperty((Object)this, "title");
    private final StringProperty subtitle = new SimpleStringProperty((Object)this, "subtitle");
    private final ObjectProperty<T> extra = new SimpleObjectProperty((Object)this, "extra");

    public PopOverHeader() {
        this.add((Node)this.titleField, 0, 0);
        this.add((Node)this.subtitleField, 0, 1);
        this.getStyleClass().add((Object)"header");
        this.titleField.getStyleClass().add((Object)"title");
        this.titleField.setEditable(true);
        this.titleField.setPromptText("Title");
        this.titleField.setMaxWidth(500.0);
        this.subtitleField.getStyleClass().add((Object)"subtitle");
        this.subtitleField.setEditable(true);
        this.subtitleField.setPromptText("Subtitle");
        this.subtitleField.setMaxWidth(500.0);
        Bindings.bindBidirectional((Property)this.titleField.textProperty(), (Property)this.titleProperty());
        Bindings.bindBidirectional((Property)this.subtitleField.textProperty(), (Property)this.subtitleProperty());
        if (this.getExtra() != null) {
            this.add(this.getExtra(), 1, 0, 1, 2);
            GridPane.setValignment((Node)this.getExtra(), (VPos)VPos.TOP);
        }
        GridPane.setValignment((Node)this.titleField, (VPos)VPos.TOP);
        GridPane.setValignment((Node)this.subtitleField, (VPos)VPos.TOP);
        GridPane.setHgrow((Node)this.titleField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.subtitleField, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)this.titleField, (Boolean)true);
        GridPane.setFillWidth((Node)this.subtitleField, (Boolean)true);
        this.extraProperty().addListener((value, oldNode, newNode) -> {
            if (oldNode != null) {
                this.getChildren().remove(oldNode);
            }
            if (newNode != null) {
                this.add((Node)newNode, 1, 0, 1, 2);
                GridPane.setValignment((Node)this.getExtra(), (VPos)VPos.TOP);
            }
            if (newNode != null) {
                String style = "header-extra";
                if (!newNode.getStyleClass().contains((Object)style)) {
                    newNode.getStyleClass().add((Object)style);
                }
            }
        });
        ColorPicker picker = new ColorPicker();
        this.setExtra(picker);
    }

    public final TextField getTitleField() {
        return this.titleField;
    }

    public final TextField getSubtitleField() {
        return this.subtitleField;
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final void setTitle(String title) {
        this.titleProperty().set((Object)title);
    }

    public final String getTitle() {
        return (String)this.titleProperty().get();
    }

    public final StringProperty subtitleProperty() {
        return this.subtitle;
    }

    public final void setSubtitle(String subtitle) {
        this.subtitleProperty().set((Object)subtitle);
    }

    public final String getSubtitle() {
        return (String)this.subtitleProperty().get();
    }

    public final ObjectProperty<T> extraProperty() {
        return this.extra;
    }

    public final void setExtra(T extra) {
        this.extraProperty().set(extra);
    }

    public final Node getExtra() {
        return (Node)this.extraProperty().get();
    }
}

