/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.experimental;

import com.flexganttfx.experimental.PopOverHeader;
import impl.org.controlsfx.skin.PopOverSkin;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import org.controlsfx.control.PopOver;

public class AccordionPopOver
extends PopOver {
    private Accordion accordion;
    private final ObjectProperty<Node> header = new SimpleObjectProperty((Object)this, "header");
    private final ObjectProperty<Node> footer = new SimpleObjectProperty((Object)this, "footer");
    private final ObservableList<TitledPane> panes = FXCollections.observableArrayList();
    private final ObjectProperty<TitledPane> expandedPane = new SimpleObjectProperty((Object)this, "expandedPane");

    public AccordionPopOver() {
        this.skinProperty().addListener((value, oldSkin, newSkin) -> {
            PopOverSkin skin = (PopOverSkin)newSkin;
            StackPane stackPane = (StackPane)skin.getNode();
            stackPane.getStylesheets().add((Object)AccordionPopOver.class.getResource("accordion-popover.css").toExternalForm());
        });
        BorderPane borderPane = new BorderPane();
        this.headerProperty().addListener((value, oldNode, newNode) -> borderPane.setTop(newNode));
        this.accordion = new Accordion();
        borderPane.setCenter((Node)this.accordion);
        Bindings.bindContentBidirectional(this.getPanes(), (ObservableList)this.accordion.getPanes());
        Bindings.bindBidirectional(this.expandedPaneProperty(), (Property)this.accordion.expandedPaneProperty());
        this.setHeader((Node)new PopOverHeader());
        this.footerProperty().addListener((value, oldNode, newNode) -> {
            borderPane.setBottom(newNode);
            if (newNode != null) {
                String style = "footer";
                if (!newNode.getStyleClass().contains((Object)style)) {
                    newNode.getStyleClass().add((Object)style);
                }
            }
        });
        this.setContentNode((Node)borderPane);
    }

    public final ObjectProperty<Node> headerProperty() {
        return this.header;
    }

    public final Node getHeader() {
        return (Node)this.headerProperty().get();
    }

    public final void setHeader(Node node) {
        this.headerProperty().set((Object)node);
    }

    public final ObjectProperty<Node> footerProperty() {
        return this.footer;
    }

    public final Node getFooter() {
        return (Node)this.footerProperty().get();
    }

    public final void setFooter(Node node) {
        this.footerProperty().set((Object)node);
    }

    public final ObservableList<TitledPane> getPanes() {
        return this.panes;
    }

    public final ObjectProperty<TitledPane> expandedPaneProperty() {
        return this.expandedPane;
    }

    public final void setExpandedPane(TitledPane titledPane) {
        this.expandedPaneProperty().set((Object)titledPane);
    }

    public final TitledPane getExpanedPane() {
        return (TitledPane)this.expandedPane.get();
    }
}

