/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.timeline;

import com.flexganttfx.model.timeline.TimelineModel;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.time.Duration;
import java.time.Instant;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.geometry.Insets;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;

public class TimelineModelControlPanel
extends VBox {
    public TimelineModelControlPanel(TimelineModel<?> timelineModel, Instant startTime, Instant endTime) {
        this.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.setFillWidth(true);
        this.setSpacing(10.0);
        Format format = new Format(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object parseObject(String source, ParsePosition pos) {
                Double value = Double.parseDouble(source);
                pos.setIndex(source.length() - 1);
                return value;
            }

            @Override
            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                return toAppendTo.append(obj);
            }
        };
        this.getChildren().add((Object)new Label("Millis Per Pixel"));
        TextField temporalUnitWidthField = new TextField();
        Bindings.bindBidirectional((Property)temporalUnitWidthField.textProperty(), (Property)timelineModel.millisPerPixelProperty(), (Format)format);
        this.getChildren().add((Object)temporalUnitWidthField);
        Slider unitWidthSlider = new Slider(1000.0, 3.456E8, 8.64E7);
        Bindings.bindBidirectional((Property)unitWidthSlider.valueProperty(), (Property)timelineModel.millisPerPixelProperty());
        Bindings.bindBidirectional((Property)temporalUnitWidthField.textProperty(), (Property)unitWidthSlider.valueProperty(), (Format)format);
        this.getChildren().add((Object)unitWidthSlider);
        this.getChildren().add((Object)new Label("Start Time"));
        if (startTime == null) {
            startTime = Instant.now();
            endTime = startTime.plus(Duration.ofDays(100L));
            timelineModel.setStartTime(startTime);
        }
        Slider slider = new Slider((double)startTime.toEpochMilli(), (double)endTime.toEpochMilli(), 0.0);
        slider.valueProperty().addListener((value, oldNumber, newNumber) -> {
            Instant time = Instant.ofEpochMilli(newNumber.longValue());
            timelineModel.setStartTime(time);
        });
        this.getChildren().add((Object)slider);
        timelineModel.startTimeProperty().addListener((value, oldTime, newTime) -> slider.setValue((double)newTime.toEpochMilli()));
    }
}

