/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.timeline;

import com.flexganttfx.demo.FlexGanttFXSampleBase;
import com.flexganttfx.demo.timeline.TimelineControlPanel;
import com.flexganttfx.model.dateline.SimpleUnitDatelineModel;
import com.flexganttfx.model.timeline.SimpleUnitTimelineModel;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.timeline.Timeline;
import java.time.Instant;
import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import org.controlsfx.control.PropertySheet;

public class HelloSimpleUnitTimeline
extends FlexGanttFXSampleBase {
    private Timeline timeline;

    @Override
    public Node getPanel(Stage stage) {
        GridPane gridPane = new GridPane();
        ColumnConstraints cc = new ColumnConstraints();
        cc.setPercentWidth(100.0);
        RowConstraints rc = new RowConstraints();
        rc.setPercentHeight(100.0);
        gridPane.getColumnConstraints().add((Object)cc);
        gridPane.getRowConstraints().add((Object)rc);
        this.timeline = new Timeline();
        this.timeline.getEventline().setVisible(false);
        this.timeline.getModel().setNow(Instant.ofEpochMilli(0L));
        this.timeline.setModel(new SimpleUnitTimelineModel());
        this.timeline.getDateline().setModel(new SimpleUnitDatelineModel());
        StackPane stackPane = new StackPane();
        stackPane.setPadding(new Insets(20.0));
        stackPane.getChildren().add((Object)this.timeline);
        stackPane.setStyle("-fx-background-color: white; -fx-border-color: lightgray;");
        GridPane.setFillWidth((Node)stackPane, (Boolean)true);
        GridPane.setFillHeight((Node)stackPane, (Boolean)false);
        GridPane.setMargin((Node)stackPane, (Insets)new Insets(20.0));
        GridPane.setValignment((Node)stackPane, (VPos)VPos.CENTER);
        GridPane.setHgrow((Node)stackPane, (Priority)Priority.ALWAYS);
        gridPane.add((Node)stackPane, 0, 0);
        return gridPane;
    }

    @Override
    public Node getControlPanel() {
        BorderPane pane = new BorderPane();
        pane.setBottom((Node)new TimelineControlPanel(this.timeline));
        pane.setCenter((Node)new PropertySheet((ObservableList<PropertySheet.Item>)FXCollections.observableArrayList(this.timeline.getPropertySheetItems())));
        return pane;
    }

    @Override
    public String getSampleName() {
        return "Simple Unit";
    }

    @Override
    public String getControlStylesheetURL() {
        return "/" + Dateline.class.getPackage().getName().replace('.', '/') + "/dateline.css";
    }

    @Override
    public String getJavaDocURL() {
        return this.getJavaDocBase() + "com/flexganttfx/view/timeline/Timeline.html";
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

