/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.model;

import com.flexganttfx.demo.FlexGanttFXSample;
import com.flexganttfx.demo.HelloActivity;
import com.flexganttfx.model.ActivityLink;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.layout.GanttLayout;
import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.renderer.ActivityBarRenderer;
import java.time.Instant;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.util.Callback;

public class HelloLinks
extends FlexGanttFXSample {
    private static final long ONE_DAY = 86400000L;
    private HelloRow root = new HelloRow("Initial Root");
    private GanttChart<HelloRow> gantt;
    private Layer layer;
    private ActivityLink<HelloActivity> link;

    public HelloLinks() {
        this.root.setExpanded(true);
    }

    protected GanttChart<?> createGanttChart() throws Exception {
        this.gantt = new GanttChart<HelloRow>(this.root);
        ActivityBarRenderer renderer = new ActivityBarRenderer(this.gantt.getGraphics(), "My Renderer");
        renderer.setCornersRounded(false);
        this.gantt.getGraphics().setActivityRenderer(HelloActivity.class, GanttLayout.class, renderer);
        this.gantt.getGraphics().setActivityEditingCallback(HelloActivity.class, (Callback<GraphicsBase.EditingCallbackParameter, Boolean>)((Callback)param -> true));
        this.gantt.getGraphics().setRowDragAndDropCallback(HelloRow.class, (Callback<GraphicsBase.DragAndDropInfo, Boolean>)((Callback)param -> true));
        this.layer = new Layer("Default");
        this.gantt.getLayers().add((Object)this.layer);
        this.createActivities();
        return this.gantt;
    }

    private void createActivities() {
        HelloRow row1 = new HelloRow("Adjacent Activities");
        HelloActivity activity11 = new HelloActivity("Activity 11");
        HelloActivity activity12 = new HelloActivity("Activity 12");
        activity11.setStartTime(Instant.now().plusMillis(86400000L));
        activity11.setEndTime(Instant.now().plusMillis(432000000L));
        activity12.setStartTime(Instant.now().plusMillis(604800000L));
        activity12.setEndTime(Instant.now().plusMillis(1123200000L));
        row1.addActivity(this.layer, activity11);
        row1.addActivity(this.layer, activity12);
        ActivityRef<HelloActivity> ref11 = new ActivityRef<HelloActivity>(row1, this.layer, activity11);
        ActivityRef<HelloActivity> ref12 = new ActivityRef<HelloActivity>(row1, this.layer, activity12);
        this.link = new ActivityLink<HelloActivity>(ref11, ref12);
        this.gantt.getGraphics().getLinks().add(this.link);
        this.root.getChildren().add((Object)row1);
        HelloRow row2 = new HelloRow("Row 2");
        this.root.getChildren().add((Object)row2);
        HelloRow row3 = new HelloRow("Row 3");
        this.root.getChildren().add((Object)row3);
    }

    @Override
    public Node getControlPanel() {
        ComboBox box = new ComboBox();
        box.getItems().addAll((Object[])ActivityLink.LinkType.values());
        box.setValue((Object)ActivityLink.LinkType.END_TO_START);
        box.valueProperty().addListener(it -> {
            this.link.setType((ActivityLink.LinkType)((Object)((Object)box.getValue())));
            this.gantt.getGraphics().redraw();
        });
        return box;
    }

    @Override
    public String getSampleName() {
        return "Links";
    }

    @Override
    public String getSampleDescription() {
        return "A sample to test the four different link types (E->S, S->E, E->E, S->S)";
    }

    @Override
    public String getJavaDocURL() {
        return super.getJavaDocBase() + "com/flexganttfx/model/ActivityLink.html";
    }

    public static void main(String[] args) {
        HelloLinks.launch((String[])args);
    }

    class HelloRow
    extends Row<HelloRow, HelloRow, HelloActivity> {
        public HelloRow(String name) {
            super(name);
        }
    }
}

