/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.model;

import com.flexganttfx.demo.FlexGanttFXSample;
import com.flexganttfx.demo.HelloActivity;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.repository.MutableActivityRepositoryBase;
import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.timeline.DatelineScrollingEvent;
import java.io.FileNotFoundException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.application.Application;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.VBox;

public class HelloLazyLoading
extends FlexGanttFXSample {
    private static final Layer layer = new Layer("Default Layer");
    private static GanttChart<HelloLazyRow> gantt;
    private int rowCounter = 0;

    protected GanttChart<?> createGanttChart() throws FileNotFoundException {
        gantt = new GanttChart();
        gantt.setRowHeaderType(GanttChart.RowHeaderType.LEVEL_NUMBER);
        gantt.getRowHeader().setPrefWidth(60.0);
        gantt.getLayers().add((Object)layer);
        HelloLazyRow root = new HelloLazyRow("Root");
        gantt.setRoot(root);
        gantt.getTreeTable().setShowRoot(false);
        gantt.getTimeline().getDateline().setOnVisibleRangeChanged((EventHandler<DatelineScrollingEvent>)((EventHandler)evt -> LazyLoadingManager.getInstance().ensureData(evt.getStartTime(), evt.getEndTime(), false)));
        gantt.getTreeTable().rootProperty().addListener(it -> gantt.getTreeTable().getRoot().addEventHandler(TreeItem.branchExpandedEvent(), evt -> {
            Instant st = gantt.getTimeline().getVisibleStartTime();
            Instant et = gantt.getTimeline().getVisibleEndTime();
            LazyLoadingManager.getInstance().ensureData(st, et, true);
        }));
        return gantt;
    }

    @Override
    public Node getControlPanel() {
        VBox box = new VBox();
        box.setSpacing(10.0);
        box.setFillWidth(true);
        Button showRoot = new Button("Show Root");
        showRoot.setMaxWidth(Double.MAX_VALUE);
        showRoot.setOnAction(event -> gantt.getTreeTable().setShowRoot(!gantt.getTreeTable().isShowRoot()));
        Button addSingleRow = new Button("Add Single Row");
        addSingleRow.setMaxWidth(Double.MAX_VALUE);
        addSingleRow.setOnAction(event -> this.addSingleRow());
        addSingleRow.disableProperty().bind((ObservableValue)Bindings.isNull((ObservableObjectValue)gantt.getTreeTable().getSelectionModel().selectedItemProperty()));
        Button addRows = new Button("Add Rows");
        addRows.setMaxWidth(Double.MAX_VALUE);
        addRows.setOnAction(event -> this.addRows());
        addRows.disableProperty().bind((ObservableValue)Bindings.isNull((ObservableObjectValue)gantt.getTreeTable().getSelectionModel().selectedItemProperty()));
        Button setRows = new Button("Set Rows");
        setRows.setMaxWidth(Double.MAX_VALUE);
        setRows.setOnAction(event -> this.setRows());
        setRows.disableProperty().bind((ObservableValue)Bindings.isNull((ObservableObjectValue)gantt.getTreeTable().getSelectionModel().selectedItemProperty()));
        Button clearRows = new Button("Clear Rows");
        clearRows.setMaxWidth(Double.MAX_VALUE);
        clearRows.setOnAction(event -> this.clearRows());
        clearRows.disableProperty().bind((ObservableValue)Bindings.isNull((ObservableObjectValue)gantt.getTreeTable().getSelectionModel().selectedItemProperty()));
        Button removeRows = new Button("Remove Selected Rows");
        removeRows.setMaxWidth(Double.MAX_VALUE);
        removeRows.setOnAction(event -> this.removeRows());
        removeRows.disableProperty().bind((ObservableValue)Bindings.isNull((ObservableObjectValue)gantt.getTreeTable().getSelectionModel().selectedItemProperty()));
        box.getChildren().addAll((Object[])new Node[]{showRoot, addSingleRow, addRows, setRows, removeRows, clearRows});
        return box;
    }

    private HelloLazyRow getSelectedRow() {
        TreeItem selectedItem = (TreeItem)gantt.getTreeTable().getSelectionModel().getSelectedItem();
        if (selectedItem != null) {
            return (HelloLazyRow)selectedItem.getValue();
        }
        return gantt.getRoot();
    }

    private void clearRows() {
        gantt.getRoot().getChildren().clear();
    }

    private void removeRows() {
        ObservableList selectedItems = gantt.getTreeTable().getSelectionModel().getSelectedItems();
        ArrayList arrayList = new ArrayList(selectedItems);
        gantt.getTreeTable().getSelectionModel().clearSelection();
        for (TreeItem item : arrayList) {
            HelloLazyRow value = (HelloLazyRow)item.getValue();
            ((HelloLazyRow)value.getParent()).getChildren().remove((Object)value);
        }
    }

    private void addRows() {
        ArrayList<HelloLazyRow> rows = new ArrayList<HelloLazyRow>();
        for (int i = 0; i < 100; ++i) {
            rows.add(new HelloLazyRow("Added Row " + this.rowCounter++));
        }
        this.getSelectedRow().getChildren().addAll(rows);
    }

    private void setRows() {
        ArrayList<HelloLazyRow> rows = new ArrayList<HelloLazyRow>();
        for (int i = 0; i < 10; ++i) {
            rows.add(new HelloLazyRow("Set Row " + this.rowCounter++));
        }
        this.getSelectedRow().getChildren().setAll(rows);
    }

    private void addSingleRow() {
        HelloLazyRow row = new HelloLazyRow("Added Row " + this.rowCounter++);
        this.getSelectedRow().getChildren().add((Object)row);
    }

    @Override
    public String getSampleName() {
        return "Lazy Loading";
    }

    @Override
    public String getSampleDescription() {
        return "This sample shows how a lazy loading strategy can be implemented. The children items in the tree view on the left-hand side are added when the user expands a tree node (vertical lazy loading).The activities on the right-hand side are generated when the user scrolls horizontally (horizontal lazy loading).";
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    static class HelloLazyRow
    extends Row<HelloLazyRow, HelloLazyRow, HelloLazyLoadingActivity> {
        public HelloLazyRow(String name) {
            super(name);
            this.expandedProperty().addListener(it -> this.loadChildrenLazily());
        }

        @Override
        public boolean isLeaf() {
            return this.getPath().length > 3;
        }

        private void loadChildrenLazily() {
            for (int i = 0; i < 3 + (int)(Math.random() * 10.0); ++i) {
                this.getChildren().add((Object)new HelloLazyRow("Child " + (i + 1)));
            }
        }
    }

    static class HelloLazyLoadingActivity
    extends HelloActivity {
        private HelloLazyRow row;

        public HelloLazyLoadingActivity(HelloLazyRow row) {
            this.row = Objects.requireNonNull(row);
        }

        public HelloLazyRow getRow() {
            return this.row;
        }
    }

    static class LazyLoadingTask
    extends Task<List<HelloLazyLoadingActivity>> {
        private Instant startTime;
        private Instant endTime;

        public LazyLoadingTask(Instant startTime, Instant endTime) {
            this.startTime = Objects.requireNonNull(startTime);
            this.endTime = Objects.requireNonNull(endTime);
        }

        protected List<HelloLazyLoadingActivity> call() throws Exception {
            Thread.sleep(100L);
            if (!this.isCancelled()) {
                ArrayList<HelloLazyLoadingActivity> activities = new ArrayList<HelloLazyLoadingActivity>();
                for (HelloLazyRow row : gantt.getGraphics().getRows()) {
                    Instant time = this.startTime.truncatedTo(ChronoUnit.DAYS);
                    if (this.isCancelled()) break;
                    while (time.isBefore(this.endTime)) {
                        HelloLazyLoadingActivity activity = new HelloLazyLoadingActivity(row);
                        activity.setStartTime(time);
                        activity.setEndTime(time.plus(1L, ChronoUnit.DAYS));
                        activities.add(activity);
                        time = time.plus(2L, ChronoUnit.DAYS);
                    }
                }
                return activities;
            }
            return null;
        }
    }

    static class LazyLoadingService
    extends Service<List<HelloLazyLoadingActivity>> {
        private Instant startTime;
        private Instant endTime;

        LazyLoadingService() {
        }

        protected Task<List<HelloLazyLoadingActivity>> createTask() {
            return new LazyLoadingTask(this.startTime, this.endTime);
        }

        public void setStartTime(Instant startTime) {
            this.startTime = Objects.requireNonNull(startTime);
        }

        public void setEndTime(Instant endTime) {
            this.endTime = Objects.requireNonNull(endTime);
        }
    }

    static class LazyLoadingManager {
        private static LazyLoadingManager instance;
        private LazyLoadingService service = new LazyLoadingService();
        private Instant lastStartTime;
        private Instant lastEndTime;

        private LazyLoadingManager() {
            this.service.setOnSucceeded(evt -> this.afterSuccess((WorkerStateEvent)evt));
        }

        public void ensureData(Instant startTime, Instant endTime, boolean force) {
            if (!force && startTime.equals(this.lastStartTime) && endTime.equals(this.lastEndTime)) {
                return;
            }
            this.lastStartTime = startTime;
            this.lastEndTime = endTime;
            this.service.setStartTime(startTime);
            this.service.setEndTime(endTime);
            this.service.restart();
        }

        private void afterSuccess(WorkerStateEvent evt) {
            HelloLazyRow row;
            List activities = (List)this.service.getValue();
            for (HelloLazyLoadingActivity activity : activities) {
                row = activity.getRow();
                MutableActivityRepositoryBase repository = (MutableActivityRepositoryBase)row.getRepository();
                repository.clearActivities();
            }
            for (HelloLazyLoadingActivity activity : activities) {
                row = activity.getRow();
                row.addActivity(layer, activity);
            }
        }

        public static synchronized LazyLoadingManager getInstance() {
            if (instance == null) {
                instance = new LazyLoadingManager();
            }
            return instance;
        }
    }
}

