/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.model;

import com.flexganttfx.demo.FlexGanttFXSample;
import com.flexganttfx.demo.HelloActivity;
import com.flexganttfx.model.Activity;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.GanttChart;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.VBox;

public class HelloGanttChartModel
extends FlexGanttFXSample {
    private HelloRow root;
    private int rootCounter;
    private int layerCounter;
    private GanttChart<HelloRow> gantt;
    private Layer layer = new Layer("Default");
    private int rowCounter = 0;

    public HelloGanttChartModel() {
        this.root = new HelloRow("Initial Root");
        this.root.setExpanded(true);
    }

    protected GanttChart<?> createGanttChart() throws Exception {
        this.gantt = new GanttChart<HelloRow>(this.root);
        this.gantt.getLayers().add((Object)this.layer);
        this.gantt.getTreeTable().getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        return this.gantt;
    }

    @Override
    public Node getControlPanel() {
        VBox box = new VBox();
        box.setSpacing(10.0);
        box.setFillWidth(true);
        Button newModel = new Button("Set New Root");
        newModel.setOnAction(event -> this.setNewRoot());
        newModel.setMaxWidth(Double.MAX_VALUE);
        Button addLayer = new Button("Add New Layer");
        addLayer.setOnAction(event -> this.addLayer());
        addLayer.setMaxWidth(Double.MAX_VALUE);
        ToggleButton showRoot = new ToggleButton("Show Root");
        showRoot.setMaxWidth(Double.MAX_VALUE);
        Bindings.bindBidirectional((Property)showRoot.selectedProperty(), (Property)this.gantt.getTreeTable().showRootProperty());
        Button addSingleRow = new Button("Add Single Row");
        addSingleRow.setOnAction(event -> this.addSingleRow());
        addSingleRow.setMaxWidth(Double.MAX_VALUE);
        Button addRows = new Button("Add Rows");
        addRows.setOnAction(event -> this.addRows());
        addRows.setMaxWidth(Double.MAX_VALUE);
        Button setRows = new Button("Set Rows");
        setRows.setOnAction(event -> this.setRows());
        setRows.setMaxWidth(Double.MAX_VALUE);
        Button clearRows = new Button("Clear Rows");
        clearRows.setOnAction(event -> this.clearRows());
        clearRows.setMaxWidth(Double.MAX_VALUE);
        Button removeRows = new Button("Remove Selected Rows");
        removeRows.setOnAction(event -> this.removeRows());
        removeRows.setMaxWidth(Double.MAX_VALUE);
        Button removeFirstTen = new Button("Remove First 10 Rows");
        removeFirstTen.setOnAction(event -> this.removeFirstTen());
        removeFirstTen.setMaxWidth(Double.MAX_VALUE);
        Button loadTest = new Button("Load Test 150K Rows");
        loadTest.setOnAction(event -> this.loadTest());
        loadTest.setMaxWidth(Double.MAX_VALUE);
        box.getChildren().addAll((Object[])new Node[]{newModel, addLayer, showRoot, addSingleRow, addRows, setRows, removeRows, removeFirstTen, clearRows, loadTest});
        return box;
    }

    @Override
    public String getSampleName() {
        return "Gantt Chart Model";
    }

    private void setNewRoot() {
        ++this.rootCounter;
        this.root = new HelloRow("Root #" + this.rootCounter);
        this.root.setExpanded(true);
        this.gantt.setRoot(this.root);
    }

    private void addLayer() {
        ++this.layerCounter;
        Layer layer = new Layer("Layer " + this.layerCounter);
        this.gantt.getLayers().add((Object)layer);
    }

    private void clearRows() {
        this.gantt.getRoot().getChildren().clear();
    }

    private void removeRows() {
        ArrayList<Object> rows = new ArrayList<Object>();
        for (TreeItem item : this.gantt.getTreeTable().getSelectionModel().getSelectedItems()) {
            rows.add(item.getValue());
        }
        this.gantt.getRoot().getChildren().removeAll(rows);
    }

    private void removeFirstTen() {
        int counter = 0;
        ArrayList<HelloRow> rows = new ArrayList<HelloRow>();
        for (HelloRow row : this.gantt.getRoot().getChildren()) {
            rows.add(row);
            if (++counter != 10) continue;
            break;
        }
        this.gantt.getRoot().getChildren().removeAll(rows);
    }

    private void addRows() {
        ArrayList<HelloRow> rows = new ArrayList<HelloRow>();
        for (int i = 0; i < 100; ++i) {
            rows.add(new HelloRow("Row " + this.rowCounter++));
        }
        this.gantt.getRoot().getChildren().addAll(rows);
    }

    private void setRows() {
        ArrayList<HelloRow> rows = new ArrayList<HelloRow>();
        for (int i = 0; i < 100; ++i) {
            rows.add(new HelloRow("Row " + this.rowCounter++));
        }
        this.gantt.getRoot().getChildren().setAll(rows);
    }

    private void addSingleRow() {
        HelloRow row = new HelloRow("Row " + this.rowCounter++);
        this.gantt.getRoot().getChildren().add((Object)row);
    }

    private void loadTest() {
        ArrayList<HelloRow> topLevelRows = new ArrayList<HelloRow>();
        for (int i = 0; i < 10000; ++i) {
            HelloRow topLevelRow = new HelloRow("Top level row " + i);
            topLevelRows.add(topLevelRow);
            HelloActivity activity = new HelloActivity();
            activity.setStartTime(ZonedDateTime.now().plusDays(3L).toInstant());
            activity.setEndTime(activity.getStartTime().plus(Duration.ofDays(7L)));
            topLevelRow.addActivity(this.layer, activity);
            for (int j = 0; j < 13; ++j) {
                HelloRow child = new HelloRow("child " + i + "/" + j);
                topLevelRow.getChildren().add((Object)child);
            }
        }
        long time = System.currentTimeMillis();
        this.gantt.getRoot().getChildren().setAll(topLevelRows);
    }

    @Override
    public String getJavaDocURL() {
        return super.getJavaDocBase() + "com/flexganttfx/model/package-summary.html";
    }

    @Override
    public String getSampleDescription() {
        return "A couple of model-related actions to verify the behaviour of the control related to model changes.";
    }

    public static void main(String[] args) {
        HelloGanttChartModel.launch((String[])args);
    }

    class HelloRow
    extends Row<HelloRow, HelloRow, Activity> {
        public HelloRow(String name) {
            super(name);
        }
    }
}

