/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.model;

import com.flexganttfx.demo.FlexGanttFXSample;
import com.flexganttfx.demo.HelloActivity;
import com.flexganttfx.model.Activity;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.GanttChartBase;
import com.flexganttfx.view.GanttChartLite;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;

public class HelloGanttChartLiteModel
extends FlexGanttFXSample {
    private HelloRow root;
    private int rootCounter;
    private int layerCounter;
    private GanttChartLite<HelloRow> gantt;
    private Layer layer = new Layer("Default");
    private int rowCounter = 0;

    public HelloGanttChartLiteModel() {
        this.root = new HelloRow("Initial Root");
        this.root.setExpanded(true);
    }

    @Override
    protected GanttChartBase<?> createGanttChart() throws Exception {
        this.gantt = new GanttChartLite();
        this.gantt.getLayers().add((Object)this.layer);
        return this.gantt;
    }

    @Override
    public Node getControlPanel() {
        VBox box = new VBox();
        box.setSpacing(10.0);
        box.setFillWidth(true);
        Button newModel = new Button("Set New List");
        newModel.setOnAction(event -> this.setNewList());
        newModel.setMaxWidth(Double.MAX_VALUE);
        Button addLayer = new Button("Add New Layer");
        addLayer.setOnAction(event -> this.addLayer());
        addLayer.setMaxWidth(Double.MAX_VALUE);
        Button addSingleRow = new Button("Add Single Row");
        addSingleRow.setOnAction(event -> this.addSingleRow());
        addSingleRow.setMaxWidth(Double.MAX_VALUE);
        Button addRows = new Button("Add Rows");
        addRows.setOnAction(event -> this.addRows());
        addRows.setMaxWidth(Double.MAX_VALUE);
        Button setRows = new Button("Set Rows");
        setRows.setOnAction(event -> this.setRows());
        setRows.setMaxWidth(Double.MAX_VALUE);
        Button clearRows = new Button("Clear Rows");
        clearRows.setOnAction(event -> this.clearRows());
        clearRows.setMaxWidth(Double.MAX_VALUE);
        Button removeFirstTen = new Button("Remove First 10 Rows");
        removeFirstTen.setOnAction(event -> this.removeFirstTen());
        removeFirstTen.setMaxWidth(Double.MAX_VALUE);
        Button loadTest = new Button("Load Test 150K Rows");
        loadTest.setOnAction(event -> this.loadTest());
        loadTest.setMaxWidth(Double.MAX_VALUE);
        box.getChildren().addAll((Object[])new Node[]{newModel, addLayer, addSingleRow, addRows, setRows, removeFirstTen, clearRows, loadTest});
        return box;
    }

    @Override
    public String getSampleName() {
        return "Gantt Chart Model Lite";
    }

    private void addLayer() {
        ++this.layerCounter;
        Layer layer = new Layer("Layer " + this.layerCounter);
        this.gantt.getLayers().add((Object)layer);
    }

    private void clearRows() {
        this.gantt.getRows().clear();
    }

    private void setNewList() {
        this.gantt.setRows((ObservableList<HelloRow>)FXCollections.observableArrayList());
    }

    private void removeFirstTen() {
        int counter = 0;
        ArrayList<HelloRow> rows = new ArrayList<HelloRow>();
        for (HelloRow row : this.gantt.getRows()) {
            rows.add(row);
            if (++counter != 10) continue;
            break;
        }
        this.gantt.getRows().removeAll(rows);
    }

    private void addRows() {
        ArrayList<HelloRow> rows = new ArrayList<HelloRow>();
        for (int i = 0; i < 100; ++i) {
            rows.add(new HelloRow("Row " + this.rowCounter++));
        }
        this.gantt.getRows().addAll(rows);
    }

    private void setRows() {
        ArrayList<HelloRow> rows = new ArrayList<HelloRow>();
        for (int i = 0; i < 100; ++i) {
            rows.add(new HelloRow("Row " + this.rowCounter++));
        }
        this.gantt.getRows().setAll(rows);
    }

    private void addSingleRow() {
        HelloRow row = new HelloRow("Row " + this.rowCounter++);
        this.gantt.getRows().add((Object)row);
    }

    private void loadTest() {
        ArrayList<HelloRow> topLevelRows = new ArrayList<HelloRow>();
        for (int i = 0; i < 10000; ++i) {
            HelloRow topLevelRow = new HelloRow("Top level row " + i);
            topLevelRows.add(topLevelRow);
            HelloActivity activity = new HelloActivity();
            activity.setStartTime(ZonedDateTime.now().plusDays(3L).toInstant());
            activity.setEndTime(activity.getStartTime().plus(Duration.ofDays(7L)));
            topLevelRow.addActivity(this.layer, activity);
            for (int j = 0; j < 13; ++j) {
                HelloRow child = new HelloRow("child " + i + "/" + j);
                topLevelRow.getChildren().add((Object)child);
            }
        }
        long time = System.currentTimeMillis();
        this.gantt.getRows().setAll(topLevelRows);
    }

    @Override
    public String getJavaDocURL() {
        return super.getJavaDocBase() + "com/flexganttfx/model/package-summary.html";
    }

    @Override
    public String getSampleDescription() {
        return "A couple of model-related actions to verify the behaviour of the control related to model changes.";
    }

    public static void main(String[] args) {
        HelloGanttChartLiteModel.launch((String[])args);
    }

    class HelloRow
    extends Row<HelloRow, HelloRow, Activity> {
        public HelloRow(String name) {
            super(name);
        }
    }
}

