/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.layout;

import com.flexganttfx.demo.FlexGanttFXSample;
import com.flexganttfx.model.Activity;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Layout;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.activity.ChartActivity;
import com.flexganttfx.model.activity.MutableActivityBase;
import com.flexganttfx.model.activity.MutableChartActivityBase;
import com.flexganttfx.model.exception.IllegalLineIndexException;
import com.flexganttfx.model.layout.AgendaLayout;
import com.flexganttfx.model.layout.ChartLayout;
import com.flexganttfx.model.layout.GanttLayout;
import com.flexganttfx.model.layout.LinesManagerBase;
import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.renderer.ActivityBarRenderer;
import com.flexganttfx.view.graphics.renderer.ActivityRenderer;
import com.flexganttfx.view.timeline.Timeline;
import com.flexganttfx.view.util.Position;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;

public class HelloMixedLayouts
extends FlexGanttFXSample {
    private static final long MAX_DAYS = 700L;
    private Instant startTime;
    private Instant endTime;
    private GanttChart<CapacityRow> ganttChart;

    @Override
    public String getSampleName() {
        return "Mixed";
    }

    @Override
    public Node getControlPanel() {
        ComboBox box = new ComboBox();
        box.getItems().addAll((Object[])FilterMode.values());
        box.setValue((Object)FilterMode.NONE);
        box.valueProperty().addListener(it -> {
            switch ((FilterMode)((Object)((Object)box.getValue()))) {
                case NONE: {
                    this.ganttChart.getGraphics().setActivityFilter(activity -> true);
                    break;
                }
                case GANTT: {
                    this.ganttChart.getGraphics().setActivityFilter(activity -> activity instanceof CapacityIndicator);
                    break;
                }
                case CAPACITY: {
                    this.ganttChart.getGraphics().setActivityFilter(activity -> activity instanceof ChartActivity);
                    break;
                }
                case AGENDA: {
                    this.ganttChart.getGraphics().setActivityFilter(activity -> activity instanceof AgendaEntry);
                }
            }
        });
        HBox hbox = new HBox(5.0);
        Label label = new Label("Filter");
        hbox.getChildren().addAll((Object[])new Node[]{label, box});
        return hbox;
    }

    protected GanttChart<?> createGanttChart() {
        this.ganttChart = new GanttChart<CapacityRow>(new CapacityRow(true));
        this.ganttChart.getGraphics().setActivityRenderer(CapacityIndicator.class, GanttLayout.class, new CapacityIndicatorRenderer(this.ganttChart.getGraphics()));
        this.ganttChart.getTimeline().setZoomMode(Timeline.ZoomMode.KEEP_START_TIME);
        this.ganttChart.getGraphics().setShowScaleLayer(true);
        this.ganttChart.getGraphics().setActivityRenderer(AgendaEntry.class, AgendaLayout.class, new AgendaEntryRenderer(this.ganttChart.getGraphics()));
        Layer capacitiesLayer = new Layer("Capacities");
        Layer agendaLayer = new Layer("Agenda");
        this.ganttChart.getLayers().add((Object)capacitiesLayer);
        this.ganttChart.getLayers().add((Object)agendaLayer);
        for (int i = 0; i < 1; ++i) {
            CapacityRow childRow = new CapacityRow();
            childRow.setName("child row " + i);
            int j = 0;
            while ((long)j < 700L) {
                MutableChartActivityBase capacity = new MutableChartActivityBase();
                capacity.setName("Capacity " + j);
                ZonedDateTime zonedDateTime = ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS).plus(Duration.ofDays(j));
                capacity.setStartTime(Instant.from(zonedDateTime));
                capacity.setDuration(Duration.ofDays(1L));
                if (Math.random() < 0.1) {
                    capacity.setChartValue(-Math.random() * 20.0);
                } else {
                    capacity.setChartValue(Math.random() * 100.0);
                }
                CapacityIndicator header = new CapacityIndicator(capacity);
                header.setStartTime(Instant.from(zonedDateTime));
                header.setDuration(Duration.ofDays(1L));
                childRow.addActivity(capacitiesLayer, header);
                childRow.addActivity(capacitiesLayer, capacity);
                for (int hour = 6; hour < 20; ++hour) {
                    if (!(Math.random() > 0.8)) continue;
                    int duration = (int)(Math.random() * 3.0 + 1.0);
                    LocalTime localStartTime = LocalTime.of(hour, 0);
                    LocalTime localEndTime = LocalTime.of(hour + duration, 0);
                    AgendaEntry entry = new AgendaEntry();
                    entry.setStartTime(Instant.from(zonedDateTime.with(localStartTime)));
                    entry.setEndTime(Instant.from(zonedDateTime.with(localEndTime)));
                    childRow.addActivity(agendaLayer, entry);
                    hour += duration;
                }
                if (this.startTime == null || this.startTime.isAfter(capacity.getStartTime())) {
                    this.startTime = capacity.getStartTime();
                }
                if (this.endTime == null || this.endTime.isBefore(capacity.getEndTime())) {
                    this.endTime = capacity.getEndTime();
                }
                if (this.startTime == null || this.startTime.isAfter(capacity.getStartTime())) {
                    this.startTime = capacity.getStartTime();
                }
                if (this.endTime == null || this.endTime.isBefore(capacity.getEndTime())) {
                    this.endTime = capacity.getEndTime();
                }
                ++j;
            }
            this.ganttChart.getRoot().getChildren().add((Object)childRow);
        }
        if (this.startTime == null) {
            this.startTime = Instant.now();
        }
        this.startTime = this.startTime.truncatedTo(ChronoUnit.DAYS);
        this.ganttChart.getTreeTable().setShowRoot(false);
        this.ganttChart.getRoot().setExpanded(true);
        this.ganttChart.getTimeline().getModel().setStartTime(this.startTime);
        this.ganttChart.getTimeline().getModel().setNow(Instant.now().plus(Duration.ofDays(5L)));
        this.ganttChart.getTimeline().setZoomAnimated(true);
        this.ganttChart.getGraphics().setActivityEditingCallback(CapacityIndicator.class, (Callback<GraphicsBase.EditingCallbackParameter, Boolean>)((Callback)param -> false));
        this.ganttChart.getGraphics().setShowHorizontalCursor(true);
        return this.ganttChart;
    }

    @Override
    public String getJavaDocURL() {
        return this.getJavaDocBase() + "com/flexganttfx/model/Layout.html";
    }

    public static void main(String[] args) {
        HelloMixedLayouts.launch((String[])args);
    }

    public class CapacityRowLineManager
    extends LinesManagerBase<Activity> {
        private GanttLayout ganttLayout;
        private ChartLayout capacityLayout;
        private AgendaLayout agendaLayout;

        public CapacityRowLineManager(CapacityRow row) {
            super(row);
            this.ganttLayout = new GanttLayout();
            this.capacityLayout = new ChartLayout();
            this.agendaLayout = new AgendaLayout();
            this.capacityLayout.setMaxValue(100.0);
            this.capacityLayout.setMinValue(-20.0);
            this.capacityLayout.getMajorTicks().addAll((Object[])new Double[]{0.0, 50.0, 100.0});
            this.capacityLayout.getMinorTicks().addAll((Object[])new Double[]{-10.0, 10.0, 20.0, 30.0, 40.0, 60.0, 70.0, 80.0, 90.0});
            this.agendaLayout.setStartTime(LocalTime.of(0, 0));
            this.agendaLayout.setEndTime(LocalTime.of(23, 0));
        }

        @Override
        public int getLineIndex(Activity activity) {
            if (activity instanceof MutableChartActivityBase) {
                return 1;
            }
            if (activity instanceof CapacityIndicator) {
                return 0;
            }
            return 2;
        }

        @Override
        public double getLineHeight(int lineIndex, double rowHeight) throws IllegalLineIndexException {
            if (lineIndex == 0) {
                return 20.0;
            }
            if (lineIndex == 1) {
                return 100.0;
            }
            return this.getRow().getHeight() - this.getLineHeight(0, rowHeight) - this.getLineHeight(1, rowHeight);
        }

        @Override
        public double getLineLocation(int lineIndex, double rowHeight) throws IllegalLineIndexException {
            switch (lineIndex) {
                case 0: {
                    return 0.0;
                }
                case 1: {
                    return this.getLineHeight(0, rowHeight);
                }
                case 2: {
                    return this.getLineLocation(1, rowHeight) + this.getLineHeight(1, rowHeight);
                }
            }
            return 0.0;
        }

        @Override
        public Layout getLineLayout(int lineIndex) throws IllegalLineIndexException {
            switch (lineIndex) {
                case 0: {
                    return this.ganttLayout;
                }
                case 1: {
                    return this.capacityLayout;
                }
            }
            return this.agendaLayout;
        }
    }

    class CapacityRow
    extends Row<CapacityRow, CapacityRow, Activity> {
        public CapacityRow(boolean parent) {
            this.setLinesManager(new CapacityRowLineManager(this));
            if (parent) {
                this.setHeight(24.0);
            } else {
                this.setLineCount(3);
                this.setHeight(300.0);
            }
            this.setMaxHeight(1000.0);
        }

        public CapacityRow() {
            this(false);
        }
    }

    class CapacityIndicatorRenderer
    extends ActivityBarRenderer<CapacityIndicator> {
        private Map<Integer, Paint> paintMap;
        private Map<Integer, Paint> textFillMap;

        public CapacityIndicatorRenderer(GraphicsBase<?> graphics) {
            super(graphics, "Capacity Indicator");
            this.paintMap = new HashMap<Integer, Paint>();
            this.textFillMap = new HashMap<Integer, Paint>();
            this.paintMap.put(0, (Paint)Color.DARKGREEN);
            this.paintMap.put(10, (Paint)Color.GREEN);
            this.paintMap.put(20, (Paint)Color.LIGHTGREEN);
            this.paintMap.put(50, (Paint)Color.LIGHTYELLOW);
            this.paintMap.put(60, (Paint)Color.YELLOW);
            this.paintMap.put(30, (Paint)Color.ORANGE);
            this.paintMap.put(40, (Paint)Color.DARKORANGE);
            this.paintMap.put(70, (Paint)Color.RED);
            this.paintMap.put(80, (Paint)Color.DARKRED);
            this.paintMap.put(90, (Paint)Color.VIOLET);
            this.paintMap.put(100, (Paint)Color.DARKVIOLET);
            this.textFillMap.put(0, (Paint)Color.WHITE);
            this.textFillMap.put(10, (Paint)Color.WHITE);
            this.textFillMap.put(20, (Paint)Color.BLACK);
            this.textFillMap.put(50, (Paint)Color.BLACK);
            this.textFillMap.put(60, (Paint)Color.BLACK);
            this.textFillMap.put(30, (Paint)Color.ORANGE);
            this.textFillMap.put(40, (Paint)Color.WHITE);
            this.textFillMap.put(70, (Paint)Color.WHITE);
            this.textFillMap.put(80, (Paint)Color.WHITE);
            this.textFillMap.put(90, (Paint)Color.WHITE);
            this.textFillMap.put(100, (Paint)Color.WHITE);
        }

        @Override
        protected ActivityBounds drawActivity(ActivityRef<CapacityIndicator> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
            CapacityIndicator indicator = activityRef.getActivity();
            ChartActivity capacity = indicator.getCapacity();
            double capacityUsed = capacity.getChartValue();
            int limit = Math.max(0, Math.min(100, (int)(capacityUsed - capacityUsed % 10.0)));
            gc.setFill(this.paintMap.get(limit));
            if (w > 4.0) {
                gc.fillRect(x + 1.0, y + 1.0, w - 2.0, h - 2.0);
            } else {
                gc.fillRect(x, y + 1.0, w, h - 2.0);
            }
            this.setTextFill(this.textFillMap.get(limit));
            this.drawText(activityRef, Integer.toString((int)capacityUsed), ActivityBarRenderer.TextPosition.CENTER, gc, x, y, w, h, selected, hover, highlighted, pressed);
            return new ActivityBounds(activityRef, x, y, w, h);
        }
    }

    class CapacityIndicator
    extends MutableActivityBase<Object> {
        private ChartActivity capacity;

        public CapacityIndicator(ChartActivity capacity) {
            this.capacity = capacity;
        }

        public ChartActivity getCapacity() {
            return this.capacity;
        }
    }

    class AgendaEntryRenderer
    extends ActivityRenderer<AgendaEntry> {
        private DateTimeFormatter dateFormatter;
        private DateTimeFormatter timeFormatter;
        private Map<Integer, Color> fillColorMap;
        private Map<Integer, Color> strokeColorMap;
        private Map<Integer, Color> textColorMap;
        private Font font;
        private Image alarmImage;
        private Image recurringImage;

        public AgendaEntryRenderer(GraphicsBase<?> graphics) {
            super(graphics, "Agenda Entries");
            this.dateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);
            this.timeFormatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);
            this.fillColorMap = new HashMap<Integer, Color>();
            this.strokeColorMap = new HashMap<Integer, Color>();
            this.textColorMap = new HashMap<Integer, Color>();
            this.font = Font.font((String)"system", (FontWeight)FontWeight.BOLD, (double)10.0);
            this.fillColorMap.put(0, Color.GREEN);
            this.fillColorMap.put(1, Color.CRIMSON);
            this.fillColorMap.put(2, Color.ORANGE);
            this.strokeColorMap.put(0, Color.GREEN.darker());
            this.strokeColorMap.put(1, Color.CRIMSON.darker());
            this.strokeColorMap.put(2, Color.ORANGE.darker());
            this.textColorMap.put(0, Color.GREEN.darker().darker().darker());
            this.textColorMap.put(1, Color.CRIMSON.darker().darker().darker());
            this.textColorMap.put(2, Color.ORANGE.darker().darker().darker());
            this.setCornerRadius(6.0);
            this.setPadding(new Insets(0.0, 3.0, 0.0, 2.0));
            this.alarmImage = new Image(AgendaEntryRenderer.class.getResource("alarmclock.png").toExternalForm());
            this.recurringImage = new Image(AgendaEntryRenderer.class.getResource("arrow_loop2.png").toExternalForm());
        }

        @Override
        protected ActivityBounds drawActivity(ActivityRef<AgendaEntry> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
            AgendaEntry entry = activityRef.getActivity();
            int colorCode = entry.getColorCode();
            this.setFill((Paint)this.fillColorMap.get(colorCode));
            this.setFillHover((Paint)this.fillColorMap.get(colorCode).brighter());
            this.setFillSelected(this.getFill());
            this.setFillPressed(this.getFill());
            this.setStroke((Paint)this.strokeColorMap.get(colorCode));
            this.setStrokeHover((Paint)this.strokeColorMap.get(colorCode));
            this.setStrokeSelected(this.getStroke());
            this.setStrokePressed(this.getStroke());
            if (pressed || selected) {
                this.setAlpha(1.0);
            } else {
                this.setAlpha(0.66);
            }
            this.setAlpha(this.getAlpha() * activityRef.getLayer().getFadeInOutOpacity());
            ActivityBounds bounds = super.drawActivity(activityRef, position, gc, x, y, w, h, selected, hover, highlighted, pressed);
            if (w > 70.0) {
                gc.setFont(this.font);
                gc.setFill((Paint)this.textColorMap.get(colorCode));
                Row<?, ?, AgendaEntry> row = activityRef.getRow();
                ZonedDateTime zonedStart = ZonedDateTime.ofInstant(entry.getStartTime(), row.getZoneId());
                ZonedDateTime zonedEnd = ZonedDateTime.ofInstant(entry.getEndTime(), row.getZoneId());
                String dateText = this.dateFormatter.format(zonedStart);
                String startText = this.timeFormatter.format(zonedStart);
                String endText = this.timeFormatter.format(zonedEnd);
                Insets padding = this.getPadding();
                x += padding.getLeft();
                y += padding.getTop();
                w -= padding.getLeft() + padding.getRight();
                h -= padding.getTop() + padding.getBottom();
                if (h >= 20.0) {
                    gc.setTextAlign(TextAlignment.LEFT);
                    gc.setTextBaseline(VPos.TOP);
                    gc.fillText(dateText, this.snapPosition(x + 4.0), this.snapPosition(y + 4.0));
                    gc.setTextAlign(TextAlignment.RIGHT);
                    if (w > 110.0) {
                        gc.fillText(startText, this.snapPosition(x + w - 4.0), this.snapPosition(y + 4.0));
                    }
                }
                if (h >= 40.0) {
                    switch (position) {
                        case FIRST: 
                        case MIDDLE: {
                            break;
                        }
                        case LAST: 
                        case ONLY: {
                            gc.setTextBaseline(VPos.BOTTOM);
                            gc.fillText(endText, this.snapPosition(x + w - 4.0), this.snapPosition(y + h - 4.0));
                            break;
                        }
                    }
                    gc.save();
                    gc.setGlobalAlpha(1.0);
                    if (entry.isAlarmSet()) {
                        gc.drawImage(this.alarmImage, this.snapPosition(x + 2.0), this.snapPosition(y + h - 18.0));
                    }
                    if (entry.isRecurring() && h > 80.0) {
                        gc.drawImage(this.recurringImage, this.snapPosition(x + w / 2.0 - this.recurringImage.getWidth() / 2.0), this.snapPosition(y + h / 2.0 - this.recurringImage.getHeight() / 2.0));
                    }
                    gc.restore();
                }
            }
            return bounds;
        }
    }

    class AgendaEntry
    extends MutableActivityBase<String> {
        private int colorCode = (int)(Math.random() * 3.0);
        private boolean alarmSet = Math.random() > 0.8;
        private boolean recurring = Math.random() > 0.9;

        public int getColorCode() {
            return this.colorCode;
        }

        public boolean isAlarmSet() {
            return this.alarmSet;
        }

        public boolean isRecurring() {
            return this.recurring;
        }
    }

    private static enum FilterMode {
        NONE,
        GANTT,
        CAPACITY,
        AGENDA;

    }
}

