/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.layout;

import au.com.bytecode.opencsv.CSVReader;
import com.flexganttfx.demo.FlexGanttFXSample;
import com.flexganttfx.extras.RowControls;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Layout;
import com.flexganttfx.model.LinesManager;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.activity.MutableActivity;
import com.flexganttfx.model.activity.MutableChartActivityBase;
import com.flexganttfx.model.activity.MutableHighLowChartActivityBase;
import com.flexganttfx.model.layout.ChartLayout;
import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.ScaleLayer;
import com.flexganttfx.view.graphics.renderer.ActivityRenderer;
import com.flexganttfx.view.util.Position;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javafx.application.Application;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TreeItemPropertyValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;

public class HelloChartLayout
extends FlexGanttFXSample {
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    protected GanttChart<?> createGanttChart() {
        Properties props = new Properties();
        try {
            props.load(HelloChartLayout.class.getResourceAsStream("text.properties"));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Symbol root = new Symbol("Root");
        GanttChart<Symbol> gc = new GanttChart<Symbol>(root);
        Layer layer = new Layer("Daily Trading");
        gc.getLayers().add((Object)layer);
        String[] ticker = new String[]{"aapl", "amzn", "ebay", "intc", "msft", "orcl", "yhoo"};
        int DAYS = 1000;
        LocalDate earliestDate = null;
        for (String symbol : ticker) {
            Symbol symbolRow = new Symbol(symbol.toUpperCase());
            root.getChildren().add((Object)symbolRow);
            String fileName = "stocks-" + symbol + ".csv";
            try (CSVReader reader = new CSVReader((Reader)new InputStreamReader(HelloChartLayout.class.getResourceAsStream(fileName)), ',', '\"', 1);){
                List<String[]> entries = reader.readAll();
                double min = Double.MAX_VALUE;
                double max = 0.0;
                double minVolume = Double.MAX_VALUE;
                double maxVolume = 0.0;
                int counter = 0;
                for (String[] csvLine : entries) {
                    LocalDate date;
                    earliestDate = date = LocalDate.from(this.formatter.parse(csvLine[0]));
                    Double open = Double.parseDouble(csvLine[1]);
                    Double high = Double.parseDouble(csvLine[2]);
                    Double low = Double.parseDouble(csvLine[3]);
                    Double close = Double.parseDouble(csvLine[4]);
                    Integer volume = Integer.parseInt(csvLine[5]);
                    DailyTrading dailyTrading = new DailyTrading(date, open, low, high, close, volume);
                    symbolRow.getTrades().add(dailyTrading);
                    symbolRow.addActivity(layer, dailyTrading);
                    symbolRow.addActivity(layer, new Volume(date, volume));
                    min = Math.min(min, low);
                    max = Math.max(max, high);
                    minVolume = Math.min(minVolume, (double)volume.intValue());
                    maxVolume = Math.max(maxVolume, (double)volume.intValue());
                    if (++counter <= DAYS) continue;
                    break;
                }
                ChartLayout highLowChartLayout = new ChartLayout();
                highLowChartLayout.setPadding(10.0);
                highLowChartLayout.setMinValue(min);
                highLowChartLayout.setMaxValue(max);
                highLowChartLayout.getMajorTicks().add((Object)min);
                highLowChartLayout.getMajorTicks().add((Object)(min + (max - min) / 2.0));
                highLowChartLayout.getMajorTicks().add((Object)max);
                ChartLayout volumeChartLayout = new ChartLayout();
                volumeChartLayout.setPadding(10.0);
                volumeChartLayout.setMinValue(0.0);
                volumeChartLayout.setMaxValue(maxVolume);
                volumeChartLayout.getMajorTicks().add((Object)maxVolume);
                symbolRow.setHighLowLayout(highLowChartLayout);
                symbolRow.setVolumeLayout(volumeChartLayout);
                symbolRow.setMaxHeight(2000.0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        root.setExpanded(true);
        gc.getCalendars().clear();
        gc.getTreeTable().setShowRoot(false);
        gc.getTimeline().showTime(Instant.from(ZonedDateTime.of(earliestDate, LocalTime.MIN, ZoneId.systemDefault())));
        gc.getTimeline().showTemporalUnit(ChronoUnit.MONTHS, 80.0);
        gc.getGraphics().getSystemLayer(ScaleLayer.class).setPrefWidth(70.0);
        gc.getGraphics().setShowScaleLayer(true);
        gc.getGraphics().setActivityRenderer(DailyTrading.class, ChartLayout.class, new DailyTradingRenderer(gc.getGraphics()));
        gc.getGraphics().setRowEditorFactory(param -> {
            GridPane pane = new GridPane();
            pane.setPrefHeight(450.0);
            pane.setGridLinesVisible(false);
            pane.setStyle("-fx-background-color: white; -fx-border-color: transparent transparent lightgray transparent; -fx-border-width: .5;");
            String fileName = null;
            switch (((Symbol)param.getRow()).getName()) {
                case "AAPL": {
                    fileName = "aapl.png";
                    break;
                }
                case "ORCL": {
                    fileName = "orcl.png";
                    break;
                }
                case "MSFT": {
                    fileName = "msft.png";
                    break;
                }
                case "EBAY": {
                    fileName = "ebay.jpg";
                    break;
                }
                case "INTC": {
                    fileName = "intc.jpeg";
                    break;
                }
                case "AMZN": {
                    fileName = "amzn.jpg";
                    break;
                }
                case "YHOO": {
                    fileName = "yhoo.jpeg";
                }
            }
            ImageView logo = new ImageView(HelloChartLayout.class.getResource(fileName).toExternalForm());
            logo.setSmooth(true);
            logo.setFitHeight(64.0);
            if (((Symbol)param.getRow()).getName().equals("ORCL")) {
                logo.setFitWidth(250.0);
            }
            logo.setPreserveRatio(true);
            Label companyLabel = new Label("", (Node)logo);
            companyLabel.setFont(Font.font((double)24.0));
            companyLabel.setPrefWidth(300.0);
            GridPane.setMargin((Node)companyLabel, (Insets)new Insets(10.0));
            pane.add((Node)companyLabel, 0, 0);
            Text text = new Text(props.getProperty(((Symbol)param.getRow()).getName().toLowerCase()));
            text.setWrappingWidth(300.0);
            GridPane.setMargin((Node)text, (Insets)new Insets(10.0));
            pane.add((Node)text, 0, 1);
            TableView table = new TableView();
            TableColumn dateColumn = new TableColumn("Date");
            TableColumn openColumn = new TableColumn("Open");
            TableColumn lowColumn = new TableColumn("Low");
            TableColumn highColumn = new TableColumn("High");
            TableColumn closeColumn = new TableColumn("Close");
            TableColumn volumeColumn = new TableColumn("Volume");
            table.getColumns().addAll((Object[])new TableColumn[]{dateColumn, openColumn, lowColumn, highColumn, closeColumn, volumeColumn});
            dateColumn.setCellValueFactory((Callback)new PropertyValueFactory("date"));
            openColumn.setCellValueFactory((Callback)new PropertyValueFactory("stockOpen"));
            lowColumn.setCellValueFactory((Callback)new PropertyValueFactory("stockLow"));
            highColumn.setCellValueFactory((Callback)new PropertyValueFactory("stockHigh"));
            closeColumn.setCellValueFactory((Callback)new PropertyValueFactory("stockClose"));
            volumeColumn.setCellValueFactory((Callback)new PropertyValueFactory("volume"));
            table.getItems().addAll(((Symbol)param.getRow()).getTrades());
            GridPane.setHgrow((Node)table, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)table, (Priority)Priority.ALWAYS);
            GridPane.setMargin((Node)table, (Insets)new Insets(10.0));
            GridPane.setRowSpan((Node)table, (Integer)3);
            pane.add((Node)table, 1, 0);
            Button closeButton = new Button("Close Details");
            closeButton.setStyle("-fx-background-color: #ecebe9, rgba(0,0,0,0.05),linear-gradient(#dcca8a, #c7a740),linear-gradient(#f9f2d6 0%, #f4e5bc 20%, #e6c75d 80%, #e2c045 100%),linear-gradient(#f6ebbe, #e6c34d);-fx-background-insets: 0,9 9 8 9,9,10,11;-fx-background-radius: 50;-fx-padding: 15 30 15 30;-fx-font-family: Helvetica;-fx-font-size: 18px;-fx-text-fill: #311c09;-fx-effect: innershadow( three-pass-box , rgba(0,0,0,0.1) , 2, 0.0 , 0 , 1);");
            closeButton.setOnAction(evt -> param.stopEditing());
            pane.add((Node)closeButton, 0, 2);
            GridPane.setHalignment((Node)closeButton, (HPos)HPos.CENTER);
            return pane;
        });
        gc.getGraphics().setRowControlsFactory(param -> new RowControls(param.getGraphics(), param.getRow()));
        TreeTableColumn nameColumn = new TreeTableColumn("Name");
        nameColumn.setPrefWidth(150.0);
        nameColumn.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("name"));
        nameColumn.setCellFactory(column -> new SymbolTreeTableCell());
        gc.getTreeTable().getColumns().clear();
        gc.getTreeTable().getColumns().add((Object)nameColumn);
        return gc;
    }

    @Override
    public String getSampleDescription() {
        return "This sample highlights the High / Low charting capabilities and also the row editing and row controls feature. Each row can have its own hidden controls, which can be revealed with a nice flip animation. In most cases the editing will be started by pressing on a control provided by the row controls feature. This feature adds controls to a row when the mouse cursor hovers over it. Row editing can be restricted to one row at a time, multiple rows at the same time, or completely disabled.";
    }

    @Override
    public Node getControlPanel() {
        ComboBox box = new ComboBox();
        box.getItems().addAll((Object[])GraphicsBase.RowEditingMode.values());
        box.setValue((Object)this.getGanttChart().getGraphics().getRowEditingMode());
        Bindings.bindBidirectional((Property)box.valueProperty(), this.getGanttChart().getGraphics().rowEditingModeProperty());
        return box;
    }

    @Override
    public String getSampleName() {
        return "Chart: High Low";
    }

    @Override
    public String getJavaDocURL() {
        return this.getJavaDocBase() + "com/flexganttfx/model/layout/ChartLayout.html";
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    class DailyTradingRenderer
    extends ActivityRenderer<DailyTrading> {
        public DailyTradingRenderer(GraphicsBase<?> view) {
            super(view, "Daily Trading");
            this.setCornersRounded(false);
        }

        @Override
        protected ActivityBounds drawActivity(ActivityRef<DailyTrading> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
            double xx = x + w / 2.0;
            double ww = Math.min(w, 6.0);
            gc.setFill((Paint)Color.BLACK);
            gc.fillRect(xx - 1.0, y, 2.0, h);
            DailyTrading trading = activityRef.getActivity();
            double yy1 = this.calculateLocation(trading.getStockOpen(), trading, h);
            double yy2 = this.calculateLocation(trading.getStockClose(), trading, h);
            double y1 = y + Math.min(yy1, yy2);
            double y2 = y + Math.max(yy1, yy2);
            if (selected || hover || pressed || highlighted) {
                gc.setFill(this.getFill(selected, hover, highlighted, pressed));
            } else if (trading.getStockClose() < trading.getStockOpen()) {
                gc.setFill((Paint)Color.RED);
            } else {
                gc.setFill((Paint)Color.GREEN);
            }
            gc.fillRect(xx - ww / 2.0, y1, ww, y2 - y1);
            return new ActivityBounds(activityRef, xx - 3.0, y, ww, h);
        }

        private double calculateLocation(double value, DailyTrading trading, double h) {
            double ppv = h / (trading.getStockHigh() - trading.getStockLow());
            return h - (value - trading.getStockLow()) * ppv;
        }
    }

    public class DailyTrading
    extends MutableHighLowChartActivityBase<Object> {
        private LocalDate date;
        private double stockOpen;
        private double stockClose;
        private double stockLow;
        private double stockHigh;
        private int volume;

        public DailyTrading(LocalDate date, double open, double low, double high, double close, int volume) {
            this.date = date;
            this.setStartTime(Instant.from(ZonedDateTime.of(date, LocalTime.MIN, ZoneId.systemDefault())));
            this.setEndTime(Instant.from(ZonedDateTime.of(date, LocalTime.MAX, ZoneId.systemDefault())));
            this.setLow(low);
            this.setHigh(high);
            this.stockLow = low;
            this.stockHigh = high;
            this.stockOpen = open;
            this.stockClose = close;
            this.volume = volume;
        }

        public LocalDate getDate() {
            return this.date;
        }

        public double getStockLow() {
            return this.stockLow;
        }

        public double getStockHigh() {
            return this.stockHigh;
        }

        public double getStockOpen() {
            return this.stockOpen;
        }

        public double getStockClose() {
            return this.stockClose;
        }

        public int getVolume() {
            return this.volume;
        }
    }

    class Volume
    extends MutableChartActivityBase<Object> {
        public Volume(LocalDate date, int volume) {
            this.setChartValue(volume);
            this.setStartTime(Instant.from(ZonedDateTime.of(date, LocalTime.MIN, ZoneId.systemDefault())));
            this.setEndTime(Instant.from(ZonedDateTime.of(date, LocalTime.MAX, ZoneId.systemDefault())));
        }
    }

    class SymbolLinesManager
    implements LinesManager<MutableActivity> {
        private Symbol symbol;

        public SymbolLinesManager(Symbol symbol) {
            this.symbol = symbol;
        }

        @Override
        public int getLineIndex(MutableActivity activity) {
            if (activity instanceof DailyTrading) {
                return 0;
            }
            return 1;
        }

        @Override
        public double getLineLocation(int lineIndex, double rowHeight) {
            switch (lineIndex) {
                case 0: {
                    return 0.0;
                }
                case 1: {
                    return rowHeight - this.getLineHeight(lineIndex, rowHeight);
                }
            }
            return 0.0;
        }

        @Override
        public double getLineHeight(int lineIndex, double rowHeight) {
            switch (lineIndex) {
                case 0: {
                    return rowHeight - this.getLineHeight(1, rowHeight);
                }
                case 1: {
                    return rowHeight * 0.25;
                }
            }
            return 0.0;
        }

        @Override
        public Layout getLineLayout(int lineIndex) {
            if (lineIndex == 0) {
                return this.symbol.getHighLowLayout();
            }
            return this.symbol.getVolumeLayout();
        }
    }

    class Symbol
    extends Row<Symbol, Symbol, MutableActivity> {
        private ChartLayout highLowLayout;
        private ChartLayout volumeLayout;
        private List<DailyTrading> trades;

        public Symbol(String symbol) {
            super(symbol);
            this.trades = new ArrayList<DailyTrading>();
            this.setLinesManager(new SymbolLinesManager(this));
            this.setLineCount(2);
            this.setHeight(300.0);
        }

        public List<DailyTrading> getTrades() {
            return this.trades;
        }

        public void setHighLowLayout(ChartLayout highLowLayout) {
            this.highLowLayout = highLowLayout;
        }

        public ChartLayout getHighLowLayout() {
            return this.highLowLayout;
        }

        public void setVolumeLayout(ChartLayout volumeLayout) {
            this.volumeLayout = volumeLayout;
        }

        public ChartLayout getVolumeLayout() {
            return this.volumeLayout;
        }
    }

    class SymbolTreeTableCell
    extends TreeTableCell<Symbol, String> {
        public SymbolTreeTableCell() {
            this.setStyle("-fx-font-size: 32;");
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setText(item);
            this.setTextAlignment(TextAlignment.CENTER);
            this.setAlignment(Pos.CENTER);
        }
    }
}

