/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.layout;

import com.flexganttfx.demo.FlexGanttFXSample;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.activity.MutableActivityBase;
import com.flexganttfx.model.dateline.ChronoUnitGrid;
import com.flexganttfx.model.layout.AgendaLayout;
import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.ListViewGraphics;
import com.flexganttfx.view.graphics.renderer.ActivityRenderer;
import com.flexganttfx.view.util.Position;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javafx.application.Application;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.BeanPropertyUtils;
import org.controlsfx.property.editor.AbstractPropertyEditor;
import org.controlsfx.property.editor.DefaultPropertyEditorFactory;
import org.controlsfx.property.editor.PropertyEditor;

public class HelloAgendaLayout
extends FlexGanttFXSample {
    private GanttChart<AgendaRow> gc;
    private AgendaLayout layout;
    private Layer layer;
    private AgendaRow row;

    @Override
    public String getSampleName() {
        return "Agenda";
    }

    protected GanttChart<?> createGanttChart() throws Exception {
        AgendaRow root = new AgendaRow("Root");
        this.gc = new GanttChart<AgendaRow>(root);
        this.gc.getTimeline().showTemporalUnit(ChronoUnit.DAYS, 100.0);
        ListViewGraphics graphics = this.gc.getGraphics();
        this.row = new AgendaRow("Test Row");
        this.row.setMaxHeight(1200.0);
        this.row.setHeight(700.0);
        InvalidationListener redrawListener = it -> graphics.redraw();
        this.layout = new AgendaLayout();
        this.layout.setStartTime(LocalTime.of(7, 0));
        this.layout.setEndTime(LocalTime.of(17, 0));
        this.layout.layoutStrategyProperty().addListener(redrawListener);
        this.layout.startTimeProperty().addListener(redrawListener);
        this.layout.endTimeProperty().addListener(redrawListener);
        this.layout.overlapOffsetProperty().addListener(redrawListener);
        this.layout.paddingProperty().addListener(redrawListener);
        this.layout.minLineSpacingProperty().addListener(redrawListener);
        this.row.setLayout(this.layout);
        root.getChildren().add((Object)this.row);
        root.setExpanded(true);
        this.layer = new Layer("Default");
        this.gc.getLayers().add((Object)this.layer);
        this.gc.getTreeTable().setShowRoot(false);
        graphics.setVirtualGrid(new ChronoUnitGrid("5 Minutes", ChronoUnit.MINUTES, 5));
        graphics.setShowMarkedTimeInterval(false);
        graphics.setShowVerticalCursor(false);
        graphics.setShowScaleLayer(true);
        graphics.setActivityRenderer(AgendaActivity.class, AgendaLayout.class, new AgendaActivityRenderer(graphics));
        graphics.addEventFilter(MouseEvent.MOUSE_CLICKED, evt -> this.createActivity((MouseEvent)evt));
        graphics.setVirtualGrid(null);
        LocalDate date = LocalDate.now().with(TemporalAdjusters.nextOrSame(DayOfWeek.MONDAY));
        for (int i = 0; i < 50; ++i) {
            this.createSchedule(date);
            date = date.with(TemporalAdjusters.next(DayOfWeek.MONDAY));
        }
        return this.gc;
    }

    private void createSchedule(LocalDate date) {
        this.addActivity(date, Type.ENGLISH, 8, 0, 8, 45);
        this.addActivity(date, Type.ENGLISH, 8, 50, 9, 35);
        this.addActivity(date, Type.MATH, 9, 50, 10, 35);
        this.addActivity(date, Type.MATH, 10, 40, 11, 25);
        this.addActivity(date, Type.BIOLOGY, 11, 40, 12, 25);
        this.addActivity(date, Type.BIOLOGY, 12, 30, 13, 15);
        this.addActivity(date, Type.GERMAN, 14, 30, 15, 15);
        this.addActivity(date, Type.GERMAN, 15, 20, 16, 5);
        this.addActivity(date.plusDays(1L), Type.CHEMISTRY, 8, 0, 8, 45);
        this.addActivity(date.plusDays(1L), Type.ENGLISH, 8, 50, 9, 35);
        this.addActivity(date.plusDays(1L), Type.RELIGION, 9, 50, 10, 35);
        this.addActivity(date.plusDays(1L), Type.RELIGION, 10, 40, 11, 25);
        this.addActivity(date.plusDays(1L), Type.SPORT, 11, 40, 12, 25);
        this.addActivity(date.plusDays(1L), Type.SPORT, 12, 30, 13, 15);
        this.addActivity(date.plusDays(1L), Type.GERMAN, 14, 30, 15, 15);
        this.addActivity(date.plusDays(1L), Type.GERMAN, 15, 20, 16, 5);
        this.addActivity(date.plusDays(2L), Type.CHEMISTRY, 8, 0, 8, 45);
        this.addActivity(date.plusDays(2L), Type.ENGLISH, 8, 50, 9, 35);
        this.addActivity(date.plusDays(2L), Type.MATH, 9, 50, 10, 35);
        this.addActivity(date.plusDays(2L), Type.MATH, 10, 40, 11, 25);
        this.addActivity(date.plusDays(2L), Type.SPORT, 11, 40, 12, 25);
        this.addActivity(date.plusDays(2L), Type.SPORT, 12, 30, 13, 15);
        this.addActivity(date.plusDays(3L), Type.BIOLOGY, 8, 0, 8, 45);
        this.addActivity(date.plusDays(3L), Type.BIOLOGY, 8, 50, 9, 35);
        this.addActivity(date.plusDays(3L), Type.GERMAN, 9, 50, 10, 35);
        this.addActivity(date.plusDays(3L), Type.GERMAN, 10, 40, 11, 25);
        this.addActivity(date.plusDays(3L), Type.PHYSICS, 11, 40, 12, 25);
        this.addActivity(date.plusDays(3L), Type.PHYSICS, 12, 30, 13, 15);
        this.addActivity(date.plusDays(3L), Type.PHYSICS, 14, 30, 16, 5);
        this.addActivity(date.plusDays(4L), Type.CHEMISTRY, 8, 0, 8, 45);
        this.addActivity(date.plusDays(4L), Type.CHEMISTRY, 8, 50, 9, 35);
        this.addActivity(date.plusDays(4L), Type.MATH, 9, 50, 10, 35);
        this.addActivity(date.plusDays(4L), Type.MATH, 10, 40, 11, 25);
        this.addActivity(date.plusDays(4L), Type.BIOLOGY, 11, 40, 12, 25);
        this.addActivity(date.plusDays(4L), Type.BIOLOGY, 12, 30, 13, 15);
    }

    private void addActivity(LocalDate date, Type type, int startHour, int startMinute, int endHour, int endMinute) {
        Instant st = ZonedDateTime.of(date, LocalTime.of(startHour, startMinute), this.row.getZoneId()).toInstant();
        Instant et = ZonedDateTime.of(date, LocalTime.of(endHour, endMinute), this.row.getZoneId()).toInstant();
        AgendaActivity activity = new AgendaActivity(type);
        activity.setStartTime(st);
        activity.setEndTime(et);
        this.row.addActivity(this.layer, activity);
    }

    private void createActivity(MouseEvent evt) {
        ListViewGraphics graphics;
        AgendaRow row;
        if (evt.getClickCount() == 2 && (row = (AgendaRow)(graphics = this.gc.getGraphics()).getRowAt(evt.getY())) != null) {
            Instant time = graphics.getTimeAt(evt.getX());
            LocalTime localTime = graphics.getLocalTimeAt(evt.getY());
            AgendaActivity activity = new AgendaActivity(Type.SPORT);
            activity.setStartTime(ZonedDateTime.ofInstant(time, row.getZoneId()).with(localTime).toInstant());
            activity.setEndTime(activity.getStartTime().plus(Duration.ofHours(1L)));
            row.addActivity(this.layer, activity);
        }
    }

    @Override
    public String getSampleDescription() {
        return "The agenda layout class is used to layout activities vertically in a way that is similar to regular calendars. Double click to create new activities.";
    }

    @Override
    public Node getControlPanel() {
        PropertySheet sheet = new PropertySheet(BeanPropertyUtils.getProperties(this.layout));
        DefaultPropertyEditorFactory factory = new DefaultPropertyEditorFactory(){

            @Override
            public PropertyEditor<?> call(PropertySheet.Item item) {
                if (item.getType() == LocalTime.class) {
                    return new LocalTimePropertyEditor(item);
                }
                return super.call(item);
            }
        };
        sheet.setPropertyEditorFactory(factory);
        return sheet;
    }

    @Override
    public String getJavaDocURL() {
        return this.getJavaDocBase() + "com/flexganttfx/model/layout/AgendaLayout.html";
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public class AgendaActivityRenderer
    extends ActivityRenderer<AgendaActivity> {
        private DateTimeFormatter timeFormatter;
        private Map<Type, Color> fillColorMap;
        private Map<Type, Color> strokeColorMap;
        private Map<Type, Color> textColorMap;
        private Map<Type, Image> imageMap;
        private Font font;
        private final BooleanProperty showReflections;
        private final BooleanProperty showDebugInfo;
        private final BooleanProperty showIcons;

        public AgendaActivityRenderer(GraphicsBase<?> graphics) {
            super(graphics, "Agenda Activities");
            this.timeFormatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);
            this.fillColorMap = new HashMap<Type, Color>();
            this.strokeColorMap = new HashMap<Type, Color>();
            this.textColorMap = new HashMap<Type, Color>();
            this.imageMap = new HashMap<Type, Image>();
            this.font = Font.font((String)"system", (FontWeight)FontWeight.BOLD, (double)10.0);
            this.showReflections = new SimpleBooleanProperty((Object)this, "showReflections", false);
            this.showDebugInfo = new SimpleBooleanProperty((Object)this, "showDebugInfo", false);
            this.showIcons = new SimpleBooleanProperty((Object)this, "showIcons", true);
            this.fillColorMap.put(Type.GERMAN, Color.GREEN);
            this.fillColorMap.put(Type.ENGLISH, Color.CRIMSON);
            this.fillColorMap.put(Type.BIOLOGY, Color.ORANGE);
            this.fillColorMap.put(Type.PHYSICS, Color.CORNFLOWERBLUE);
            this.fillColorMap.put(Type.CHEMISTRY, Color.CADETBLUE);
            this.fillColorMap.put(Type.MATH, Color.INDIANRED);
            this.fillColorMap.put(Type.RELIGION, Color.WHEAT);
            this.fillColorMap.put(Type.SPORT, Color.CORAL);
            this.strokeColorMap.put(Type.GERMAN, Color.GREEN.darker());
            this.strokeColorMap.put(Type.ENGLISH, Color.CRIMSON.darker());
            this.strokeColorMap.put(Type.BIOLOGY, Color.ORANGE.darker());
            this.strokeColorMap.put(Type.PHYSICS, Color.CORNFLOWERBLUE.darker());
            this.strokeColorMap.put(Type.CHEMISTRY, Color.CADETBLUE.darker());
            this.strokeColorMap.put(Type.MATH, Color.INDIANRED.darker());
            this.strokeColorMap.put(Type.RELIGION, Color.WHEAT.darker());
            this.strokeColorMap.put(Type.SPORT, Color.CORAL.darker());
            this.textColorMap.put(Type.GERMAN, Color.GREEN.darker().darker().darker());
            this.textColorMap.put(Type.ENGLISH, Color.CRIMSON.darker().darker().darker());
            this.textColorMap.put(Type.BIOLOGY, Color.BISQUE.darker().darker().darker());
            this.textColorMap.put(Type.PHYSICS, Color.CORNFLOWERBLUE.darker().darker().darker());
            this.textColorMap.put(Type.CHEMISTRY, Color.CADETBLUE.darker().darker().darker());
            this.textColorMap.put(Type.MATH, Color.INDIANRED.darker().darker().darker());
            this.textColorMap.put(Type.RELIGION, Color.WHEAT.darker().darker().darker());
            this.textColorMap.put(Type.SPORT, Color.CORAL.darker().darker().darker());
            this.imageMap.put(Type.GERMAN, new Image(AgendaActivityRenderer.class.getResourceAsStream("german.png")));
            this.imageMap.put(Type.ENGLISH, new Image(AgendaActivityRenderer.class.getResourceAsStream("english.png")));
            this.imageMap.put(Type.BIOLOGY, new Image(AgendaActivityRenderer.class.getResourceAsStream("biology.png")));
            this.imageMap.put(Type.PHYSICS, new Image(AgendaActivityRenderer.class.getResourceAsStream("physics.png")));
            this.imageMap.put(Type.CHEMISTRY, new Image(AgendaActivityRenderer.class.getResourceAsStream("chemistry.png")));
            this.imageMap.put(Type.MATH, new Image(AgendaActivityRenderer.class.getResourceAsStream("math.png")));
            this.imageMap.put(Type.RELIGION, new Image(AgendaActivityRenderer.class.getResourceAsStream("religion.png")));
            this.imageMap.put(Type.SPORT, new Image(AgendaActivityRenderer.class.getResourceAsStream("sport.png")));
            this.setCornerRadius(6.0);
            this.setPadding(new Insets(0.0, 3.0, 0.0, 2.0));
            this.redrawObservable((Observable)this.showReflections);
            this.redrawObservable((Observable)this.showIcons);
            this.redrawObservable((Observable)this.showDebugInfo);
        }

        public final BooleanProperty showReflectionsProperty() {
            return this.showReflections;
        }

        public final void setShowReflections(boolean b2) {
            this.showReflectionsProperty().set(b2);
        }

        public final boolean isShowReflections() {
            return this.showReflectionsProperty().get();
        }

        public final BooleanProperty showDebugInfoProperty() {
            return this.showDebugInfo;
        }

        public final void setisShowDebugInfo(boolean b2) {
            this.showDebugInfoProperty().set(b2);
        }

        public final boolean isShowDebugInfo() {
            return this.showDebugInfoProperty().get();
        }

        public final BooleanProperty showIconsProperty() {
            return this.showIcons;
        }

        public final void setShowIcons(boolean b2) {
            this.showIconsProperty().set(b2);
        }

        public final boolean isShowIcons() {
            return this.showIconsProperty().get();
        }

        @Override
        protected ActivityBounds drawActivity(ActivityRef<AgendaActivity> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
            AgendaActivity entry = activityRef.getActivity();
            Type type = entry.getType();
            this.setFill((Paint)this.fillColorMap.get((Object)type));
            this.setFillHover((Paint)this.fillColorMap.get((Object)type).brighter());
            this.setFillSelected(this.getFill());
            this.setFillPressed(this.getFill());
            this.setStroke((Paint)this.strokeColorMap.get((Object)type));
            this.setStrokeHover((Paint)this.strokeColorMap.get((Object)type));
            this.setStrokeSelected(this.getStroke());
            this.setStrokePressed(this.getStroke());
            if (pressed || selected) {
                this.setAlpha(1.0);
            } else {
                this.setAlpha(0.66);
            }
            ActivityBounds bounds = super.drawActivity(activityRef, position, gc, x, y, w, h, selected, hover, highlighted, pressed);
            if (w > 50.0) {
                if (this.isShowIcons()) {
                    Image img = this.imageMap.get((Object)entry.getType());
                    double imgWidth = img.getWidth();
                    double imgHeight = img.getHeight();
                    if (w > imgWidth + 8.0 && h > imgHeight + 20.0) {
                        gc.drawImage(img, x + (w - imgWidth) / 2.0, y + (h - imgHeight) / 2.0);
                    }
                }
                gc.setFont(this.font);
                Row<?, ?, AgendaActivity> row = activityRef.getRow();
                ZonedDateTime zonedStart = ZonedDateTime.ofInstant(entry.getStartTime(), row.getZoneId());
                ZonedDateTime zonedEnd = ZonedDateTime.ofInstant(entry.getEndTime(), row.getZoneId());
                String startText = this.timeFormatter.format(zonedStart);
                String endText = this.timeFormatter.format(zonedEnd);
                Insets padding = this.getPadding();
                x += padding.getLeft();
                y += padding.getTop();
                w -= padding.getLeft() + padding.getRight();
                h -= padding.getTop() + padding.getBottom();
                if (h >= 20.0 && w > 50.0) {
                    gc.setFill((Paint)this.textColorMap.get((Object)type));
                    gc.setTextBaseline(VPos.TOP);
                    gc.setTextAlign(TextAlignment.RIGHT);
                    gc.fillText(startText, this.snapPosition(x + w - 4.0), this.snapPosition(y + 4.0));
                }
                if (h >= 40.0 && w > 50.0) {
                    switch (position) {
                        case FIRST: 
                        case MIDDLE: {
                            break;
                        }
                        case LAST: 
                        case ONLY: {
                            gc.setFill((Paint)this.textColorMap.get((Object)type));
                            gc.setTextBaseline(VPos.BOTTOM);
                            gc.setTextAlign(TextAlignment.RIGHT);
                            gc.fillText(endText, this.snapPosition(x + w - 4.0), this.snapPosition(y + h - 4.0));
                            break;
                        }
                    }
                }
            }
            return bounds;
        }
    }

    class AgendaActivity
    extends MutableActivityBase<String> {
        private Type type = Type.GERMAN;

        public AgendaActivity(Type type) {
            this.type = type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }
    }

    public static enum Type {
        ENGLISH("English"),
        GERMAN("German"),
        MATH("Math"),
        SPORT("Sport"),
        CHEMISTRY("Chemistry"),
        PHYSICS("Physics"),
        BIOLOGY("Biology"),
        RELIGION("Religion");

        private String displayName;

        private Type(String name) {
            this.displayName = name;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    class LocalTimeEditorSkin
    extends SkinBase<LocalTimeEditor> {
        public LocalTimeEditorSkin(LocalTimeEditor editor) {
            super((Control)editor);
            ComboBox box = new ComboBox();
            box.setMaxWidth(Double.MAX_VALUE);
            for (int i = 0; i <= 23; ++i) {
                box.getItems().add((Object)LocalTime.of(i, 0));
                box.getItems().add((Object)LocalTime.of(i, 30));
            }
            box.getItems().add((Object)LocalTime.MAX);
            Bindings.bindBidirectional((Property)box.valueProperty(), editor.localTimeProperty());
            this.getChildren().add((Object)box);
        }
    }

    class LocalTimeEditor
    extends Control
    implements PropertyEditor<LocalTime> {
        private final ObjectProperty<LocalTime> localTime = new SimpleObjectProperty((Object)this, "localTime", (Object)LocalTime.MIN);

        protected Skin<?> createDefaultSkin() {
            return new LocalTimeEditorSkin(this);
        }

        public final ObjectProperty<LocalTime> localTimeProperty() {
            return this.localTime;
        }

        public final void setLocalTime(LocalTime time) {
            Objects.requireNonNull(time);
            this.localTime.set((Object)time);
        }

        public final LocalTime getLocalTime() {
            return (LocalTime)this.localTime.get();
        }

        @Override
        public Node getEditor() {
            return this;
        }

        @Override
        public LocalTime getValue() {
            return this.getLocalTime();
        }

        @Override
        public void setValue(LocalTime time) {
            this.localTime.set((Object)time);
        }
    }

    class LocalTimePropertyEditor
    extends AbstractPropertyEditor<LocalTime, LocalTimeEditor> {
        public LocalTimePropertyEditor(PropertySheet.Item item) {
            super(item, new LocalTimeEditor());
        }

        @Override
        public void setValue(LocalTime time) {
            ((LocalTimeEditor)this.getEditor()).setValue(time);
        }

        @Override
        protected ObservableValue<LocalTime> getObservableValue() {
            return ((LocalTimeEditor)this.getEditor()).localTimeProperty();
        }
    }

    class AgendaRow
    extends Row<AgendaRow, AgendaRow, MutableActivityBase<String>> {
        public AgendaRow(String name) {
            super(name);
        }
    }
}

