/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.gantt;

import com.flexganttfx.demo.FlexGanttFXSample;
import com.flexganttfx.demo.HelloActivity;
import com.flexganttfx.demo.HelloRow;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.graphics.ListViewGraphics;
import java.io.FileNotFoundException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javafx.application.Application;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;

public class HelloToolTip
extends FlexGanttFXSample {
    private static final Layer layer = new Layer("Flights");
    private GanttChart<HelloRow> gc;
    private Tooltip tooltip;

    protected GanttChart<?> createGanttChart() throws FileNotFoundException {
        this.gc = new GanttChart();
        this.tooltip = new Tooltip("");
        this.gc.getGraphics().getListView().setTooltip(this.tooltip);
        this.gc.getLayers().add((Object)layer);
        HelloRow row = new HelloRow("Row");
        HelloActivity activity1 = new HelloActivity("Item 1");
        HelloActivity activity2 = new HelloActivity("Item 2");
        HelloActivity activity3 = new HelloActivity("Item 3");
        activity1.setStartTime(Instant.now().plus(2L, ChronoUnit.DAYS));
        activity1.setEndTime(Instant.now().plus(3L, ChronoUnit.DAYS));
        activity2.setStartTime(Instant.now().plus(5L, ChronoUnit.DAYS));
        activity2.setEndTime(Instant.now().plus(8L, ChronoUnit.DAYS));
        activity3.setStartTime(Instant.now().plus(10L, ChronoUnit.DAYS));
        activity3.setEndTime(Instant.now().plus(12L, ChronoUnit.DAYS));
        row.addActivity(layer, activity1);
        row.addActivity(layer, activity2);
        row.addActivity(layer, activity3);
        this.gc.getTimeline().showTime(Instant.now().plus(1L, ChronoUnit.DAYS), false);
        this.gc.setRoot(row);
        ListViewGraphics graphics = this.gc.getGraphics();
        graphics.getListView().addEventHandler(MouseEvent.MOUSE_MOVED, evt -> this.mouseMoved((MouseEvent)evt));
        return this.gc;
    }

    private void mouseMoved(MouseEvent evt) {
        ActivityRef<?> ref = this.gc.getGraphics().getActivityRefAt(evt.getX(), evt.getY());
        if (ref != null) {
            this.tooltip.setText(ref.getActivity().getName());
        }
    }

    @Override
    public String getSampleName() {
        return "Tooltips";
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

