/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.gantt;

import com.flexganttfx.demo.FlexGanttFXSample;
import com.flexganttfx.demo.HelloActivity;
import com.flexganttfx.demo.HelloRow;
import com.flexganttfx.model.ActivityRepository;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.repository.ListActivityRepository;
import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.timeline.Timeline;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.io.FileNotFoundException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.application.Application;
import javafx.geometry.Rectangle2D;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class HelloSystemLayers
extends FlexGanttFXSample {
    private static final Layer layer = new Layer("Flights");
    private GanttChart<HelloRow> gc;

    protected GanttChart<?> createGanttChart() throws FileNotFoundException {
        this.gc = new GanttChart();
        this.gc.getLayers().add((Object)layer);
        this.gc.getTimeline().getModel().setHorizonStartTime(Instant.now().truncatedTo(ChronoUnit.DAYS).minus(2L, ChronoUnit.DAYS));
        HelloRow row = new HelloRow("Row");
        row.setRepository(new ListActivityRepository(ListActivityRepository.IteratorType.SIMPLE_ITERATOR));
        HelloActivity activity1 = new HelloActivity("Item 1");
        HelloActivity activity2 = new HelloActivity("Item 2");
        HelloActivity activity3 = new HelloActivity("Item 3");
        activity1.setStartTime(Instant.now().plus(2L, ChronoUnit.DAYS));
        activity1.setEndTime(Instant.now().plus(3L, ChronoUnit.DAYS));
        activity2.setStartTime(Instant.now().plus(5L, ChronoUnit.DAYS));
        activity2.setEndTime(Instant.now().plus(8L, ChronoUnit.DAYS));
        activity3.setStartTime(Instant.now().plus(10L, ChronoUnit.DAYS));
        activity3.setEndTime(Instant.now().plus(12L, ChronoUnit.DAYS));
        row.addActivity(layer, activity1);
        row.addActivity(layer, activity2);
        row.addActivity(layer, activity3);
        this.gc.getGraphics().getBackgroundSystemLayers().add((Object)new LinksLayer(this.gc.getGraphics()));
        this.gc.getTimeline().showTime(Instant.now().plus(1L, ChronoUnit.DAYS), false);
        this.gc.setRoot(row);
        return this.gc;
    }

    @Override
    public String getSampleName() {
        return "System Layers";
    }

    @Override
    public String getJavaDocURL() {
        return this.getJavaDocBase() + "com/flexganttfx/view/graphics/layer/SystemLayer.html";
    }

    @Override
    public String getSampleDescription() {
        return "This sample shows how to create a custom system layer for drawing connecting lines between activities.";
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    class LinksLayer
    extends SystemLayer<HelloRow> {
        private Map<String, Rectangle2D> boundsMap;

        public LinksLayer(GraphicsBase<HelloRow> graphicsView) {
            super("Links Layer", graphicsView);
            this.boundsMap = new HashMap<String, Rectangle2D>();
        }

        @Override
        public void drawLayer(RowCanvas<HelloRow> canvas, Instant startTime, Instant endTime) {
            HelloRow row = canvas.getRow();
            if (row != null) {
                this.boundsMap.clear();
                GraphicsBase<HelloRow> graphics = canvas.getGraphics();
                Timeline timeline = graphics.getTimeline();
                Dateline dateline = timeline.getDateline();
                int barHeight = 10;
                ActivityRepository repository = row.getRepository();
                TemporalUnit primaryTemporalUnit = dateline.getPrimaryTemporalUnit();
                Iterator activities = repository.getActivities(layer, startTime, endTime, primaryTemporalUnit, row.getZoneId());
                while (activities.hasNext()) {
                    HelloActivity activity = (HelloActivity)activities.next();
                    String name = activity.getName();
                    double x1 = timeline.getModel().calculateLocationForTime(activity.getStartTime());
                    double x2 = timeline.getModel().calculateLocationForTime(activity.getEndTime());
                    double y1 = (canvas.getHeight() - (double)barHeight) / 2.0;
                    double y2 = y1 + (double)barHeight;
                    this.boundsMap.put(name, new Rectangle2D(x1, y1, x2 - x1, y2 - y1));
                }
                Rectangle2D bounds1 = this.boundsMap.get("Item 1");
                Rectangle2D bounds2 = this.boundsMap.get("Item 2");
                Rectangle2D bounds3 = this.boundsMap.get("Item 3");
                GraphicsContext gc = canvas.getGraphicsContext2D();
                if (bounds1 != null && bounds2 != null) {
                    gc.setStroke((Paint)Color.RED);
                    gc.strokeLine(bounds1.getMaxX(), bounds1.getMinY(), bounds2.getMinX(), bounds2.getMinY());
                }
                if (bounds2 != null && bounds3 != null) {
                    gc.setStroke((Paint)Color.BLUE);
                    gc.strokeLine(bounds2.getMaxX(), bounds2.getMaxY(), bounds3.getMinX(), bounds3.getMaxY());
                }
            }
        }
    }
}

