/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.gantt;

import com.flexganttfx.demo.FlexGanttFXSample;
import com.flexganttfx.model.Activity;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.GanttChart;
import java.util.ArrayList;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;

public class HelloRowHeader
extends FlexGanttFXSample {
    private GanttChart<MyRow> gantt;

    @Override
    public String getSampleName() {
        return "Row Header";
    }

    protected GanttChart<?> createGanttChart() throws Exception {
        this.gantt = new GanttChart();
        this.gantt.getStylesheets().add((Object)HelloRowHeader.class.getResource("row-header.css").toExternalForm());
        ArrayList<MyRow> rows = new ArrayList<MyRow>();
        for (int i = 0; i < 10; ++i) {
            MyRow row = new MyRow("Row " + i);
            row.setExpanded(true);
            rows.add(row);
            for (int j = 0; j < 10; ++j) {
                MyRow subRow = new MyRow("Child row " + j);
                subRow.setExpanded(true);
                row.getChildren().add((Object)subRow);
                for (int k = 0; k < 10; ++k) {
                    MyRow subSubRow = new MyRow("Child child row " + k);
                    subRow.getChildren().add((Object)subSubRow);
                }
            }
        }
        MyRow root = new MyRow("Root Row");
        root.setExpanded(true);
        root.getChildren().addAll(rows);
        this.gantt.setRoot(root);
        return this.gantt;
    }

    @Override
    public Node getControlPanel() {
        VBox controlPane = new VBox();
        controlPane.setSpacing(10.0);
        this.gantt.setRowHeaderNodeFactory(new ColorCallback());
        this.gantt.rowHeaderTypeProperty().addListener(evt -> {
            switch (this.gantt.getRowHeaderType()) {
                case ROW_NUMBER: {
                    this.gantt.getRowHeader().setPrefWidth(30.0);
                    break;
                }
                case LEVEL_NUMBER: {
                    this.gantt.getRowHeader().setPrefWidth(50.0);
                    break;
                }
            }
        });
        ComboBox contentTypeBox = new ComboBox();
        contentTypeBox.getItems().addAll((Object[])GanttChart.RowHeaderType.values());
        contentTypeBox.setValue((Object)this.gantt.getRowHeaderType());
        this.gantt.rowHeaderTypeProperty().bind((ObservableValue)contentTypeBox.valueProperty());
        controlPane.getChildren().add((Object)contentTypeBox);
        ToggleGroup group = new ToggleGroup();
        RadioButton colorCallback = new RadioButton("Color");
        colorCallback.setSelected(true);
        colorCallback.setToggleGroup(group);
        colorCallback.setOnAction(evt -> {
            this.gantt.setRowHeaderNodeFactory(new ColorCallback());
            this.gantt.getRowHeader().setPrefWidth(24.0);
        });
        colorCallback.disableProperty().bind((ObservableValue)Bindings.notEqual((Object)((Object)GanttChart.RowHeaderType.GRAPHIC_NODE), this.gantt.rowHeaderTypeProperty()));
        controlPane.getChildren().add((Object)colorCallback);
        RadioButton statusCallback = new RadioButton("Status");
        statusCallback.setToggleGroup(group);
        statusCallback.setOnAction(evt -> {
            this.gantt.setRowHeaderNodeFactory(new StatusCallback());
            this.gantt.getRowHeader().setPrefWidth(30.0);
        });
        statusCallback.disableProperty().bind((ObservableValue)Bindings.notEqual((Object)((Object)GanttChart.RowHeaderType.GRAPHIC_NODE), this.gantt.rowHeaderTypeProperty()));
        controlPane.getChildren().add((Object)statusCallback);
        RadioButton controlCallback = new RadioButton("Control");
        controlCallback.setToggleGroup(group);
        controlCallback.setOnAction(evt -> {
            this.gantt.setRowHeaderNodeFactory(new ControlCallback());
            this.gantt.getRowHeader().setPrefWidth(40.0);
        });
        controlCallback.disableProperty().bind((ObservableValue)Bindings.notEqual((Object)((Object)GanttChart.RowHeaderType.GRAPHIC_NODE), this.gantt.rowHeaderTypeProperty()));
        controlPane.getChildren().add((Object)controlCallback);
        return controlPane;
    }

    @Override
    public String getSampleDescription() {
        return "The first column of the tree table is the row header. The header can be used to display lines numbers, indentation levels, or arbitrary nodes.";
    }

    @Override
    public String getJavaDocURL() {
        return this.getJavaDocBase() + "com/flexganttfx/view/util/RowHeader.html";
    }

    public static void main(String[] args) {
        HelloRowHeader.launch((String[])args);
    }

    class ControlCallback
    implements Callback<MyRow, Node> {
        ControlCallback() {
        }

        public Node call(MyRow param) {
            CheckBox box = new CheckBox();
            box.setAllowIndeterminate(true);
            box.setMaxWidth(Double.MAX_VALUE);
            box.setAlignment(Pos.CENTER);
            box.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            switch (param.getStatus()) {
                case ERROR: {
                    box.setSelected(true);
                    break;
                }
                case WARNING: {
                    box.setIndeterminate(true);
                    break;
                }
            }
            return box;
        }
    }

    class ColorCallback
    implements Callback<MyRow, Node> {
        ColorCallback() {
        }

        public Node call(MyRow param) {
            Region region = new Region();
            region.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(param.getPaint(), new CornerRadii(4.0), new Insets(2.0))}));
            return region;
        }
    }

    class StatusCallback
    implements Callback<MyRow, Node> {
        StatusCallback() {
        }

        public Node call(MyRow param) {
            Label label = new Label();
            label.setMaxWidth(Double.MAX_VALUE);
            label.setMaxHeight(Double.MAX_VALUE);
            label.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            label.setAlignment(Pos.CENTER);
            switch (param.getStatus()) {
                case ERROR: {
                    label.getStyleClass().add((Object)"error");
                    break;
                }
                case WARNING: {
                    label.getStyleClass().add((Object)"warning");
                    break;
                }
                case OK: {
                    label.getStyleClass().clear();
                }
            }
            return label;
        }
    }

    class MyRow
    extends Row<MyRow, MyRow, Activity> {
        private Paint paint;
        private Status status;

        public MyRow(String name) {
            super(name);
            this.status = Status.OK;
            this.paint = Color.color((double)Math.random(), (double)Math.random(), (double)Math.random());
            double rnd = Math.random();
            if (rnd < 0.2) {
                this.status = Status.ERROR;
            } else if (rnd < 0.3) {
                this.status = Status.WARNING;
            }
        }

        public Paint getPaint() {
            return this.paint;
        }

        public Status getStatus() {
            return this.status;
        }
    }

    static enum Status {
        OK,
        WARNING,
        ERROR;

    }
}

