/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.gantt;

import com.flexganttfx.demo.FlexGanttFXSample;
import com.flexganttfx.view.GanttChart;
import java.io.FileNotFoundException;
import javafx.application.Application;
import javafx.print.PageLayout;
import javafx.print.PageOrientation;
import javafx.print.Paper;
import javafx.print.Printer;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.VBox;
import javafx.scene.transform.Scale;

public class HelloPrinting
extends FlexGanttFXSample {
    private GanttChart<?> gc;

    protected GanttChart<?> createGanttChart() throws FileNotFoundException {
        this.gc = new GanttChart();
        return this.gc;
    }

    @Override
    public String getSampleName() {
        return "Printing";
    }

    @Override
    public String getJavaDocURL() {
        return this.getJavaDocBase() + "com/flexganttfx/view/GanttChart.html";
    }

    @Override
    public String getSampleDescription() {
        return "A simple way of printing the Gantt chart. First we create a snapshot of the chart, then use the generated image to create an ImageView node, then print the view.";
    }

    @Override
    public Node getControlPanel() {
        VBox box = new VBox();
        box.setFillWidth(true);
        Button print = new Button("Print");
        print.setOnAction(evt -> this.print());
        box.getChildren().add((Object)print);
        return box;
    }

    private void print() {
        boolean success;
        boolean okPrintDialog;
        boolean okPageSetup;
        SnapshotParameters params = new SnapshotParameters();
        WritableImage image = new WritableImage((int)this.gc.getWidth(), (int)this.gc.getHeight());
        WritableImage snapshot = this.gc.snapshot(params, image);
        ImageView node = new ImageView((Image)snapshot);
        Printer printer = Printer.getDefaultPrinter();
        PageLayout pageLayout = printer.createPageLayout(Paper.A4, PageOrientation.LANDSCAPE, Printer.MarginType.DEFAULT);
        double scaleX = pageLayout.getPrintableWidth() / node.getBoundsInParent().getWidth();
        double scaleY = pageLayout.getPrintableHeight() / node.getBoundsInParent().getHeight();
        double scale = Math.min(scaleX, scaleY);
        node.getTransforms().add((Object)new Scale(scale, scale));
        PrinterJob job = PrinterJob.createPrinterJob();
        if (job != null && (okPageSetup = job.showPageSetupDialog(this.gc.getScene().getWindow())) && (okPrintDialog = job.showPrintDialog(this.gc.getScene().getWindow())) && (success = job.printPage((Node)node))) {
            job.endJob();
        }
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

