/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.gantt;

import com.flexganttfx.demo.FlexGanttFXSample;
import com.flexganttfx.demo.HelloActivity;
import com.flexganttfx.demo.HelloRow;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Layout;
import com.flexganttfx.model.LinesManager;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.layout.EqualLinesManager;
import com.flexganttfx.model.layout.GanttLayout;
import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.ActivityEvent;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.ListViewGraphics;
import com.flexganttfx.view.graphics.renderer.ActivityBarRenderer;
import com.flexganttfx.view.util.AutoLinesManager;
import com.flexganttfx.view.util.Position;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Separator;
import javafx.scene.control.Slider;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class HelloMultiLine
extends FlexGanttFXSample {
    private HelloRow row;
    private EqualLinesManager<HelloRow, HelloActivity> equalLinesManager;
    private AutoLinesManager<HelloRow, HelloActivity> autoLinesManager;
    private RandomLinesManager randomLinesManager;
    private Layer layer;
    private Slider slider;
    private RadioButton equalButton;
    private RadioButton autoButton;
    private RadioButton randomButton;

    @Override
    public String getSampleName() {
        return "Multi Line";
    }

    @Override
    public String getSampleDescription() {
        return "This sample demonstrates how activities can be placed on multiple lines within the same row. Different line managers can be used to place the activities with different strategies.";
    }

    protected GanttChart<?> createGanttChart() throws Exception {
        GanttChart<HelloRow> gc = new GanttChart<HelloRow>();
        ArrayList<Layer> layers = new ArrayList<Layer>();
        this.layer = new Layer("Layer 1");
        layers.add(this.layer);
        gc.getLayers().setAll(layers);
        this.row = new HelloRow("Row");
        this.row.setHeight(400.0);
        this.row.setMaxHeight(2000.0);
        this.row.setMinHeight(30.0);
        this.autoLinesManager = new AutoLinesManager(this.row, gc.getGraphics());
        this.equalLinesManager = new MyEqualLinesManager(this.row);
        this.randomLinesManager = new RandomLinesManager(this.row);
        this.row.setLinesManager(this.autoLinesManager);
        gc.setRoot(this.row);
        ListViewGraphics graphics = gc.getGraphics();
        graphics.setAutoGridEnabled(true);
        graphics.setActivityRenderer(HelloActivity.class, GanttLayout.class, new HelloActivityRenderer(graphics, "Hello Activity Renderer"));
        graphics.setOnActivityChangeFinished((EventHandler<ActivityEvent>)((EventHandler)evt -> this.maybePerformLayout()));
        graphics.setOnActivityDeleted((EventHandler<ActivityEvent>)((EventHandler)evt -> this.maybePerformLayout()));
        this.applyLineCount(25);
        return gc;
    }

    private void maybePerformLayout() {
        if (this.autoButton == null || this.autoButton.isSelected()) {
            this.autoLinesManager.layout();
        }
    }

    @Override
    public Node getControlPanel() {
        VBox box = new VBox();
        box.setSpacing(10.0);
        box.setFillWidth(true);
        this.equalButton = new RadioButton("Equal Lines");
        this.autoButton = new RadioButton("Equal Lines (Auto Layout)");
        this.randomButton = new RadioButton("Random Lines");
        this.equalButton.setTooltip(new Tooltip("Distribute available row height equally to all lines"));
        this.autoButton.setTooltip(new Tooltip("Equal line height, activities non overlapping"));
        this.randomButton.setTooltip(new Tooltip("Randomly place lines and allocate line height"));
        ToggleGroup toggleGroup = new ToggleGroup();
        toggleGroup.getToggles().addAll((Object[])new Toggle[]{this.equalButton, this.autoButton, this.randomButton});
        toggleGroup.selectedToggleProperty().addListener(it -> this.applyLineCount(this.row.getLineCount()));
        toggleGroup.selectedToggleProperty().addListener(it -> this.getGanttChart().getGraphics().showEarliestActivities());
        this.equalButton.setOnAction(evt -> this.applyEqualLinesManager());
        this.autoButton.setOnAction(evt -> this.applyAutoLinesManager());
        this.randomButton.setOnAction(evt -> this.applyRandomLinesManager());
        this.autoButton.setSelected(true);
        Label managerLabel = new Label("Manager");
        managerLabel.setMaxWidth(Double.MAX_VALUE);
        managerLabel.setAlignment(Pos.CENTER);
        managerLabel.setStyle("-fx-font-weight: bold");
        Label sliderLabel = new Label("Number of Lines");
        sliderLabel.setMaxWidth(Double.MAX_VALUE);
        sliderLabel.setAlignment(Pos.CENTER);
        sliderLabel.setStyle("-fx-font-weight: bold");
        this.slider = new Slider(1.0, 100.0, 25.0);
        this.slider.setShowTickLabels(true);
        this.slider.setShowTickMarks(true);
        this.slider.setOrientation(Orientation.VERTICAL);
        this.slider.setPrefHeight(400.0);
        this.slider.setMaxWidth(Double.MAX_VALUE);
        Button apply = new Button("Apply");
        apply.setMaxWidth(Double.MAX_VALUE);
        apply.setOnAction(evt -> this.applyLineCount((int)this.slider.getValue()));
        box.getChildren().addAll((Object[])new Node[]{managerLabel, this.equalButton, this.autoButton, this.randomButton, new Separator(Orientation.HORIZONTAL), sliderLabel, this.slider, apply});
        return box;
    }

    private void applyLineCount(int count) {
        this.row.setLineCount(count);
        LocalDate date = LocalDate.now();
        this.row.clearActivities();
        for (int i = 0; i < 100; ++i) {
            int j = 0;
            while ((double)j < Math.random() * (double)this.row.getLineCount() / 2.0) {
                int duration = Math.max(1, (int)(Math.random() * 10.0));
                LocalTime time = LocalTime.MIN;
                Instant st = ZonedDateTime.of(date, time, ZoneId.systemDefault()).toInstant();
                Instant et = ZonedDateTime.of(date.plusDays(duration), time, ZoneId.systemDefault()).toInstant();
                HelloActivity activity = new HelloActivity();
                activity.setColor(this.randomColor());
                activity.setStartTime(st);
                activity.setEndTime(et);
                activity.setLineIndex((int)(Math.random() * (double)this.row.getLineCount()));
                date = date.plusDays(Math.max(1, (int)(Math.random() * 3.0)));
                this.row.addActivity(this.layer, activity);
                ++j;
            }
        }
        if (this.autoButton == null || this.autoButton.isSelected()) {
            this.maybePerformLayout();
        }
    }

    private Color randomColor() {
        switch ((int)(Math.random() * 6.0)) {
            case 0: {
                return Color.LIGHTBLUE;
            }
            case 1: {
                return Color.LIGHTCYAN;
            }
            case 2: {
                return Color.LIGHTCORAL;
            }
            case 3: {
                return Color.LIGHTGOLDENRODYELLOW;
            }
            case 4: {
                return Color.LIGHTSALMON;
            }
            case 5: {
                return Color.LIGHTSEAGREEN;
            }
            case 6: {
                return Color.LIGHTSKYBLUE;
            }
            case 7: {
                return Color.LIGHTSTEELBLUE;
            }
            case 8: {
                return Color.LIGHTYELLOW;
            }
        }
        return Color.LIGHTGRAY;
    }

    private void applyRandomLinesManager() {
        this.row.setLinesManager(this.randomLinesManager);
    }

    private void applyEqualLinesManager() {
        this.row.setLinesManager(this.equalLinesManager);
    }

    private void applyAutoLinesManager() {
        this.row.setLinesManager(this.autoLinesManager);
    }

    public static void main(String[] args) {
        HelloMultiLine.launch((String[])args);
    }

    class HelloActivityRenderer
    extends ActivityBarRenderer<HelloActivity> {
        public HelloActivityRenderer(GraphicsBase<?> graphics, String name) {
            super(graphics, name);
            this.setCornersRounded(false);
            this.setBarHeight(20.0);
        }

        @Override
        protected ActivityBounds drawActivity(ActivityRef<HelloActivity> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
            HelloActivity activity = activityRef.getActivity();
            this.setFill((Paint)activity.getColor().darker());
            this.setStroke((Paint)activity.getColor().darker().darker());
            Row<?, ?, HelloActivity> row = activityRef.getRow();
            LinesManager<HelloActivity> manager = row.getLinesManager();
            int lineIndex = manager.getLineIndex(activity);
            if (lineIndex != -1) {
                double lineHeight = manager.getLineHeight(lineIndex, row.getHeight());
                this.setBarHeight(lineHeight * 0.8);
            } else {
                this.setBarHeight(16.0);
            }
            return super.drawActivity(activityRef, position, gc, x, y, w, h, selected, hover, highlighted, pressed);
        }
    }

    class RandomLinesManager
    implements LinesManager<HelloActivity> {
        private HelloRow row;
        private double[] locations;
        private double[] heights;
        private GanttLayout layout;

        public RandomLinesManager(HelloRow row) {
            this.row = row;
            this.layout = new GanttLayout();
            row.lineCountProperty().addListener(it -> this.update());
        }

        private void update() {
            int count = this.row.getLineCount();
            this.heights = new double[count];
            this.locations = new double[count];
            for (int i = 0; i < count; ++i) {
                this.heights[i] = Math.random() * this.row.getHeight() / 2.0;
                this.locations[i] = Math.min(this.row.getHeight() - this.heights[i], Math.random() * this.row.getHeight());
            }
        }

        @Override
        public int getLineIndex(HelloActivity activity) {
            return activity.getLineIndex();
        }

        @Override
        public double getLineLocation(int lineIndex, double rowHeight) {
            return this.locations[lineIndex];
        }

        @Override
        public double getLineHeight(int lineIndex, double rowHeight) {
            return this.heights[lineIndex];
        }

        @Override
        public Layout getLineLayout(int lineIndex) {
            return this.layout;
        }
    }

    class MyEqualLinesManager
    extends EqualLinesManager<HelloRow, HelloActivity> {
        public MyEqualLinesManager(HelloRow row) {
            super(row);
        }

        @Override
        public int getLineIndex(HelloActivity activity) {
            return activity.getLineIndex();
        }
    }
}

