/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.gantt;

import com.flexganttfx.demo.FlexGanttFXSampleBase;
import com.flexganttfx.demo.HelloActivity;
import com.flexganttfx.demo.HelloRow;
import com.flexganttfx.model.layout.GanttLayout;
import com.flexganttfx.view.graphics.ActivityEvent;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.LassoEvent;
import com.flexganttfx.view.graphics.ListViewGraphics;
import com.flexganttfx.view.graphics.SingleRowGraphics;
import com.flexganttfx.view.graphics.SplitPaneGraphics;
import com.flexganttfx.view.graphics.VBoxGraphics;
import com.flexganttfx.view.graphics.renderer.ActivityBarRenderer;
import com.flexganttfx.view.timeline.Timeline;
import java.util.ArrayList;
import javafx.application.Application;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.TextArea;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.MasterDetailPane;

public class HelloGraphicsView
extends FlexGanttFXSampleBase {
    private static final boolean DEBUG_MODE = false;
    private Region singleRowNode;
    private Region listViewNode;
    private Region vBoxNode;
    private Region splitPaneNode;
    private TextArea textArea;
    private HelloRow singleRow;
    private VBoxGraphics<HelloRow> vboxGraphics;

    @Override
    public Node getControlPanel() {
        RadioButton singleRowButton = new RadioButton("Single Row");
        RadioButton listViewButton = new RadioButton("ListView");
        RadioButton vBoxButton = new RadioButton("VBox");
        RadioButton splitPaneButton = new RadioButton("SplitPane");
        ToggleGroup toggleGroup = new ToggleGroup();
        toggleGroup.getToggles().addAll((Object[])new Toggle[]{singleRowButton, listViewButton, vBoxButton, splitPaneButton});
        singleRowButton.setSelected(true);
        ComboBox prioBox = new ComboBox();
        prioBox.getItems().setAll((Object[])PriorityStrategy.values());
        prioBox.setValue((Object)PriorityStrategy.ALL);
        prioBox.setOnAction(evt -> this.updatePriorityStrategy((PriorityStrategy)((Object)((Object)prioBox.getValue()))));
        prioBox.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)vBoxButton.selectedProperty()));
        BorderPane priBoxPane = new BorderPane();
        priBoxPane.setCenter((Node)prioBox);
        Label label = new Label("VBox Grow Priority:");
        BorderPane.setMargin((Node)label, (Insets)new Insets(0.0, 6.0, 0.0, 0.0));
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        BorderPane.setAlignment((Node)prioBox, (Pos)Pos.CENTER_RIGHT);
        priBoxPane.setLeft((Node)label);
        Slider heightSlider = new Slider(0.0, 1000.0, 24.0);
        heightSlider.valueProperty().addListener(evt -> this.updateRowHeight(heightSlider.getValue()));
        heightSlider.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)singleRowButton.selectedProperty()));
        BorderPane sliderPane = new BorderPane();
        sliderPane.setCenter((Node)heightSlider);
        sliderPane.setLeft((Node)new Label("Row Height:"));
        singleRowButton.setOnAction(evt -> this.singleRowNode.toFront());
        listViewButton.setOnAction(evt -> this.listViewNode.toFront());
        vBoxButton.setOnAction(evt -> this.vBoxNode.toFront());
        splitPaneButton.setOnAction(evt -> this.splitPaneNode.toFront());
        VBox.setMargin((Node)sliderPane, (Insets)new Insets(0.0, 0.0, 0.0, 40.0));
        VBox.setMargin((Node)priBoxPane, (Insets)new Insets(0.0, 0.0, 0.0, 40.0));
        VBox controlPanel = new VBox();
        controlPanel.setFillWidth(false);
        controlPanel.getChildren().addAll((Object[])new Node[]{singleRowButton, sliderPane, listViewButton, vBoxButton, priBoxPane, splitPaneButton});
        controlPanel.setSpacing(10.0);
        return controlPanel;
    }

    private void updateRowHeight(double value) {
        this.singleRow.setHeight(value);
    }

    private void updatePriorityStrategy(PriorityStrategy value) {
        switch (value) {
            case ALL: {
                this.vboxGraphics.setPriorityCallback((Callback<HelloRow, Priority>)((Callback)param -> Priority.ALWAYS));
                break;
            }
            case NONE: {
                this.vboxGraphics.setPriorityCallback((Callback<HelloRow, Priority>)((Callback)param -> Priority.NEVER));
                break;
            }
            case RANDOM: {
                this.vboxGraphics.setPriorityCallback((Callback<HelloRow, Priority>)((Callback)param -> {
                    if (Math.random() < 0.5) {
                        return Priority.NEVER;
                    }
                    return Priority.ALWAYS;
                }));
                break;
            }
        }
    }

    @Override
    public Node getPanel(Stage stage) {
        MasterDetailPane masterDetailPane = new MasterDetailPane(Side.BOTTOM);
        StackPane stackPane = new StackPane();
        this.singleRowNode = this.createGraphicsSingleRowView();
        this.listViewNode = this.createGraphicsListView();
        this.vBoxNode = this.createGraphicsVBox();
        this.splitPaneNode = this.createGraphicsSplitPane();
        stackPane.getChildren().addAll((Object[])new Node[]{this.listViewNode, this.vBoxNode, this.splitPaneNode, this.singleRowNode});
        masterDetailPane.setMasterNode((Node)stackPane);
        this.textArea = new TextArea();
        this.textArea.setWrapText(true);
        masterDetailPane.setDetailNode((Node)this.textArea);
        return masterDetailPane;
    }

    private void info(Object object) {
        this.textArea.appendText("Incoming: " + object.getClass().getSimpleName());
        this.textArea.appendText(System.getProperty("line.separator"));
        this.textArea.appendText(System.getProperty("line.separator"));
        this.textArea.appendText(object.toString());
        this.textArea.appendText(System.getProperty("line.separator"));
        this.textArea.appendText("------------------");
        this.textArea.appendText(System.getProperty("line.separator"));
    }

    private Region createGraphicsSingleRowView() {
        Timeline timeline = new Timeline();
        SingleRowGraphics graphics = new SingleRowGraphics();
        graphics.setTimeline(timeline);
        graphics.setOnLassoSelection((EventHandler<LassoEvent>)((EventHandler)evt -> this.info(evt)));
        graphics.setOnActivityChange((EventHandler<ActivityEvent>)((EventHandler)evt -> this.info(evt)));
        graphics.setActivityRenderer(HelloActivity.class, GanttLayout.class, new ActivityBarRenderer(graphics, "HelloActivityRenderer"));
        graphics.getLayers().add((Object)HelloRow.layer);
        graphics.setDebugMode(false);
        this.singleRow = new HelloRow("Row", 100);
        graphics.getRows().setAll((Object[])new HelloRow[]{this.singleRow});
        VBox box = new VBox();
        box.getChildren().add((Object)timeline);
        box.getChildren().add(graphics);
        box.setStyle("-fx-background-color: gray;");
        return box;
    }

    private Region createGraphicsListView() {
        Timeline timeline = new Timeline();
        ListViewGraphics graphics = new ListViewGraphics();
        graphics.setTimeline(timeline);
        graphics.setDebugMode(false);
        graphics.setActivityRenderer(HelloActivity.class, GanttLayout.class, new ActivityBarRenderer(graphics, "HelloActivityRenderer"));
        graphics.getLayers().add((Object)HelloRow.layer);
        graphics.setOnLassoSelection((EventHandler<LassoEvent>)((EventHandler)evt -> this.info(evt)));
        graphics.setOnActivityChange((EventHandler<ActivityEvent>)((EventHandler)evt -> this.info(evt)));
        ArrayList<HelloRow> rows = new ArrayList<HelloRow>();
        for (int i = 0; i < 100; ++i) {
            HelloRow row = new HelloRow("Row " + i, 10);
            rows.add(row);
        }
        graphics.getRows().setAll(rows);
        BorderPane borderPane = new BorderPane();
        borderPane.setTop((Node)timeline);
        borderPane.setCenter(graphics);
        borderPane.setStyle("-fx-background-color: gray;");
        return borderPane;
    }

    private Region createGraphicsVBox() {
        Timeline timeline = new Timeline();
        this.vboxGraphics = new VBoxGraphics();
        this.vboxGraphics.setDebugMode(false);
        this.vboxGraphics.setOnLassoSelection((EventHandler<LassoEvent>)((EventHandler)evt -> this.textArea.appendText(evt.toString())));
        this.vboxGraphics.setOnActivityChange((EventHandler<ActivityEvent>)((EventHandler)evt -> this.info(evt)));
        this.vboxGraphics.setTimeline(timeline);
        this.vboxGraphics.setActivityRenderer(HelloActivity.class, GanttLayout.class, new ActivityBarRenderer(this.vboxGraphics, "HelloActivityRenderer"));
        this.vboxGraphics.getLayers().add((Object)HelloRow.layer);
        ArrayList<HelloRow> rows = new ArrayList<HelloRow>();
        for (int i = 0; i < 5; ++i) {
            HelloRow row = new HelloRow("Row " + i, 10);
            rows.add(row);
        }
        this.vboxGraphics.getRows().setAll(rows);
        BorderPane borderPane = new BorderPane();
        borderPane.setTop((Node)timeline);
        borderPane.setCenter(this.vboxGraphics);
        borderPane.setStyle("-fx-background-color: gray;");
        return borderPane;
    }

    private Region createGraphicsSplitPane() {
        Timeline timeline = new Timeline();
        SplitPaneGraphics graphics = new SplitPaneGraphics();
        graphics.getSplitPane().setDividerPositions(new double[]{0.2, 0.4, 0.6, 0.8});
        graphics.setOnLassoSelection((EventHandler<LassoEvent>)((EventHandler)evt -> this.info(evt)));
        graphics.setOnActivityChange((EventHandler<ActivityEvent>)((EventHandler)evt -> this.info(evt)));
        graphics.setDebugMode(false);
        graphics.setTimeline(timeline);
        graphics.setActivityRenderer(HelloActivity.class, GanttLayout.class, new ActivityBarRenderer(graphics, "HelloActivityRenderer"));
        graphics.getLayers().add((Object)HelloRow.layer);
        ArrayList<HelloRow> rows = new ArrayList<HelloRow>();
        for (int i = 0; i < 5; ++i) {
            HelloRow row = new HelloRow("Row " + i, 10);
            rows.add(row);
        }
        graphics.getRows().setAll(rows);
        BorderPane borderPane = new BorderPane();
        borderPane.setTop((Node)timeline);
        borderPane.setCenter(graphics);
        borderPane.setStyle("-fx-background-color: gray;");
        return borderPane;
    }

    @Override
    public String getSampleDescription() {
        return "The GraphicsView is the control responsible for the graphical display of activities. This view is used as a sub-control of the GanttChart class but can also be used standalone. Four different graphic view types are available: single row, list, box, split pane.";
    }

    @Override
    public String getSampleName() {
        return "Graphics View";
    }

    @Override
    public String getControlStylesheetURL() {
        return "/" + GraphicsBase.class.getPackage().getName().replace('.', '/') + "/graphics.css";
    }

    @Override
    public String getJavaDocURL() {
        return this.getJavaDocBase() + "com/flexganttfx/view/graphics/GraphicsBase.html";
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    static enum PriorityStrategy {
        ALL,
        NONE,
        RANDOM;

    }
}

