/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.gantt;

import com.flexganttfx.demo.FlexGanttFXSample;
import com.flexganttfx.demo.HelloRow;
import com.flexganttfx.extras.properties.view.GanttChartConfigurationView;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.calendar.CalendarBase;
import com.flexganttfx.model.calendar.MutableCalendarActivityBase;
import com.flexganttfx.model.dateline.ChronoUnitGrid;
import com.flexganttfx.model.layout.GanttLayout;
import com.flexganttfx.model.repository.RepositoryEvent;
import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.LassoEvent;
import com.flexganttfx.view.graphics.layer.CalendarLayer;
import com.flexganttfx.view.graphics.renderer.ActivityRenderer;
import com.flexganttfx.view.graphics.renderer.CalendarActivityRenderer;
import com.flexganttfx.view.timeline.Eventline;
import com.flexganttfx.view.timeline.Timeline;
import com.flexganttfx.view.util.Position;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javafx.application.Application;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.TextInputDialog;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;

public class HelloGlobalActivities
extends FlexGanttFXSample {
    private GanttChart<HelloRow> gc = new GanttChart();
    private EventlineCalendar calendar = new EventlineCalendar();
    private Layer layer = new Layer("Default Layer");
    private PhaseRow frozenRow = new PhaseRow();
    private ChronoUnitGrid dayGrid = new ChronoUnitGrid("Day Grid", ChronoUnit.DAYS, 1);
    private final ObjectProperty<Paint> phaseColor = new SimpleObjectProperty((Object)Color.ORANGE);
    private final ObjectProperty<Paint> phaseTextColor = new SimpleObjectProperty((Object)Color.WHITE);

    protected GanttChart<?> createGanttChart() {
        this.gc.setRoot(new HelloRow("root"));
        Timeline timeline = this.gc.getTimeline();
        Eventline eventline = timeline.getEventline();
        eventline.setShowFrozenRow(true);
        eventline.setFrozenRow(this.frozenRow);
        this.gc.getGraphics().getCalendars().add((Object)this.calendar);
        eventline.getGraphics().getLayers().add((Object)this.layer);
        eventline.getGraphics().setVirtualGrid(this.dayGrid);
        eventline.getGraphics().setOnLassoSelectionFinished((EventHandler<LassoEvent>)((EventHandler)evt -> {
            LassoEvent.LassoInfo info = evt.getInfo();
            Instant st = info.getStartTime();
            Instant et = info.getEndTime();
            TextInputDialog dialog = new TextInputDialog("New Phase");
            dialog.setTitle("Phase Name");
            dialog.setHeaderText("Phase Name");
            dialog.setContentText("Enter a name for the new phase.");
            Optional nameOptional = dialog.showAndWait();
            if (nameOptional.isPresent()) {
                this.addPhase((String)nameOptional.get(), st, et);
            }
        }));
        CalendarLayer calendarLayer = this.gc.getGraphics().getSystemLayer(CalendarLayer.class);
        calendarLayer.setCalendarActivityRenderer(Phase.class, new PhaseCalendarActivityRenderer(this.gc.getGraphics()));
        eventline.getGraphics().setActivityRenderer(Phase.class, GanttLayout.class, new PhaseActivityRenderer(eventline.getGraphics()));
        this.addPhase("Design", Instant.now().plus(1L, ChronoUnit.DAYS), Instant.now().plus(5L, ChronoUnit.DAYS));
        this.addPhase("Implementation", Instant.now().plus(8L, ChronoUnit.DAYS), Instant.now().plus(16L, ChronoUnit.DAYS));
        this.addPhase("Testing", Instant.now().plus(19L, ChronoUnit.DAYS), Instant.now().plus(25L, ChronoUnit.DAYS));
        GanttChartConfigurationView view = (GanttChartConfigurationView)this.getControlPanel();
        view.update();
        return this.gc;
    }

    @Override
    public Node getControlPanel() {
        return new GanttChartConfigurationView(this.gc);
    }

    private void addPhase(String title, Instant st, Instant et) {
        st = this.dayGrid.adjustTime(st, ZoneId.systemDefault(), true, DayOfWeek.MONDAY);
        et = this.dayGrid.adjustTime(et, ZoneId.systemDefault(), true, DayOfWeek.MONDAY);
        Phase phase = new Phase(title);
        phase.setStartTime(st);
        phase.setEndTime(et);
        this.frozenRow.addActivity(this.layer, phase);
        this.calendar.addPhase(phase);
    }

    @Override
    public String getSampleName() {
        return "Global Activities";
    }

    @Override
    public String getJavaDocURL() {
        return this.getJavaDocBase() + "com/flexganttfx/view/timeline/Eventline.html";
    }

    @Override
    public String getSampleDescription() {
        return "This demo shows how the graphics node inside the eventline can be used to display global events. To add your own event, simply use the lasso inside the eventline (press and wait or SHIFT and drag).";
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    class Phase
    extends MutableCalendarActivityBase<String> {
        public Phase(String name) {
            super(name);
        }
    }

    class PhaseRow
    extends Row<PhaseRow, PhaseRow, Phase> {
        PhaseRow() {
        }
    }

    class EventlineCalendar
    extends CalendarBase<Phase> {
        private List<Phase> phases;

        protected EventlineCalendar() {
            super("Eventline Calendar");
            this.phases = new ArrayList<Phase>();
        }

        @Override
        public Iterator<Phase> getActivities(Layer layer, Instant startTime, Instant endTime, TemporalUnit temporalUnit, ZoneId zoneId) {
            return this.phases.iterator();
        }

        public void addPhase(Phase phase) {
            this.phases.add(phase);
            this.fireEvent(new RepositoryEvent(this));
        }
    }

    class PhaseCalendarActivityRenderer
    extends CalendarActivityRenderer {
        public PhaseCalendarActivityRenderer(GraphicsBase graphics) {
            super(graphics, "Phase Calendar Renderer");
            this.strokeProperty().bindBidirectional((Property)HelloGlobalActivities.this.phaseColor);
        }

        @Override
        protected ActivityBounds drawActivity(ActivityRef activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
            gc.setStroke(this.getStroke());
            gc.setLineWidth(2.0);
            gc.strokeLine(x, 0.0, x, h);
            return null;
        }
    }

    class PhaseActivityRenderer
    extends ActivityRenderer {
        public PhaseActivityRenderer(GraphicsBase graphics) {
            super(graphics, "Phase Activity Renderer");
            this.fillProperty().bindBidirectional((Property)HelloGlobalActivities.this.phaseColor);
            this.setStroke((Paint)Color.TRANSPARENT);
        }

        protected ActivityBounds drawActivity(ActivityRef activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
            ActivityBounds bounds = super.drawActivity(activityRef, position, gc, x, y, w, h, selected, hover, highlighted, pressed);
            Phase phase = (Phase)activityRef.getActivity();
            String name = phase.getName();
            gc.setTextAlign(TextAlignment.LEFT);
            gc.setTextBaseline(VPos.BOTTOM);
            gc.setFill((Paint)HelloGlobalActivities.this.phaseTextColor.get());
            gc.fillText(name, x + 2.0, h);
            return bounds;
        }
    }
}

