/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.gantt;

import com.flexganttfx.demo.FlexGanttFXSampleBase;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.activity.MutableActivityBase;
import com.flexganttfx.model.dateline.ChronoUnitGrid;
import com.flexganttfx.model.dateline.VirtualGrid;
import com.flexganttfx.model.layout.GanttLayout;
import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.container.DualGanttChartContainer;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.ActivityEvent;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.ListViewGraphics;
import com.flexganttfx.view.graphics.renderer.ActivityRenderer;
import com.flexganttfx.view.util.Position;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.util.Callback;

public class HelloDragAndDrop
extends FlexGanttFXSampleBase {
    private TableView<Order> orderTable = new TableView();
    private TableView<Person> personTable = new TableView();
    private GanttChart<Resource> gantt1 = new GanttChart();
    private GanttChart<Resource> gantt2 = new GanttChart();
    private DualGanttChartContainer dualContainer;
    private TextArea textDropArea = new TextArea();
    private TextArea textEventsArea = new TextArea();
    private DragInfoPane dragInfoPane = new DragInfoPane();
    private Map<String, Order> orders = new HashMap<String, Order>();
    private Map<String, Person> people = new HashMap<String, Person>();
    private Layer layer = new Layer("Orders");

    public HelloDragAndDrop() {
        this.setupOrderTable();
        this.setupPersonTable();
        this.setupGantt();
        this.setupTextDropArea();
        this.setupTextEventsArea();
    }

    @Override
    public Node getControlPanel() {
        VBox box = new VBox();
        box.setSpacing(10.0);
        box.getChildren().add((Object)this.dragInfoPane);
        box.getChildren().add((Object)new TitledPane("Upper Gantt", (Node)new DragSettings(this.gantt1.getGraphics())));
        box.getChildren().add((Object)new TitledPane("Lower Gantt", (Node)new DragSettings(this.gantt2.getGraphics())));
        return box;
    }

    @Override
    public String getSampleDescription() {
        return "This sample highlights various aspects of the drag and drop support that is built into FlexGanttFX. The user can drag elements from the tables to the Gantt chart and also (by pressing SHIFT) from the Gantt chart to the text area on the right-hand side. At the same time the text area at the bottom shows the events that are being generated while dragging.";
    }

    private void setupOrderTable() {
        TableColumn nameColumn = new TableColumn("Order");
        TableColumn startColumn = new TableColumn("Start");
        TableColumn endColumn = new TableColumn("Finish");
        TableColumn priorityColumn = new TableColumn("Priority");
        nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("title"));
        startColumn.setCellValueFactory((Callback)new PropertyValueFactory("startDate"));
        endColumn.setCellValueFactory((Callback)new PropertyValueFactory("endDate"));
        priorityColumn.setCellValueFactory((Callback)new PropertyValueFactory("priority"));
        nameColumn.setPrefWidth(200.0);
        startColumn.setPrefWidth(100.0);
        endColumn.setPrefWidth(100.0);
        priorityColumn.setPrefWidth(100.0);
        this.orderTable.getColumns().add((Object)nameColumn);
        this.orderTable.getColumns().add((Object)startColumn);
        this.orderTable.getColumns().add((Object)endColumn);
        this.orderTable.getColumns().add((Object)priorityColumn);
        ArrayList<Order> list = new ArrayList<Order>();
        for (int i = 0; i < 40; ++i) {
            Order order = new Order("Order #" + (i + 1));
            LocalDate start = LocalDate.now().plusDays(2 + (int)(Math.random() * 10.0));
            LocalDate end = start.plusDays(5 + (int)(Math.random() * 10.0));
            order.setStartDate(start);
            order.setEndDate(end);
            order.setPriority(Priority.values()[(int)(Math.random() * 3.0)]);
            list.add(order);
            this.orders.put(order.getTitle(), order);
        }
        this.orderTable.getItems().setAll(list);
        this.orderTable.setOnDragDetected(evt -> this.dragDetectedOrderTable((MouseEvent)evt));
        this.orderTable.setOnDragDone(evt -> this.dragDoneOrderTable((DragEvent)evt));
    }

    private void setupPersonTable() {
        TableColumn nameColumn = new TableColumn("Person");
        nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        nameColumn.setPrefWidth(200.0);
        this.personTable.getColumns().add((Object)nameColumn);
        ArrayList<Person> list = new ArrayList<Person>();
        for (int i = 0; i < 10; ++i) {
            Person person = new Person("Person #" + (i + 1));
            list.add(person);
            this.people.put(person.getName(), person);
        }
        this.personTable.getItems().setAll(list);
        this.personTable.setOnDragDetected(evt -> this.dragDetectedPersonTable((MouseEvent)evt));
    }

    private void dragDetectedOrderTable(MouseEvent evt) {
        Dragboard db = this.orderTable.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
        ClipboardContent content = new ClipboardContent();
        content.putString("order:" + ((Order)this.orderTable.getSelectionModel().getSelectedItem()).getTitle());
        db.setContent((Map)content);
    }

    private void dragDoneOrderTable(DragEvent evt) {
        String title = evt.getDragboard().getString();
        StringTokenizer st = new StringTokenizer(title, ":");
        st.nextToken();
        Order order = this.orders.get(st.nextToken());
        this.orderTable.getItems().remove((Object)order);
    }

    private void dragDetectedPersonTable(MouseEvent evt) {
        Dragboard db = this.personTable.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
        ClipboardContent content = new ClipboardContent();
        content.putString("person:" + ((Person)this.personTable.getSelectionModel().getSelectedItem()).getName());
        db.setContent((Map)content);
    }

    private void setupGantt() {
        int i;
        ArrayList<Resource> resources1 = new ArrayList<Resource>();
        ArrayList<Resource> resources2 = new ArrayList<Resource>();
        for (i = 0; i < 40; ++i) {
            Resource resource1 = new Resource("Resource A" + (i + 1));
            resources1.add(resource1);
        }
        for (i = 0; i < 3; ++i) {
            Resource resource2 = new Resource("Resource B" + (i + 1));
            resource2.setHeight(24.0);
            resources2.add(resource2);
        }
        Resource root1 = new Resource("Root 1");
        root1.getChildren().setAll(resources1);
        root1.setExpanded(true);
        Resource root2 = new Resource("Root 2");
        root2.getChildren().setAll(resources2);
        root2.setExpanded(true);
        this.gantt1.getTimeline().getModel().setHorizonStartTime(Instant.now());
        this.gantt1.getLayers().add((Object)this.layer);
        this.gantt2.getLayers().add((Object)this.layer);
        this.gantt1.getTreeTable().setShowRoot(false);
        this.gantt2.getTreeTable().setShowRoot(false);
        this.gantt1.setRoot(root1);
        this.gantt2.setRoot(root2);
        ListViewGraphics graphics1 = this.gantt1.getGraphics();
        graphics1.setDragAndDropFeedback(GraphicsBase.DragAndDropFeedback.RENDERED_GRID_SNAPPED);
        graphics1.setAutoGridEnabled(true);
        graphics1.setOnDragOver(evt -> this.dragOver((DragEvent)evt));
        graphics1.setOnDragDropped(evt -> this.dragDropped((DragEvent)evt));
        graphics1.setActivityRenderer(OrderAssignment.class, GanttLayout.class, new OrderAssignmentRenderer(graphics1));
        graphics1.dragAndDropInfoProperty().addListener(it -> this.updateDragAndDropInfo(graphics1.getDragAndDropInfo()));
        graphics1.dragAndDropInfoProperty().addListener(evt -> this.dragInfoPane.setInfo(graphics1.getDragAndDropInfo()));
        ListViewGraphics graphics2 = this.gantt2.getGraphics();
        graphics2.setOnDragOver(evt -> this.dragOver((DragEvent)evt));
        graphics2.setOnDragDropped(evt -> this.dragDropped((DragEvent)evt));
        graphics2.setActivityRenderer(OrderAssignment.class, GanttLayout.class, new OrderAssignmentRenderer(graphics1));
        graphics2.dragAndDropInfoProperty().addListener(it -> this.updateDragAndDropInfo(graphics2.getDragAndDropInfo()));
        graphics2.dragAndDropInfoProperty().addListener(evt -> this.dragInfoPane.setInfo(graphics2.getDragAndDropInfo()));
        this.dualContainer = new DualGanttChartContainer(this.gantt1, this.gantt2);
    }

    private void dragOver(DragEvent evt) {
        evt.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
    }

    private void dragDropped(DragEvent evt) {
        evt.acceptTransferModes(TransferMode.ANY);
        if (evt.getTarget() instanceof RowCanvas) {
            RowCanvas canvas = (RowCanvas)evt.getTarget();
            GraphicsBase graphics = canvas.getGraphics();
            Resource resource = (Resource)graphics.getRowAt(evt.getY());
            String dragString = evt.getDragboard().getString();
            if (dragString != null) {
                if (dragString.startsWith("order")) {
                    StringTokenizer st = new StringTokenizer(dragString, ":");
                    st.nextToken();
                    Order order = this.orders.get(st.nextToken());
                    OrderAssignment assignment = new OrderAssignment(order);
                    resource.addActivity(this.layer, assignment);
                } else if (dragString.startsWith("person")) {
                    Object activity;
                    StringTokenizer st = new StringTokenizer(dragString, ":");
                    st.nextToken();
                    Person person = this.people.get(st.nextToken());
                    ActivityRef<?> ref = graphics.getActivityRefAt(evt.getX(), evt.getY());
                    if (ref != null && (activity = ref.getActivity()) instanceof OrderAssignment) {
                        OrderAssignment assignment = (OrderAssignment)activity;
                        assignment.setPerson(person);
                        graphics.redraw();
                    }
                }
            }
        }
        evt.consume();
    }

    private void setupTextDropArea() {
        SplitPane.setResizableWithParent((Node)this.textDropArea, (Boolean)false);
        this.textDropArea.setPromptText("Drop items here, too!");
        this.textDropArea.setOnDragOver(evt -> this.dragOverOnTextArea((DragEvent)evt));
        this.textDropArea.setOnDragDropped(evt -> this.dragDroppedOnTextArea((DragEvent)evt));
    }

    private void dragOverOnTextArea(DragEvent evt) {
        evt.acceptTransferModes(TransferMode.ANY);
    }

    private void dragDroppedOnTextArea(DragEvent evt) {
        evt.acceptTransferModes(TransferMode.ANY);
        this.textDropArea.appendText(evt.getDragboard().getString());
        this.textDropArea.appendText(System.getProperty("line.separator"));
        this.textDropArea.appendText(System.getProperty("line.separator"));
        evt.consume();
    }

    private void setupTextEventsArea() {
        this.textEventsArea.setPromptText("Events...");
        this.gantt1.getGraphics().setOnActivityChange((EventHandler<ActivityEvent>)((EventHandler)evt -> {
            this.textEventsArea.appendText("Gantt 1: " + evt.toString());
            this.textEventsArea.appendText(System.getProperty("line.separator"));
        }));
        this.gantt2.getGraphics().setOnActivityChange((EventHandler<ActivityEvent>)((EventHandler)evt -> {
            this.textEventsArea.appendText("Gantt 2: " + evt.toString());
            this.textEventsArea.appendText(System.getProperty("line.separator"));
        }));
    }

    private void updateDragAndDropInfo(GraphicsBase.DragAndDropInfo info) {
        if (info != null) {
            // empty if block
        }
    }

    @Override
    public String getSampleName() {
        return "Drag & Drop";
    }

    @Override
    public Node getPanel(Stage stage) {
        SplitPane horizontalSplit = new SplitPane();
        horizontalSplit.setOrientation(Orientation.HORIZONTAL);
        horizontalSplit.getItems().addAll((Object[])new Node[]{this.orderTable, this.personTable});
        SplitPane lowerSplit = new SplitPane();
        lowerSplit.setOrientation(Orientation.HORIZONTAL);
        lowerSplit.getItems().addAll((Object[])new Node[]{this.dualContainer, this.textDropArea});
        lowerSplit.setDividerPositions(new double[]{0.8});
        this.textDropArea.setPrefWidth(200.0);
        SplitPane verticalSplit = new SplitPane();
        verticalSplit.setOrientation(Orientation.VERTICAL);
        verticalSplit.setDividerPositions(new double[]{0.2, 0.9});
        verticalSplit.getItems().addAll((Object[])new Node[]{horizontalSplit, lowerSplit, this.textEventsArea});
        return verticalSplit;
    }

    public static void main(String[] args) {
        HelloDragAndDrop.launch((String[])args);
    }

    class DragInfoPane
    extends GridPane {
        private TextField activityField = new TextField();
        private TextField rowField = new TextField();
        private TextField transferModeField = new TextField();
        private DatePicker startTimeField = new DatePicker();
        private DatePicker endTimeField = new DatePicker();

        public DragInfoPane() {
            this.setHgap(5.0);
            this.setVgap(5.0);
            Label activityLabel = new Label("Activity:");
            Label rowLabel = new Label("Row:");
            Label transferModeLabel = new Label("Mode:");
            Label startTimeLabel = new Label("Start:");
            Label endTimeLabel = new Label("End:");
            this.add((Node)activityLabel, 0, 0);
            this.add((Node)rowLabel, 0, 1);
            this.add((Node)transferModeLabel, 0, 2);
            this.add((Node)startTimeLabel, 0, 3);
            this.add((Node)endTimeLabel, 0, 4);
            this.add((Node)this.activityField, 1, 0);
            this.add((Node)this.rowField, 1, 1);
            this.add((Node)this.transferModeField, 1, 2);
            this.add((Node)this.startTimeField, 1, 3);
            this.add((Node)this.endTimeField, 1, 4);
            this.startTimeField.setEditable(false);
            this.endTimeField.setEditable(false);
        }

        public void setInfo(GraphicsBase.DragAndDropInfo info) {
            if (info != null) {
                this.activityField.setText(info.getActivityBounds().getActivity().getName());
                if (info.getRow() != null) {
                    this.rowField.setText(info.getRow().getName());
                } else {
                    this.rowField.setText("<No Row>");
                }
                TransferMode transferMode = info.getDragEvent().getTransferMode();
                if (transferMode != null) {
                    this.transferModeField.setText(transferMode.toString());
                } else {
                    this.transferModeField.setText("NONE");
                }
                this.startTimeField.setValue((Object)ZonedDateTime.ofInstant(info.getDropInterval().getStartTime(), ZoneId.systemDefault()).toLocalDate());
                this.endTimeField.setValue((Object)ZonedDateTime.ofInstant(info.getDropInterval().getEndTime(), ZoneId.systemDefault()).toLocalDate());
            } else {
                this.activityField.setText("");
                this.rowField.setText("");
                this.transferModeField.setText("");
                this.startTimeField.setValue(null);
                this.endTimeField.setValue(null);
            }
        }
    }

    public class Resource
    extends Row<Resource, Resource, OrderAssignment> {
        public Resource(String name) {
            super(name);
            this.setHeight(50.0);
        }
    }

    class OrderAssignmentRenderer
    extends ActivityRenderer<OrderAssignment> {
        public OrderAssignmentRenderer(GraphicsBase<?> graphics) {
            super(graphics, "Order Assignments");
        }

        @Override
        protected ActivityBounds drawActivity(ActivityRef<OrderAssignment> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
            OrderAssignment assignment = activityRef.getActivity();
            switch (((Order)assignment.getUserObject()).getPriority()) {
                case LOW: {
                    this.setFill((Paint)Color.LIGHTGREEN);
                    break;
                }
                case MEDIUM: {
                    this.setFill((Paint)Color.YELLOW);
                    break;
                }
                case HIGH: {
                    this.setFill((Paint)Color.RED);
                }
            }
            ActivityBounds bounds = super.drawActivity(activityRef, position, gc, x, y, w, h, selected, hover, highlighted, pressed);
            Person person = assignment.getPerson();
            if (person != null) {
                gc.setTextAlign(TextAlignment.LEFT);
                gc.setTextBaseline(VPos.CENTER);
                gc.setFill(this.getStroke());
                gc.fillText(person.getName(), x + 4.0, y + h / 2.0);
            }
            return bounds;
        }
    }

    public class OrderAssignment
    extends MutableActivityBase<Order> {
        private Person person;

        public OrderAssignment(Order order) {
            super(order.getTitle());
            this.setUserObject(order);
            this.setStartTime(ZonedDateTime.of(order.getStartDate(), LocalTime.MIN, ZoneId.systemDefault()).toInstant());
            this.setEndTime(ZonedDateTime.of(order.getEndDate(), LocalTime.MAX, ZoneId.systemDefault()).toInstant());
        }

        public void setPerson(Person person) {
            this.person = person;
        }

        public Person getPerson() {
            return this.person;
        }
    }

    public class Person {
        private String name;

        public Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public class Order {
        private String title;
        private LocalDate startDate = LocalDate.now();
        private LocalDate endDate = LocalDate.now().plusWeeks(1L);
        private Priority priority;

        public Order(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public void setStartDate(LocalDate startDate) {
            this.startDate = startDate;
        }

        public LocalDate getStartDate() {
            return this.startDate;
        }

        public void setEndDate(LocalDate endDate) {
            this.endDate = endDate;
        }

        public LocalDate getEndDate() {
            return this.endDate;
        }

        public void setPriority(Priority priority) {
            this.priority = priority;
        }

        public Priority getPriority() {
            return this.priority;
        }
    }

    static enum Priority {
        LOW,
        MEDIUM,
        HIGH;

    }

    class DragSettings
    extends VBox {
        public DragSettings(GraphicsBase<?> graphics) {
            this.setSpacing(10.0);
            ComboBox feedbackBox = new ComboBox();
            feedbackBox.getItems().addAll((Object[])GraphicsBase.DragAndDropFeedback.values());
            Bindings.bindBidirectional((Property)feedbackBox.valueProperty(), graphics.dragAndDropFeedbackProperty());
            this.getChildren().add((Object)feedbackBox);
            CheckBox autogrid = new CheckBox("Gantt 1: Autogrid");
            Bindings.bindBidirectional((Property)autogrid.selectedProperty(), (Property)graphics.autoGridEnabledProperty());
            this.getChildren().add((Object)autogrid);
            ChronoUnitGrid days = new ChronoUnitGrid("Days", ChronoUnit.DAYS, 1);
            ChronoUnitGrid hours = new ChronoUnitGrid("Hours", ChronoUnit.HOURS, 1);
            ChronoUnitGrid minutes = new ChronoUnitGrid("Minutes", ChronoUnit.MINUTES, 1);
            ObservableList gridList = FXCollections.observableArrayList((Object[])new VirtualGrid[]{days, hours, minutes});
            ComboBox gridBox = new ComboBox(gridList);
            this.getChildren().add((Object)gridBox);
            Bindings.bindBidirectional((Property)gridBox.valueProperty(), graphics.virtualGridProperty());
        }
    }
}

