/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.controls;

import com.flexganttfx.experimental.ColumnBrowser;
import com.flexganttfx.experimental.ColumnValuesList;
import java.util.ArrayList;
import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.MasterDetailPane;

public class HelloTableColumnBrowser
extends Application {
    private TableView<Person> table;
    private ColumnBrowser<Person> browser;
    private int counter = 1;

    public String getSampleName() {
        return "Column Browser";
    }

    public void start(Stage stage) throws Exception {
        this.table = new TableView();
        this.browser = new ColumnBrowser<Person>(this.table);
        TableColumn nameColumn = new TableColumn("Name");
        TableColumn professionColumn = new TableColumn("Profession");
        TableColumn ageColumn = new TableColumn("Age");
        TableColumn genderColumn = new TableColumn("Gender");
        TableColumn colorColumn = new TableColumn("Color");
        nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        professionColumn.setCellValueFactory((Callback)new PropertyValueFactory("profession"));
        ageColumn.setCellValueFactory((Callback)new PropertyValueFactory("age"));
        genderColumn.setCellValueFactory((Callback)new PropertyValueFactory("gender"));
        colorColumn.setCellValueFactory((Callback)new PropertyValueFactory("color"));
        colorColumn.setCellFactory((Callback)new Callback<TableColumn<Person, Color>, TableCell<Person, Color>>(){

            public TableCell<Person, Color> call(TableColumn<Person, Color> param) {
                return new TableCell<Person, Color>(){
                    private Region region;

                    protected void updateItem(Color item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (this.region == null) {
                            this.region = new Region();
                            this.setGraphic((Node)this.region);
                            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                        }
                        this.region.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)item, CornerRadii.EMPTY, Insets.EMPTY)}));
                    }
                };
            }
        });
        this.table.getColumns().add((Object)nameColumn);
        this.table.getColumns().add((Object)professionColumn);
        this.table.getColumns().add((Object)ageColumn);
        this.table.getColumns().add((Object)genderColumn);
        this.table.getColumns().add((Object)colorColumn);
        ColumnValuesList professionList = new ColumnValuesList(this.browser, professionColumn);
        ColumnValuesList ageList = new ColumnValuesList(this.browser, ageColumn);
        ColumnValuesList genderList = new ColumnValuesList(this.browser, genderColumn);
        ColumnValuesList colorList = new ColumnValuesList(this.browser, colorColumn);
        colorList.getListView().setCellFactory((Callback)new Callback<ListView<Color>, ListCell<Color>>(){

            public ListCell<Color> call(ListView<Color> param) {
                return new ListCell<Color>(){
                    private Region region;

                    protected void updateItem(Color item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (this.region == null) {
                            this.region = new Region();
                            this.setGraphic((Node)this.region);
                            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                        }
                        this.region.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)item, CornerRadii.EMPTY, Insets.EMPTY)}));
                    }
                };
            }
        });
        this.browser.getColumnValuesLists().add(professionList);
        this.browser.getColumnValuesLists().add(ageList);
        this.browser.getColumnValuesLists().add(genderList);
        this.browser.getColumnValuesLists().add(colorList);
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter(this.table);
        HBox buttonPane = new HBox();
        buttonPane.setAlignment(Pos.CENTER_RIGHT);
        borderPane.setBottom((Node)buttonPane);
        Button massItems = new Button("Stress");
        massItems.setOnAction(evt -> this.massItems());
        HBox.setMargin((Node)massItems, (Insets)new Insets(5.0));
        buttonPane.getChildren().add((Object)massItems);
        Button removeItems = new Button("Remove");
        removeItems.setOnAction(evt -> this.removeItems());
        HBox.setMargin((Node)removeItems, (Insets)new Insets(5.0));
        buttonPane.getChildren().add((Object)removeItems);
        Button addItems = new Button("Add");
        addItems.setOnAction(evt -> this.addItem());
        HBox.setMargin((Node)addItems, (Insets)new Insets(5.0));
        buttonPane.getChildren().add((Object)addItems);
        MasterDetailPane masterDetailPane = new MasterDetailPane(Side.TOP);
        masterDetailPane.setDetailNode((Node)this.browser);
        masterDetailPane.setMasterNode((Node)borderPane);
        this.addItem();
        this.addItem();
        this.addItem();
        this.addItem();
        stage.setScene(new Scene((Parent)masterDetailPane));
        stage.setWidth(500.0);
        stage.setHeight(500.0);
        stage.centerOnScreen();
        stage.show();
    }

    private void massItems() {
        ArrayList<Person> list = new ArrayList<Person>();
        for (int i = 0; i < 1000; ++i) {
            list.add(this.createItem());
        }
        this.browser.getItems().addAll(list);
    }

    private Person createItem() {
        return new Person("Person " + this.counter++, Math.max(20, (int)(Math.random() * 100.0)), Math.random() < 0.5 ? Gender.MALE : Gender.FEMALE);
    }

    private void addItem() {
        this.browser.getItems().add((Object)this.createItem());
    }

    private void removeItems() {
        for (Person person : this.table.getSelectionModel().getSelectedItems()) {
            this.table.getItems().remove((Object)person);
        }
    }

    public static void main(String[] args) {
        HelloTableColumnBrowser.launch((String[])args);
    }

    public class Person {
        private String name;
        private String profession;
        private Integer age;
        private Gender gender;
        private Color color;

        public Person(String name, int age, Gender gender) {
            this.name = name;
            this.age = age;
            this.gender = gender;
            switch ((int)(Math.random() * 5.0)) {
                case 0: {
                    this.color = Color.ORANGE;
                    break;
                }
                case 1: {
                    this.color = Color.LIGHTCYAN;
                    break;
                }
                case 2: {
                    this.color = Color.CORNFLOWERBLUE;
                    break;
                }
                case 3: {
                    this.color = Color.RED;
                    break;
                }
                case 4: {
                    this.color = Color.MOCCASIN;
                }
            }
            switch ((int)(Math.random() * 5.0)) {
                case 0: {
                    this.profession = "Software Developer";
                    break;
                }
                case 1: {
                    this.profession = "Marketing Manager";
                    break;
                }
                case 2: {
                    this.profession = "Project Manager";
                    break;
                }
                case 3: {
                    this.profession = "Requirements Engineer";
                    break;
                }
                case 4: {
                    this.profession = "Tester";
                    break;
                }
                case 5: {
                    this.profession = "Presales Consultant";
                    break;
                }
                case 6: {
                    this.profession = "Architect";
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getProfession() {
            return this.profession;
        }

        public Integer getAge() {
            return this.age;
        }

        public Gender getGender() {
            return this.gender;
        }

        public Color getColor() {
            return this.color;
        }
    }

    static enum Gender {
        MALE,
        FEMALE;

    }
}

