/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.controls;

import com.flexganttfx.experimental.AccordionPopOver;
import com.flexganttfx.experimental.PopOverHeader;
import com.flexganttfx.experimental.PopOverTitledPane;
import javafx.application.Application;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;

public class HelloAccordionPopOver
extends Application {
    private AccordionPopOver popOver;

    public void start(Stage stage) throws Exception {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setAlignment(Pos.CENTER);
        grid.setOnMouseClicked(evt -> {
            if (this.popOver != null && !this.popOver.isDetached()) {
                this.popOver.hide();
            }
        });
        for (int i = 0; i < 10; ++i) {
            Button button = new Button("Button " + i);
            grid.add((Node)button, i % 2, i / 2);
            button.setOnMouseClicked(this.showPopOver(button));
        }
        stage.setScene(new Scene((Parent)grid));
        stage.setWidth(500.0);
        stage.setHeight(500.0);
        stage.show();
    }

    private EventHandler<? super MouseEvent> showPopOver(Button button) {
        return evt -> {
            if (this.popOver != null && !this.popOver.isDetached() && this.popOver.isShowing()) {
                this.popOver.hide();
            } else if (evt.getClickCount() == 1) {
                this.popOver = this.createPopOver(button);
                this.popOver.show((Node)button, button.localToScreen(0.0, button.getLayoutY()).getX() + button.getWidth() - 4.0, evt.getScreenY());
            }
        };
    }

    private AccordionPopOver createPopOver(Button button) {
        AccordionPopOver popOver = new AccordionPopOver();
        PopOverHeader header = (PopOverHeader)popOver.getHeader();
        header.setTitle("A PopOver Control");
        header.setSubtitle("This example is using an accordion for its content");
        popOver.setTitle(button.getText());
        popOver.getPanes().add((Object)this.createTitledPane("Titled Pane 1"));
        popOver.getPanes().add((Object)this.createTitledPane("Titled Pane 2"));
        popOver.getPanes().add((Object)this.createTitledPane("Titled Pane 3"));
        popOver.getPanes().add((Object)this.createTitledPane("Titled Pane 4"));
        popOver.setExpandedPane((TitledPane)popOver.getPanes().get(0));
        popOver.setFooter((Node)new Footer());
        ColorPicker picker = (ColorPicker)header.getExtra();
        picker.valueProperty().addListener((value, oldColor, newColor) -> button.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)newColor, CornerRadii.EMPTY, Insets.EMPTY)})));
        return popOver;
    }

    private TitledPane createTitledPane(String title) {
        PopOverTitledPane pane = new PopOverTitledPane(title, (Node)new ExamplePane());
        pane.setTextAlignment(TextAlignment.LEFT);
        Pane connectivityArrow = (Pane)pane.lookup(".arrow");
        if (connectivityArrow != null) {
            connectivityArrow.translateXProperty().bind((ObservableValue)pane.widthProperty().subtract((ObservableNumberValue)connectivityArrow.widthProperty().multiply(2)));
        }
        return pane;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    class Footer
    extends FlowPane {
        public Footer() {
            super(Orientation.HORIZONTAL);
            this.setAlignment(Pos.CENTER_RIGHT);
            Button delete = new Button("Delete");
            this.getChildren().add((Object)delete);
            delete.setOnAction(evt -> {});
        }
    }

    class ExamplePane
    extends GridPane {
        private DatePicker datePicker = new DatePicker();
        private CheckBox milestone = new CheckBox("Milestone");
        private TextField durationField = new TextField();
        private TextField capacityField = new TextField();
        private Slider percentageSlider = new Slider(0.0, 100.0, 0.0);
        private Label percentageValueLabel = new Label();

        public ExamplePane() {
            Label timeLabel = new Label("Start Time:");
            timeLabel.setLabelFor((Node)this.datePicker);
            GridPane.setHalignment((Node)timeLabel, (HPos)HPos.RIGHT);
            this.add((Node)timeLabel, 0, 0);
            this.add((Node)this.datePicker, 1, 0);
            this.add((Node)this.milestone, 1, 1);
            Label durationLabel = new Label("Duration:");
            durationLabel.setLabelFor((Node)this.durationField);
            GridPane.setHalignment((Node)durationLabel, (HPos)HPos.RIGHT);
            this.add((Node)durationLabel, 0, 2);
            this.add((Node)this.durationField, 1, 2);
            Label percentageLabel = new Label("Completeness:");
            percentageLabel.setLabelFor((Node)this.percentageSlider);
            GridPane.setHalignment((Node)percentageLabel, (HPos)HPos.RIGHT);
            this.percentageValueLabel = new Label("0%");
            this.add((Node)percentageLabel, 0, 3);
            this.add((Node)this.percentageSlider, 1, 3);
            this.add((Node)this.percentageValueLabel, 2, 3);
            Label capacityLabel = new Label("Capacity Used:");
            capacityLabel.setLabelFor((Node)this.capacityField);
            GridPane.setHalignment((Node)capacityLabel, (HPos)HPos.RIGHT);
            this.add((Node)capacityLabel, 0, 4);
            this.add((Node)this.capacityField, 1, 4);
            this.setHgap(10.0);
            this.setVgap(10.0);
            this.durationField.disableProperty().bind((ObservableValue)this.milestone.selectedProperty());
        }
    }
}

