/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.container;

import com.flexganttfx.demo.FlexGanttFXSampleBase;
import com.flexganttfx.demo.HelloRow;
import com.flexganttfx.view.GanttChartLite;
import com.flexganttfx.view.container.QuadGanttChartLiteContainer;
import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.PropertySheet;

public class HelloQuadGanttChartLiteContainer
extends FlexGanttFXSampleBase {
    private QuadGanttChartLiteContainer quad;

    @Override
    public String getSampleName() {
        return "Quad Lite";
    }

    @Override
    public Node getPanel(Stage panel) {
        GanttChartLite chart1 = new GanttChartLite();
        GanttChartLite chart2 = new GanttChartLite();
        GanttChartLite chart3 = new GanttChartLite();
        GanttChartLite chart4 = new GanttChartLite();
        chart1.getRows().add((Object)new HelloRow("Row"));
        chart2.getRows().add((Object)new HelloRow("Row"));
        chart3.getRows().add((Object)new HelloRow("Row"));
        chart4.getRows().add((Object)new HelloRow("Row"));
        this.quad = new QuadGanttChartLiteContainer(chart1, chart2, chart3, chart4);
        return this.quad;
    }

    @Override
    public Node getControlPanel() {
        VBox vbox = new VBox(10.0);
        vbox.setFillWidth(true);
        Button single = new Button("Single");
        single.setMaxWidth(Double.MAX_VALUE);
        single.setOnAction(evt -> this.quad.showSingleChart());
        vbox.getChildren().add((Object)single);
        Button horizontalSplit = new Button("Horiz. Split");
        horizontalSplit.setMaxWidth(Double.MAX_VALUE);
        horizontalSplit.setOnAction(evt -> this.quad.showHorizontalSplitScreen(true));
        vbox.getChildren().add((Object)horizontalSplit);
        Button verticalSplit = new Button("Vert. Split");
        verticalSplit.setMaxWidth(Double.MAX_VALUE);
        verticalSplit.setOnAction(evt -> this.quad.showVerticalSplitScreen(true));
        vbox.getChildren().add((Object)verticalSplit);
        Button allFour = new Button("All Four");
        allFour.setMaxWidth(Double.MAX_VALUE);
        allFour.setOnAction(evt -> this.quad.showAllFour(true));
        vbox.getChildren().add((Object)allFour);
        Button replaceUpperLeft = new Button("Replace UL");
        replaceUpperLeft.setMaxWidth(Double.MAX_VALUE);
        replaceUpperLeft.setOnAction(evt -> this.replace(Corner.UPPER_LEFT));
        vbox.getChildren().add((Object)replaceUpperLeft);
        Button replaceUpperRight = new Button("Replace UR");
        replaceUpperRight.setMaxWidth(Double.MAX_VALUE);
        replaceUpperRight.setOnAction(evt -> this.replace(Corner.UPPER_RIGHT));
        vbox.getChildren().add((Object)replaceUpperRight);
        Button replaceLowerLeft = new Button("Replace LL");
        replaceLowerLeft.setMaxWidth(Double.MAX_VALUE);
        replaceLowerLeft.setOnAction(evt -> this.replace(Corner.LOWER_LEFT));
        vbox.getChildren().add((Object)replaceLowerLeft);
        Button replaceLowerRight = new Button("Replace LR");
        replaceLowerRight.setMaxWidth(Double.MAX_VALUE);
        replaceLowerRight.setOnAction(evt -> this.replace(Corner.LOWER_RIGHT));
        vbox.getChildren().add((Object)replaceLowerRight);
        PropertySheet propertySheet = new PropertySheet((ObservableList<PropertySheet.Item>)FXCollections.observableArrayList(this.quad.getPropertySheetItems()));
        VBox.setVgrow((Node)propertySheet, (Priority)Priority.ALWAYS);
        vbox.getChildren().add((Object)propertySheet);
        return vbox;
    }

    private void replace(Corner corner) {
        GanttChartLite replacement = new GanttChartLite();
        replacement.getRows().add((Object)new HelloRow("Row"));
        switch (corner) {
            case UPPER_LEFT: {
                this.quad.setUpperLeftGanttChart(replacement);
                break;
            }
            case UPPER_RIGHT: {
                this.quad.setUpperRightGanttChart(replacement);
                break;
            }
            case LOWER_LEFT: {
                this.quad.setLowerLeftGanttChart(replacement);
                break;
            }
            case LOWER_RIGHT: {
                this.quad.setLowerRightGanttChart(replacement);
            }
        }
    }

    @Override
    public String getSampleDescription() {
        return "A special multi Gantt chart container that is capable of displaying exactly four Gantt charts and keeping their layouts (same table width, same timeline) and their scrolling and zooming behavior in synch.";
    }

    @Override
    public String getJavaDocURL() {
        return this.getJavaDocBase() + "com/flexganttfx/view/container/QuadGanttChartLiteContainer.html";
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static enum Corner {
        UPPER_LEFT,
        UPPER_RIGHT,
        LOWER_LEFT,
        LOWER_RIGHT;

    }
}

