/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.container;

import com.flexganttfx.demo.FlexGanttFXSampleBase;
import com.flexganttfx.demo.gantt.HelloMSProjectGanttChart;
import com.flexganttfx.msproject.view.MSProjectGanttChart;
import com.flexganttfx.view.container.QuadGanttChartContainer;
import java.io.FileNotFoundException;
import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.PropertySheet;

public class HelloQuadGanttChartContainer
extends FlexGanttFXSampleBase {
    private QuadGanttChartContainer quad;

    @Override
    public String getSampleName() {
        return "Quad";
    }

    @Override
    public Node getPanel(Stage panel) {
        MSProjectGanttChart gc1 = this.createMSProjectGanttChart();
        MSProjectGanttChart gc2 = this.createMSProjectGanttChart();
        MSProjectGanttChart gc3 = this.createMSProjectGanttChart();
        MSProjectGanttChart gc4 = this.createMSProjectGanttChart();
        this.quad = new QuadGanttChartContainer(gc1, gc2, gc3, gc4);
        return this.quad;
    }

    protected MSProjectGanttChart createMSProjectGanttChart() {
        MSProjectGanttChart gc = new MSProjectGanttChart();
        try {
            gc.load("igrafx.mpp", HelloMSProjectGanttChart.class.getResourceAsStream("igrafx.mpp"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        gc.getTreeTable().getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        return gc;
    }

    @Override
    public Node getControlPanel() {
        VBox vbox = new VBox(10.0);
        vbox.setFillWidth(true);
        Button single = new Button("Single");
        single.setMaxWidth(Double.MAX_VALUE);
        single.setOnAction(evt -> this.quad.showSingleChart());
        vbox.getChildren().add((Object)single);
        Button horizontalSplit = new Button("Horiz. Split");
        horizontalSplit.setMaxWidth(Double.MAX_VALUE);
        horizontalSplit.setOnAction(evt -> this.quad.showHorizontalSplitScreen(true));
        vbox.getChildren().add((Object)horizontalSplit);
        Button verticalSplit = new Button("Vert. Split");
        verticalSplit.setMaxWidth(Double.MAX_VALUE);
        verticalSplit.setOnAction(evt -> this.quad.showVerticalSplitScreen(true));
        vbox.getChildren().add((Object)verticalSplit);
        Button allFour = new Button("All Four");
        allFour.setMaxWidth(Double.MAX_VALUE);
        allFour.setOnAction(evt -> this.quad.showAllFour(true));
        vbox.getChildren().add((Object)allFour);
        PropertySheet propertySheet = new PropertySheet((ObservableList<PropertySheet.Item>)FXCollections.observableArrayList(this.quad.getPropertySheetItems()));
        VBox.setVgrow((Node)propertySheet, (Priority)Priority.ALWAYS);
        vbox.getChildren().add((Object)propertySheet);
        return vbox;
    }

    @Override
    public String getSampleDescription() {
        return "A special multi Gantt chart container that is capable of displaying exactly four Gantt charts and keeping their layouts (same table width, same timeline) and their scrolling and zooming behavior in synch.";
    }

    @Override
    public String getJavaDocURL() {
        return this.getJavaDocBase() + "com/flexganttfx/view/container/QuadGanttChartContainer.html";
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

