/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.container;

import com.flexganttfx.demo.FlexGanttFXSampleBase;
import com.flexganttfx.model.Activity;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.GanttChartLite;
import com.flexganttfx.view.container.MultiGanttChartLiteContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.ListSelectionView;

public class HelloMultiGanttChartLiteContainer
extends FlexGanttFXSampleBase {
    private MultiGanttChartLiteContainer multiGanttChartContainer;
    private List<Entry> availableList;
    private List<Entry> selectedList;
    private ListSelectionView<Entry> listSV;
    private GanttChartLite<DemoRow> masterGC;

    @Override
    public Node getPanel(Stage stage) {
        int i;
        this.multiGanttChartContainer = new MultiGanttChartLiteContainer();
        this.masterGC = new GanttChartLite();
        this.masterGC.getGraphics().setShowVerticalCursor(true);
        this.masterGC.setId("gantt-master");
        this.masterGC.getRows().add((Object)new DemoRow("Master"));
        this.availableList = new ArrayList<Entry>();
        this.selectedList = new ArrayList<Entry>();
        for (i = 0; i < 3; ++i) {
            DemoRow row = new DemoRow("Chart #" + (i + 1));
            GanttChartLite gc = new GanttChartLite();
            gc.getRows().add((Object)row);
            gc.setId("chart-" + i);
            Entry entry = new Entry();
            entry.name = "Chart #" + (i + 1);
            entry.gc = gc;
            this.availableList.add(entry);
        }
        this.multiGanttChartContainer.getGanttCharts().add(this.masterGC);
        for (i = 0; i < 2; ++i) {
            this.multiGanttChartContainer.getGanttCharts().add(this.availableList.get((int)i).gc);
            this.selectedList.add(this.availableList.remove(i));
        }
        this.multiGanttChartContainer.resetDividerPositions();
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter((Node)this.multiGanttChartContainer);
        return borderPane;
    }

    @Override
    public Node getControlPanel() {
        this.listSV = new ListSelectionView();
        this.listSV.setPadding(new Insets(10.0));
        this.listSV.setOrientation(Orientation.VERTICAL);
        this.listSV.setCellFactory(new Callback<ListView<Entry>, ListCell<Entry>>(){

            public ListCell<Entry> call(ListView<Entry> param) {
                ListCell<Entry> cell = new ListCell<Entry>(){

                    protected void updateItem(Entry item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item.name);
                        }
                    }

                    public void updateIndex(int i) {
                        super.updateIndex(i);
                        if (i == -1) {
                            this.setText("");
                        }
                    }
                };
                return cell;
            }
        });
        this.listSV.getSourceItems().addAll(this.availableList);
        this.listSV.getTargetItems().addAll(this.selectedList);
        this.listSV.getTargetItems().addListener(observable -> this.updateContainer());
        return this.listSV;
    }

    private void updateContainer() {
        this.multiGanttChartContainer.getGanttCharts().setAll((Collection)this.listSV.getTargetItems().stream().map(entry -> entry.gc).collect(Collectors.toList()));
        this.multiGanttChartContainer.getGanttCharts().add(0, this.masterGC);
        Platform.runLater(() -> this.multiGanttChartContainer.resetDividerPositions());
    }

    @Override
    public String getSampleName() {
        return "Multi Lite";
    }

    @Override
    public String getSampleDescription() {
        return "The multi Gantt chart container class can be used to display an arbitrary number of Gantt charts. The list selection view below allows you to manipulate the list of charts shown.";
    }

    @Override
    public String getJavaDocURL() {
        return this.getJavaDocBase() + "com/flexganttfx/view/container/MultiGanttChartLiteContainer.html";
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    class Entry {
        String name;
        GanttChartLite<DemoRow> gc;

        Entry() {
        }
    }

    class DemoRow
    extends Row<DemoRow, DemoRow, Activity> {
        public DemoRow(String name) {
            super(name);
        }
    }
}

