/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo.container;

import com.flexganttfx.demo.FlexGanttFXSampleBase;
import com.flexganttfx.demo.HelloRow;
import com.flexganttfx.extras.GanttChartToolBar;
import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.container.DualGanttChartContainer;
import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import org.controlsfx.control.PropertySheet;

public class HelloDualGanttChartContainer
extends FlexGanttFXSampleBase {
    private DualGanttChartContainer dual;

    @Override
    public String getSampleName() {
        return "Dual";
    }

    @Override
    public Node getPanel(Stage panel) {
        GanttChart<HelloRow> gc1 = new GanttChart<HelloRow>();
        gc1.setRoot(new HelloRow("Root"));
        GanttChart<HelloRow> gc2 = new GanttChart<HelloRow>();
        gc2.setRoot(new HelloRow("Root"));
        this.dual = new DualGanttChartContainer(gc1, gc2);
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter((Node)this.dual);
        borderPane.setTop(new GanttChartToolBar(gc1));
        return borderPane;
    }

    @Override
    public Node getControlPanel() {
        return new PropertySheet((ObservableList<PropertySheet.Item>)FXCollections.observableArrayList(this.dual.getPropertySheetItems()));
    }

    @Override
    public String getSampleDescription() {
        return "A special multi Gantt chart container that is capable of displaying exactly two Gantt charts and keeping their layouts (same table width, same timeline) and their scrolling and zooming behavior in synch. The container distinguishes between a primary and a secondary Gantt chart, where the secondary Gantt chart is located in the detail node section of a MasterDetailPane. It can be hidden or shown on demand. Each one of the two Gantt charts can have its own header and footer.";
    }

    @Override
    public String getJavaDocURL() {
        return this.getJavaDocBase() + "com/flexganttfx/view/container/DualGanttChartContainer.html";
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

