/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.demo;

import com.flexganttfx.core.FlexGanttFX;
import com.flexganttfx.demo.FlexGanttFXSampleBase;
import com.flexganttfx.extras.GanttChartStatusBar;
import com.flexganttfx.extras.GanttChartToolBar;
import com.flexganttfx.view.GanttChartBase;
import com.flexganttfx.view.timeline.DatelineScrollingEvent;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;

public abstract class FlexGanttFXSample
extends FlexGanttFXSampleBase {
    private GanttChartBase<?> ganttChart;
    private GanttChartToolBar<?> toolbar;
    private GanttChartStatusBar<?> statusbar;
    private DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT);
    private boolean visible = true;
    private BorderPane ganttPane;

    protected FlexGanttFXSample() {
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public final boolean isVisible() {
        return this.visible;
    }

    @Override
    public final Node getPanel(Stage stage) {
        if (this.ganttPane != null) {
            return this.ganttPane;
        }
        try {
            this.ganttChart = this.createGanttChart();
            this.ganttChart.getTimeline().getDateline().addEventHandler(DatelineScrollingEvent.ANY_SCROLLING, evt -> {
                ZonedDateTime st = ZonedDateTime.ofInstant(evt.getStartTime(), ZoneId.systemDefault());
                ZonedDateTime et = ZonedDateTime.ofInstant(evt.getEndTime(), ZoneId.systemDefault());
                this.getStatusbar().setText(this.formatter.format(st) + " - " + this.formatter.format(et));
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.visible = false;
        }
        this.toolbar = new GanttChartToolBar(this.ganttChart);
        this.statusbar = new GanttChartStatusBar(this.ganttChart);
        this.ganttPane = new BorderPane();
        BorderPane.setMargin(this.ganttChart, (Insets)new Insets(10.0));
        this.ganttPane.setTop(this.toolbar);
        this.ganttPane.setCenter(this.ganttChart);
        this.ganttPane.setBottom(this.statusbar);
        return this.ganttPane;
    }

    protected final GanttChartBase<?> getGanttChart() {
        return this.ganttChart;
    }

    protected final GanttChartToolBar<?> getToolbar() {
        return this.toolbar;
    }

    protected final GanttChartStatusBar<?> getStatusbar() {
        return this.statusbar;
    }

    protected abstract GanttChartBase<?> createGanttChart() throws Exception;

    @Override
    public final String getProjectName() {
        return "FlexGanttFX";
    }

    @Override
    public final String getProjectVersion() {
        return FlexGanttFX.getVersion();
    }
}

